/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kth.dks.util.CancellationException;
import org.kth.dks.util.Future;
import org.kth.dks.util.TimeoutException;

public class AsyncOperation {
    static Map map = Collections.synchronizedMap(new HashMap());
    static long keyCounter = 0L;
    Future future;
    String key;
    Object state;

    AsyncOperation() {
    }

    public static AsyncOperation start() {
        return AsyncOperation.start(null);
    }

    public static AsyncOperation start(Object state) {
        AsyncOperation op = new AsyncOperation();
        op.key = Long.toString(keyCounter++);
        op.future = new Future();
        op.state = state;
        map.put(op.key, op);
        return op;
    }

    public String getKey() {
        return this.key;
    }

    public Object getState() {
        return this.state;
    }

    public void setState(Object state) {
        this.state = state;
    }

    public static AsyncOperation get(String key) {
        return (AsyncOperation)map.get(key);
    }

    public Object waitOn() throws InterruptedException, CancellationException, Exception {
        Object result = this.future.get();
        map.remove(this.key);
        return result;
    }

    public Object waitOn(long timeout) throws InterruptedException, TimeoutException, CancellationException {
        Object result = null;
        try {
            result = this.future.get(timeout);
        }
        catch (TimeoutException e) {
            map.remove(this.key);
            throw e;
        }
        map.remove(this.key);
        return result;
    }

    public void complete(Object result) {
        this.future.store(result);
    }

    public static void complete(String name, Object result) {
        AsyncOperation op = AsyncOperation.get(name);
        op.future.store(result);
    }

    public void cancel() {
        this.future.cancel(false);
        map.remove(this.key);
    }

    public void cancel(Exception ex) {
        this.future.cancel(ex);
        map.remove(this.key);
    }

    public void voidOperationMapping() {
        map.remove(this.key);
    }
}

