/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.planetlab.messages;

import java.io.IOException;
import java.util.ArrayList;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class LiveNodesMsg
extends DKSMessage {
    public static String NAME = "LIVE_NODES";
    private Type type;
    private int size;
    private ArrayList<DKSRef> refs;

    public LiveNodesMsg() {
    }

    public LiveNodesMsg(Type type, int size, ArrayList<DKSRef> refs) {
        this.type = type;
        this.size = size;
        this.refs = refs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getSize() {
        return this.size;
    }

    public Type getType() {
        return this.type;
    }

    public ArrayList<DKSRef> getRefs() {
        return this.refs;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addInt(this.type.ordinal(), "type");
        this.marshaler.addInt(this.size, "size");
        if (this.refs == null) {
            return;
        }
        for (int i = 0; i < this.refs.size(); ++i) {
            this.marshaler.addDKSRef(this.refs.get(i), "ref" + i);
        }
    }

    @Override
    public void unmarshal() throws IOException {
        int ord = this.marshaler.remInt("type");
        this.type = ord == 0 ? Type.REQUEST : (ord == 1 ? Type.REPLY : Type.CHOICE);
        this.size = this.marshaler.remInt("size");
        this.refs = new ArrayList();
        for (int i = 0; i < this.refs.size(); ++i) {
            this.refs.add(this.marshaler.remDKSRef("ref" + i));
        }
    }

    public static enum Type {
        REQUEST,
        REPLY,
        CHOICE;

    }
}

