/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.planetlab;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Random;
import org.kth.dks.DKSCallbackInterface;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_dht.DKSDHTCallback;
import org.kth.dks.dks_dht.DKSDHTImpl;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.DKSNode;
import org.kth.dks.planetlab.HostUtils;
import org.kth.dks.planetlab.messages.PingMsg;
import org.kth.dks.planetlab.messages.PongMsg;
import org.kth.dks.planetlab.messages.StrechMeasurementMsg;
import org.kth.dks.util.AsyncOperation;
import org.kth.dks.util.OperationType;

public class StrechMeter
extends Thread
implements DKSDHTCallback {
    public static final int pingTimeout = 60;
    private String hostname;
    private boolean mysqlGateway;
    private DKSDHTImpl thisNode;
    private Connection connection;
    private PreparedStatement psStrech;
    private PreparedStatement psConnectivity;
    private static Random random = new Random();
    private DKSRef myDKSRef;
    private DKSRef currentResponsible;
    private DKSRef mySQLNode;
    DKSCallbackInterface dks = null;

    public StrechMeter(String hostname, boolean mysqlGateway, DKSRef mySQLNode) {
        this.hostname = hostname;
        this.mysqlGateway = mysqlGateway;
        this.mySQLNode = mySQLNode;
        this.setName(StrechMeter.class.getName());
    }

    public void setThisDKSDHTImpl(DKSDHTImpl DKSnode) {
        this.thisNode = DKSnode;
    }

    @Override
    public void run() {
        System.out.println("************ hostname=" + this.hostname + ", thisNode=" + this.thisNode + ", meIsMySQL=" + this.mysqlGateway + ", mySQLNODE=" + this.mySQLNode);
        if (this.mysqlGateway) {
            this.connectToMySQL();
        }
        this.myDKSRef = this.thisNode.myDKSImpl.getDKSRef();
        long intIP = HostUtils.getDKSRefAsint(this.myDKSRef);
        while (true) {
            int dksRtt;
            this.sleepRandom();
            do {
                dksRtt = this.sendRandomLookup();
            } while (this.currentResponsible == null);
            int directRtt = this.sendDirectPing(this.currentResponsible);
            if (directRtt == -1) continue;
            if (this.mysqlGateway) {
                this.insertResultIntoDB(intIP, HostUtils.getDKSRefAsint(this.currentResponsible), dksRtt, directRtt, this.myDKSRef, this.hostname);
                continue;
            }
            StrechMeasurementMsg msg = new StrechMeasurementMsg(this.hostname, this.myDKSRef, intIP, HostUtils.getDKSRefAsint(this.currentResponsible), dksRtt, directRtt);
            this.thisNode.myDKSImpl.routeAsync(this.mySQLNode.getID(), new DKSObject(msg.flatten()));
        }
    }

    public int sendRandomLookup() {
        long key = random.nextLong() % DKSNode.N;
        System.out.println("SENDING RANDOM LOOKUP (" + key + ")");
        long sentTime = System.currentTimeMillis();
        this.currentResponsible = this.thisNode.findResponsible(key);
        long receivedTime = System.currentTimeMillis();
        return (int)(receivedTime - sentTime);
    }

    public int sendDirectPing(DKSRef target) {
        long sentTime = System.currentTimeMillis();
        AsyncOperation pingOp = AsyncOperation.start(OperationType.FINDTYPE);
        PingMsg pingMsg = new PingMsg(sentTime, pingOp.getKey());
        this.thisNode.myDKSImpl.send(target, pingMsg);
        System.out.println("Sent PING to " + target.getIP());
        Integer rtt = null;
        try {
            rtt = (Integer)pingOp.waitOn(60000L);
        }
        catch (Exception e) {
            pingOp.cancel();
            System.err.println("***PING TIMEOUT***");
            return -1;
        }
        if (rtt == null) {
            return -1;
        }
        return rtt;
    }

    public void pingMsgHandler(DKSRef source, PingMsg msg) {
        this.thisNode.myDKSImpl.send(source, new PongMsg(msg.getTimestamp(), msg.getMsgId()));
        System.out.println("Replied to PING from " + source.getIP());
    }

    public void pongMsgHandler(DKSRef source, PongMsg msg) {
        long rtt = System.currentTimeMillis() - msg.getTimestamp();
        AsyncOperation.complete(msg.getMsgId(), new Integer((int)rtt));
        System.out.println("Received PONG from " + source.getIP());
    }

    public void strechMeasurementMsgHandler(DKSRef source, StrechMeasurementMsg msg) {
        this.insertResultIntoDB(msg.getFromIp(), msg.getToIp(), msg.getDksRttMs(), msg.getIpRttMs(), source, msg.getFromHostname());
    }

    @Override
    public void dhtBroadcastCallback(DKSObject value) {
    }

    @Override
    public DKSMessage dhtRouteCallback(long identifier, DKSMessage msg) {
        if (msg instanceof StrechMeasurementMsg) {
            StrechMeasurementMsg strechMsg = (StrechMeasurementMsg)msg;
            this.insertResultIntoDB(strechMsg.getFromIp(), strechMsg.getToIp(), strechMsg.getDksRttMs(), strechMsg.getIpRttMs(), strechMsg.getFromDKSRef(), strechMsg.getFromHostname());
        } else {
            System.err.println("*********Received unknown message********");
        }
        return null;
    }

    @Override
    public void dhtRouteCallbackAsync(long identifier, DKSMessage msg) {
        if (msg instanceof StrechMeasurementMsg) {
            StrechMeasurementMsg strechMsg = (StrechMeasurementMsg)msg;
            this.insertResultIntoDB(strechMsg.getFromIp(), strechMsg.getToIp(), strechMsg.getDksRttMs(), strechMsg.getIpRttMs(), strechMsg.getFromDKSRef(), strechMsg.getFromHostname());
        } else {
            System.err.println("*********Received unknown message********");
        }
    }

    public void insertResultIntoDB(long fromIp, long toIp, int dksRttMs, int ipRttMs, DKSRef from, String hostname) {
        double strech = (double)dksRttMs / (double)ipRttMs;
        try {
            this.psStrech.setLong(1, fromIp);
            this.psStrech.setLong(2, toIp);
            this.psStrech.setInt(3, dksRttMs);
            this.psStrech.setInt(4, ipRttMs);
            this.psStrech.setDouble(5, strech);
            this.psStrech.executeUpdate();
            this.psConnectivity.setString(1, hostname);
            this.psConnectivity.setString(2, from.getIP());
            this.psConnectivity.setInt(3, from.getPort());
            this.psConnectivity.setInt(4, (int)from.getID());
            this.psConnectivity.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void connectToMySQL() {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            this.connection = DriverManager.getConnection("jdbc:mysql://193.10.67.72/dks?user=dks&password=DKS");
            this.psConnectivity = this.connection.prepareStatement("INSERT INTO connectivity VALUES(?, ?, ?, ?, now())");
            this.psStrech = this.connection.prepareStatement("INSERT INTO address_strech VALUES(?, ?, ?, ?, ?)");
        }
        catch (SQLException ex) {
            System.out.println("SQLException: " + ex.getMessage());
            System.out.println("SQLState: " + ex.getSQLState());
            System.out.println("VendorError: " + ex.getErrorCode());
            System.exit(1);
        }
        catch (IllegalAccessException ex) {
            System.err.println("Can't load com.mysql.jdbc.Driver class!");
            System.exit(1);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Can't load com.mysql.jdbc.Driver class!");
            System.exit(1);
        }
        catch (InstantiationException ex) {
            System.err.println("Can't load com.mysql.jdbc.Driver class!");
            System.exit(1);
        }
    }

    public void sleepRandom() {
        int rand = random.nextInt(20);
        try {
            System.out.println("SLEEPING(" + rand + ") secs");
            Thread.sleep(rand * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

