/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.planetlab;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_dht.DKSDHTCallback;
import org.kth.dks.dks_dht.DKSDHTImpl;
import org.kth.dks.dks_exceptions.DKSIdentifierAlreadyTaken;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_exceptions.DKSTooManyRestartJoins;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.DKSNode;
import org.kth.dks.planetlab.HostUtils;
import org.kth.dks.planetlab.KeepAliveThread;
import org.kth.dks.planetlab.messages.KeepAliveMsg;
import org.kth.dks.planetlab.messages.LiveNodesMsg;
import org.kth.dks.planetlab.messages.PingMsg;
import org.kth.dks.planetlab.messages.PongMsg;
import org.kth.dks.planetlab.messages.StrechMeasurementMsg;
import org.kth.dks.util.AsyncOperation;
import org.kth.dks.util.OperationType;

public class PlanetLabDKS
implements DKSDHTCallback {
    private static Logger log = Logger.getLogger(PlanetLabDKS.class);
    private static long myID;
    private static int myPort;
    private static String myIP;
    private static String myHostname;
    private static long myLongIp;
    private static final String bootstrapIp = "193.10.64.35";
    private static final long bootstrapID;
    private static final int aliveSeconds = 900;
    private static final int keepAliveInterval = 300;
    private static final int pingTimeout = 60;
    private static final int minRandomSleep = 10;
    private static final int maxRandomSleep = 20;
    private ConnectionManager cm = null;
    private DKSDHTImpl dks = null;
    private DKSOverlayAddress myOA = null;
    private DKSRef myDKSRef = null;
    private DKSRef bootDKSRef = null;
    private boolean direct = false;
    private PreparedStatement psConnSelect = null;
    private PreparedStatement psConnReplace = null;
    private PreparedStatement psConnIncLoad = null;
    private PreparedStatement psStrech = null;
    private Object lock = null;
    private LiveNodesMsg message = null;
    private Random random = null;
    private DKSRef currentResponsible = null;

    public static void main(String[] args) {
        PlanetLabDKS.checkUsage(args);
        PropertyConfigurator.configure((String)System.getProperty("org.apache.log4j.config.file"));
        log.info((Object)"log4j properly configured");
        PlanetLabDKS object = new PlanetLabDKS();
        object.go();
    }

    private void go() {
        try {
            this.cm = ConnectionManager.getInstanceMultiHome(myPort, InetAddress.getByName(myIP));
            this.cm.getWebServer().setHostname(myHostname);
            this.cm.getWebServer().setIp(myIP);
            this.cm.getWebServer().setPort(new Integer(myPort).toString());
            this.myDKSRef = DKSRef.valueOf("dksref://" + myIP + ":" + myPort + "/0/" + myID + "/0/0");
            this.bootDKSRef = DKSRef.valueOf("dksref://193.10.64.35:" + myPort + "/0/" + bootstrapID + "/0/0");
            this.myOA = new DKSOverlayAddress("DKSOverlay://0/" + myID + "/0");
            this.dks = new DKSDHTImpl(this.cm, this.myOA, this);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            System.exit(1);
        }
        this.random = new Random();
        Connection connection = this.checkMySQLConnectivity();
        if (connection != null) {
            this.actAsDirectlyConnectedNode(connection);
        } else {
            this.actAsNonConnectedNode();
        }
    }

    private void actAsDirectlyConnectedNode(Connection connection) {
        log.debug((Object)"ACTING AS DIRECT-CONNECTED");
        this.direct = true;
        this.prepareMySQLStatements(connection);
        this.installMessageHandlers();
        ArrayList<DKSRef> activeNodes = this.getActiveNodes(900);
        if (activeNodes == null) {
            System.exit(1);
        }
        if (activeNodes.size() == 0) {
            this.dks.create();
        } else {
            boolean joined = false;
            do {
                int which = this.random.nextInt(activeNodes.size());
                DKSRef ref = activeNodes.get(which);
                try {
                    this.dks.join(ref);
                    joined = true;
                }
                catch (DKSTooManyRestartJoins e) {
                    log.error((Object)e.getMessage());
                }
                catch (DKSIdentifierAlreadyTaken e) {
                    log.error((Object)e.getMessage());
                }
                catch (DKSRefNoResponse e) {
                    log.error((Object)e.getMessage());
                }
                activeNodes.remove(which);
            } while (!joined && !activeNodes.isEmpty());
            if (!joined) {
                log.fatal((Object)"Could not contact any active nodes");
                System.exit(1);
            }
        }
        log.info((Object)"COMPLETED JOIN");
        this.keepAlive(myLongIp, myHostname, myIP, myPort, myID, true);
        this.work();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actAsNonConnectedNode() {
        log.debug((Object)"ACTING AS NON-CONNECTED");
        this.direct = false;
        this.lock = new Object();
        this.installMessageHandlers();
        LiveNodesMsg request = new LiveNodesMsg(LiveNodesMsg.Type.REQUEST, 0, null);
        Random random = new Random();
        boolean joined = false;
        DKSRef myDCNDKSRef = null;
        while (true) {
            this.dks.send(this.bootDKSRef, request);
            Object object = this.lock;
            synchronized (object) {
                while (this.message == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            ArrayList<DKSRef> refs = this.message.getRefs();
            if (refs.size() == 0) continue;
            do {
                int which = random.nextInt(refs.size());
                DKSRef ref = refs.get(which);
                try {
                    this.dks.join(ref);
                    myDCNDKSRef = ref;
                    joined = true;
                }
                catch (DKSTooManyRestartJoins e) {
                    log.error((Object)e.getMessage());
                }
                catch (DKSIdentifierAlreadyTaken e) {
                    log.error((Object)e.getMessage());
                }
                catch (DKSRefNoResponse e) {
                    log.error((Object)e.getMessage());
                }
                refs.remove(which);
            } while (!joined && !refs.isEmpty());
            if (joined) break;
        }
        ArrayList<DKSRef> list = new ArrayList<DKSRef>();
        list.add(myDCNDKSRef);
        LiveNodesMsg choice = new LiveNodesMsg(LiveNodesMsg.Type.CHOICE, 1, list);
        this.dks.send(myDCNDKSRef, choice);
        log.info((Object)"COMPLETED JOIN");
        this.keepAlive(myLongIp, myHostname, myIP, myPort, myID, false);
        this.work();
    }

    private void work() {
        new KeepAliveThread(300, this).start();
        while (true) {
            int dksRtt;
            this.sleepRandom();
            do {
                dksRtt = this.sendRandomLookup();
            } while (this.currentResponsible == null || this.currentResponsible.equals(this.myDKSRef));
            int directRtt = this.sendDirectPing(this.currentResponsible);
            if (directRtt == -1) continue;
            this.storeMeasurement(myLongIp, HostUtils.getIpAsLong(this.currentResponsible.getIP()), dksRtt, directRtt, this.myDKSRef, myHostname);
        }
    }

    private int sendRandomLookup() {
        long key = this.random.nextLong() % DKSNode.N;
        log.info((Object)("SENDING RANDOM LOOKUP (" + key + ")"));
        long sentTime = System.currentTimeMillis();
        this.currentResponsible = this.dks.findResponsible(key);
        long receivedTime = System.currentTimeMillis();
        return (int)(receivedTime - sentTime);
    }

    public int sendDirectPing(DKSRef target) {
        long sentTime = System.currentTimeMillis();
        AsyncOperation pingOp = AsyncOperation.start(OperationType.FINDTYPE);
        PingMsg pingMsg = new PingMsg(sentTime, pingOp.getKey());
        this.dks.send(target, pingMsg);
        log.info((Object)("Sent PING to " + target.getIP()));
        Integer rtt = null;
        try {
            rtt = (Integer)pingOp.waitOn(60000L);
        }
        catch (Exception e) {
            pingOp.cancel();
            log.error((Object)"***PING TIMEOUT***");
            return -1;
        }
        if (rtt == null) {
            return -1;
        }
        return rtt;
    }

    private void prepareMySQLStatements(Connection connection) {
        try {
            this.psConnSelect = connection.prepareStatement("SELECT c.IP, c.PORT, c.ID FROM connectivity c WHERE TIME_TO_SEC(TIMEDIFF(LAST_SEEN, now())) <= ?  AND c.DC=true ORDER BY c.LOAD ASC");
            this.psConnReplace = connection.prepareStatement("INSERT INTO connectivity(LONGIP, HOSTNAME, IP, PORT, ID, LAST_SEEN, DC) VALUES(?, ?, ?, ?, ?, now(), ?) ON DUPLICATE KEY UPDATE LAST_SEEN=now()");
            this.psConnIncLoad = connection.prepareStatement("UPDATE connectivity SET LOAD=LOAD+1 WHERE LONGIP = ?");
            this.psStrech = connection.prepareStatement("INSERT INTO address_strech VALUES(?, ?, ?, ?, ?)");
        }
        catch (SQLException e) {
            log.error((Object)("Exception preparing statements: " + e.getMessage()));
            System.exit(1);
        }
    }

    private void installMessageHandlers() {
        DKSMessage.addMessageTypePrefixed(PingMsg.NAME, "planetlab.messages.PingMsg");
        this.dks.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(this.myOA, "planetlab.messages.PingMsg", "planetlab.PlanetLabDKS", "pingMsgHandler", this);
        DKSMessage.addMessageTypePrefixed(PongMsg.NAME, "planetlab.messages.PongMsg");
        this.dks.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(this.myOA, "planetlab.messages.PongMsg", "planetlab.PlanetLabDKS", "pongMsgHandler", this);
        DKSMessage.addMessageTypePrefixed(StrechMeasurementMsg.NAME, "planetlab.messages.StrechMeasurementMsg");
        this.dks.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(this.myOA, "planetlab.messages.StrechMeasurementMsg", "planetlab.PlanetLabDKS", "strechMeasurementMsgHandler", this);
        DKSMessage.addMessageTypePrefixed(LiveNodesMsg.NAME, "planetlab.messages.LiveNodesMsg");
        this.dks.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(this.myOA, "planetlab.messages.LiveNodesMsg", "planetlab.PlanetLabDKS", "liveNodesMsgHandler", this);
        DKSMessage.addMessageTypePrefixed(KeepAliveMsg.NAME, "planetlab.messages.KeepAliveMsg");
        this.dks.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(this.myOA, "planetlab.messages.KeepAliveMsg", "planetlab.PlanetLabDKS", "keepAliveMsgHandler", this);
    }

    private synchronized void storeMeasurement(long fromIp, long toIp, int dksRttMs, int ipRttMs, DKSRef from, String hostname) {
        if (this.direct) {
            double strech = (double)dksRttMs / (double)ipRttMs;
            try {
                this.psStrech.setLong(1, fromIp);
                this.psStrech.setLong(2, toIp);
                this.psStrech.setInt(3, dksRttMs);
                this.psStrech.setInt(4, ipRttMs);
                this.psStrech.setDouble(5, strech);
                this.psStrech.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            StrechMeasurementMsg msg = new StrechMeasurementMsg(hostname, from, fromIp, toIp, dksRttMs, ipRttMs);
            this.dks.send(this.myDKSRef, msg);
        }
    }

    private synchronized void keepAlive(long longIp, String hostname, String ip, int port, long id, boolean dc) {
        if (this.direct) {
            try {
                this.psConnReplace.setLong(1, longIp);
                this.psConnReplace.setString(2, hostname);
                this.psConnReplace.setString(3, ip);
                this.psConnReplace.setInt(4, port);
                this.psConnReplace.setLong(5, id);
                this.psConnReplace.setBoolean(6, dc);
                this.psConnReplace.executeUpdate();
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
        } else {
            KeepAliveMsg msg = new KeepAliveMsg(longIp, hostname, ip, port, id, dc);
            this.dks.send(this.myDKSRef, msg);
        }
    }

    public void sendKeepAlive() {
        this.keepAlive(myLongIp, myHostname, myIP, myPort, myID, this.direct);
    }

    private synchronized ArrayList<DKSRef> getActiveNodes(int seconds) {
        try {
            this.psConnSelect.setInt(1, seconds);
            ArrayList<DKSRef> activeNodes = new ArrayList<DKSRef>();
            ResultSet rs = this.psConnSelect.executeQuery();
            while (rs.next()) {
                String ip = rs.getString(1);
                int port = rs.getInt(2);
                long id = rs.getLong(3);
                activeNodes.add(DKSRef.valueOf("dksref://" + ip + ":" + port + "/0/" + id + "/0/0"));
            }
            return activeNodes;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return null;
        }
    }

    private synchronized void incrementLoad(DKSRef ref) {
        long longIp = HostUtils.getIpAsLong(ref.getIP());
        try {
            this.psConnIncLoad.setLong(1, longIp);
            this.psConnIncLoad.executeUpdate();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void pingMsgHandler(DKSRef source, PingMsg msg) {
        this.dks.myDKSImpl.send(source, new PongMsg(msg.getTimestamp(), msg.getMsgId()));
        log.info((Object)("Replied to PING from " + source.getIP()));
    }

    public void pongMsgHandler(DKSRef source, PongMsg msg) {
        long rtt = System.currentTimeMillis() - msg.getTimestamp();
        AsyncOperation.complete(msg.getMsgId(), new Integer((int)rtt));
        log.info((Object)("Received PONG from " + source.getIP()));
    }

    public void strechMeasurementMsgHandler(DKSRef source, StrechMeasurementMsg msg) {
        this.storeMeasurement(msg.getFromIp(), msg.getToIp(), msg.getDksRttMs(), msg.getIpRttMs(), source, msg.getFromHostname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void liveNodesMsgHandler(DKSRef source, LiveNodesMsg msg) {
        log.debug((Object)("***LiveNodesMsg received from " + source));
        if (this.direct) {
            if (msg.getType() == LiveNodesMsg.Type.REQUEST) {
                ArrayList<DKSRef> refs = this.getActiveNodes(900);
                LiveNodesMsg reply = new LiveNodesMsg(LiveNodesMsg.Type.REPLY, refs.size(), refs);
                this.dks.send(source, reply);
            } else if (msg.getType() == LiveNodesMsg.Type.CHOICE) {
                if (msg.getSize() > 0) {
                    DKSRef ref = msg.getRefs().get(0);
                    this.incrementLoad(ref);
                }
            } else {
                log.fatal((Object)"DCN received REPLY msg.");
            }
        } else if (msg.getType() == LiveNodesMsg.Type.REPLY) {
            Object object = this.lock;
            synchronized (object) {
                this.message = msg;
                this.lock.notify();
            }
        } else {
            log.fatal((Object)"IDC received REQUEST or CHOICE msg.");
        }
    }

    public void keepAliveMsgHandler(DKSRef source, KeepAliveMsg msg) {
        if (this.direct) {
            this.keepAlive(msg.getLongIp(), msg.getHostname(), msg.getIp(), msg.getPort(), msg.getId(), msg.isDc());
        } else {
            log.fatal((Object)"IDC received KEEP_ALIVE message!");
        }
    }

    @Override
    public void dhtBroadcastCallback(DKSObject value) {
    }

    @Override
    public DKSMessage dhtRouteCallback(long identifier, DKSMessage msg) {
        if (msg instanceof StrechMeasurementMsg) {
            StrechMeasurementMsg strechMsg = (StrechMeasurementMsg)msg;
            this.storeMeasurement(strechMsg.getFromIp(), strechMsg.getToIp(), strechMsg.getDksRttMs(), strechMsg.getIpRttMs(), strechMsg.getFromDKSRef(), strechMsg.getFromHostname());
        } else {
            log.fatal((Object)"*********Received unknown message********");
        }
        return null;
    }

    @Override
    public void dhtRouteCallbackAsync(long identifier, DKSMessage msg) {
        if (msg instanceof StrechMeasurementMsg) {
            StrechMeasurementMsg strechMsg = (StrechMeasurementMsg)msg;
            this.storeMeasurement(strechMsg.getFromIp(), strechMsg.getToIp(), strechMsg.getDksRttMs(), strechMsg.getIpRttMs(), strechMsg.getFromDKSRef(), strechMsg.getFromHostname());
        } else {
            log.fatal((Object)"*********Received unknown message********");
        }
    }

    private Connection checkMySQLConnectivity() {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            Connection connection = DriverManager.getConnection("jdbc:mysql://193.10.67.72/dks?user=dks&password=DKS");
            return connection;
        }
        catch (SQLException ex) {
            log.error((Object)ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            log.error((Object)"Can't load com.mysql.jdbc.Driver class!");
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)"Can't load com.mysql.jdbc.Driver class!");
        }
        catch (InstantiationException ex) {
            log.error((Object)"Can't load com.mysql.jdbc.Driver class!");
        }
        return null;
    }

    private void sleepRandom() {
        int rand = this.random.nextInt(10) + 10;
        try {
            log.info((Object)("SLEEPING(" + rand + ") secs"));
            Thread.sleep(rand * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void checkUsage(String[] args) {
        if (args.length == 4) {
            myHostname = args[0];
            myIP = args[1];
            myPort = Integer.parseInt(args[2]);
            myID = Long.parseLong(args[3], 16);
            myLongIp = HostUtils.getIpAsLong(myIP);
            return;
        }
        System.err.println("Usage: PlanetLabDKS <hostname> <bindIP> <bindPort> <dksID>");
        System.exit(1);
    }

    static {
        bootstrapID = Long.parseLong("0b4c3243", 16);
    }
}

