/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.planetlab;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.kth.dks.dks_comm.DKSRef;

public class HostUtils {
    public static int getDKSRefAsint(DKSRef ref) {
        System.out.println("IP=" + ref.getIP());
        System.out.println("long=" + HostUtils.getIpAsLong(ref.getIP()));
        System.out.println("int=" + (int)HostUtils.getIpAsLong(ref.getIP()));
        return (int)HostUtils.getIpAsLong(ref.getIP());
    }

    public static long getIpAsLong(String ip) {
        long octet;
        long ret = 0L;
        StringTokenizer st = new StringTokenizer(ip, ".");
        if (!st.hasMoreTokens()) {
            return -1L;
        }
        ret = octet = (long)Integer.parseInt(st.nextToken());
        if (!st.hasMoreTokens()) {
            return -1L;
        }
        octet = Integer.parseInt(st.nextToken());
        ret = (ret << 8) + octet;
        if (!st.hasMoreTokens()) {
            return -1L;
        }
        octet = Integer.parseInt(st.nextToken());
        ret = (ret << 8) + octet;
        if (!st.hasMoreTokens()) {
            return -1L;
        }
        octet = Integer.parseInt(st.nextToken());
        ret = (ret << 8) + octet;
        return ret;
    }

    private static String getIpAsString(int ip) {
        int octet = ip & 0xFF;
        String ret = new Integer(octet).toString();
        octet = (ip >>= 8) & 0xFF;
        ret = new Integer(octet).toString() + "." + ret;
        octet = (ip >>= 8) & 0xFF;
        ret = new Integer(octet).toString() + "." + ret;
        octet = (ip >>= 8) & 0xFF;
        ret = new Integer(octet).toString() + "." + ret;
        return ret;
    }

    private static Inet4Address getNonLoopbackInet4Address() {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.getName().matches("eth*")) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.getAddress().length != 32) continue;
                    return (Inet4Address)address;
                }
            }
            return null;
        }
        catch (SocketException e) {
            e.printStackTrace();
            return null;
        }
    }
}

