/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_node;

import java.util.LinkedList;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.util.MathMisc;

public class RoutingTree {
    int a_levels;
    int a_k_factor;
    long a_adrRange;
    DKSRef a_myRef;
    private LevelEntry[][] tree;

    public RoutingTree(long adrRange, int k_factor, int levels, DKSRef ref) {
        this.a_levels = levels;
        this.a_k_factor = k_factor;
        this.a_adrRange = adrRange;
        this.a_myRef = ref;
        this.tree = new LevelEntry[this.a_levels + 1][this.a_k_factor];
        for (int l = 1; l <= this.a_levels; ++l) {
            for (int j = 0; j < k_factor; ++j) {
                long tmp = MathMisc.nThroughKPowerL(adrRange, this.a_k_factor, l);
                long begin = MathMisc.modPlus(ref.getID(), (long)j * tmp, adrRange);
                long end = MathMisc.modPlus(ref.getID(), (long)(j + 1) * tmp, adrRange);
                this.tree[l][j] = new LevelEntry(begin, end, ref);
            }
        }
    }

    public void foundNewNode(DKSRef ref) {
        for (int l = 1; l <= this.a_levels; ++l) {
            for (int j = 0; j < this.a_k_factor; ++j) {
                long newDistance;
                LevelEntry tmp = this.tree[l][j];
                long curDistance = MathMisc.distanceClockWise(tmp.a_begin, tmp.a_responsible.getID(), this.a_adrRange);
                if (curDistance <= (newDistance = MathMisc.distanceClockWise(tmp.a_begin, ref.getID(), this.a_adrRange))) continue;
                tmp.a_responsible = ref;
            }
        }
    }

    public boolean nodeLost(DKSRef ref) {
        boolean ans = false;
        for (int l = 1; l <= this.a_levels; ++l) {
            for (int j = 0; j < this.a_k_factor; ++j) {
                LevelEntry tmp = this.tree[l][j];
                if (!tmp.a_responsible.equals(ref)) continue;
                tmp.a_responsible = this.a_myRef;
                ans = true;
            }
        }
        return ans;
    }

    public LinkedList toList() {
        LinkedList<DKSRef> lst = new LinkedList<DKSRef>();
        for (int l = 1; l <= this.a_levels; ++l) {
            for (int j = 0; j < this.a_k_factor; ++j) {
                LevelEntry tmp = this.tree[l][j];
                lst.add(tmp.a_responsible);
            }
        }
        return lst;
    }

    DKSRef getIntervalResp(long target) {
        DKSRef ans = this.a_myRef;
        for (int l = 1; l <= this.a_levels; ++l) {
            for (int j = 0; j < this.a_k_factor; ++j) {
                LevelEntry tmp = this.tree[l][j];
                if (!MathMisc.belongsToI(target, tmp.a_begin, tmp.a_end, this.a_adrRange)) continue;
                ans = tmp.a_responsible;
            }
        }
        return ans;
    }

    long getIntervalStart(long target) {
        long start = target;
        for (int l = 1; l <= this.a_levels; ++l) {
            for (int j = 0; j < this.a_k_factor; ++j) {
                LevelEntry tmp = this.tree[l][j];
                if (!MathMisc.belongsToI(target, tmp.a_begin, tmp.a_end, this.a_adrRange)) continue;
                start = tmp.a_begin;
            }
        }
        return start;
    }

    public String toString() {
        String ans = "";
        for (int l = 1; l <= this.a_levels; ++l) {
            ans = ans + l + " :: ";
            for (int j = 0; j < this.a_k_factor; ++j) {
                LevelEntry tmp = this.tree[l][j];
                ans = ans + "\t" + tmp.a_begin + " - " + tmp.a_end + " = " + tmp.a_responsible.getID();
            }
            ans = ans + "\n";
        }
        return ans;
    }

    public long getBegin(int l, int i) {
        return this.tree[l][i].a_begin;
    }

    public long getEnd(int l, int i) {
        return this.tree[l][i].a_end;
    }

    public DKSRef getResponsible(int l, int i) {
        return this.tree[l][i].a_responsible;
    }

    public int getLevels() {
        return this.a_levels;
    }

    public int getKfactor() {
        return this.a_k_factor;
    }

    class LevelEntry {
        public long a_begin = -1L;
        public long a_end = -1L;
        public DKSRef a_responsible = null;

        LevelEntry(long begin, long end, DKSRef resp) {
            this.a_begin = begin;
            this.a_end = end;
            this.a_responsible = resp;
        }

        LevelEntry() {
        }
    }
}

