/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_node;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.util.MathMisc;

class OrderedDKSRefList
implements List {
    private LinkedList list = new LinkedList();
    private DKSRef myDKSRef;
    private int length;
    private long addrRange;
    private boolean clockwise;

    OrderedDKSRefList(DKSRef me, int len, long ar, boolean s) {
        this.myDKSRef = me;
        this.length = len;
        this.addrRange = ar;
        this.clockwise = s;
    }

    @Override
    public Object getFirst() {
        DKSRef ans = null;
        try {
            ans = (DKSRef)this.list.getFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ans;
    }

    @Override
    public boolean add(Object oref) {
        DKSRef ref = (DKSRef)oref;
        for (int i = 0; i < this.list.size(); ++i) {
            DKSRef x = (DKSRef)this.list.get(i);
            if (x.equals(ref)) {
                return true;
            }
            boolean insertHere = this.clockwise ? MathMisc.belongsTo(ref.getID(), this.myDKSRef.getID(), x.getID(), this.addrRange) : MathMisc.belongsTo(ref.getID(), x.getID(), this.myDKSRef.getID(), this.addrRange);
            if (!insertHere) continue;
            this.list.add(i, ref);
            if (this.list.size() > this.length) {
                this.list.removeLast();
            }
            return true;
        }
        if (this.list.size() < this.length) {
            this.list.addLast(ref);
        }
        return true;
    }

    @Override
    public boolean remove(Object ref) {
        boolean ans = false;
        while (this.list.remove(ref)) {
            ans = true;
        }
        return ans;
    }

    public boolean checkLength() {
        return this.length == this.list.size();
    }

    public LinkedList toList() {
        return (LinkedList)this.list.clone();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray(new DKSRef[0]);
    }

    @Override
    public Object[] toArray(Object[] arr) {
        return this.toArray();
    }

    @Override
    public boolean contains(Object ref) {
        return this.list.contains(ref);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    public String toString() {
        String ans = "";
        for (int i = 0; i < this.list.size(); ++i) {
            ans = ans + ((DKSRef)this.list.get(i)).getID() + " ";
        }
        return ans;
    }

    public String toStringReverse() {
        String ans = "";
        for (int i = this.list.size() - 1; i >= 0; --i) {
            ans = ans + ((DKSRef)this.list.get(i)).getID() + " ";
        }
        return ans;
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public Object get(int i) {
        return this.list.get(i);
    }

    public ListIterator listIterator(int i) {
        return this.list.listIterator(i);
    }

    public List subList(int from, int to) {
        return this.list.subList(from, to);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Object set(int index, Object el) {
        return new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        return false;
    }

    public boolean addAll(int i, Collection c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        return false;
    }

    public Object remove(int i) {
        return new UnsupportedOperationException();
    }

    public void add(int i, Object o) {
        throw new UnsupportedOperationException();
    }
}

