/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_node;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.kth.dks.dks_comm.DKSRef;

public class Nonces {
    private SortedSet removedNonces = new TreeSet(new NonceComparator());

    public boolean addNonce(DKSRef ref) {
        return this.removedNonces.add(new NoncePair(ref, new Long(new Date().getTime())));
    }

    public boolean containsNonce(DKSRef ref) {
        return this.removedNonces.contains(new NoncePair(ref, new Long(0L)));
    }

    public List getRecent(int n) {
        Iterator it;
        SortedSet<NoncePair> headSet = null;
        if (this.removedNonces.size() <= n) {
            headSet = this.removedNonces;
        } else {
            NoncePair np = (NoncePair)this.removedNonces.first();
            it = this.removedNonces.iterator();
            while (it.hasNext() && n >= 0) {
                np = (NoncePair)it.next();
                --n;
            }
            headSet = this.removedNonces.headSet(np);
        }
        ArrayList<DKSRef> ret = new ArrayList<DKSRef>();
        it = headSet.iterator();
        while (it.hasNext()) {
            ret.add(((NoncePair)it.next()).getRef());
        }
        return ret;
    }

    private static class NoncePair {
        private DKSRef ref;
        private Long time;

        public NoncePair(DKSRef ref, Long time) {
            this.ref = ref;
            this.time = time;
        }

        public DKSRef getRef() {
            return this.ref;
        }

        public Long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            return this.ref.equals(((NoncePair)o).getRef());
        }
    }

    private static class NonceComparator
    implements Comparator {
        private NonceComparator() {
        }

        public int compare(Object o1, Object o2) {
            Long t1 = ((NoncePair)o1).getTime();
            Long t2 = ((NoncePair)o2).getTime();
            return o1.equals(o2) ? 0 : (t1 > t2 ? -1 : 1);
        }
    }
}

