/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_node;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.kth.dks.dks_node.Interval;
import org.kth.dks.util.MathMiscConstant;

public class IntervalOptimizer {
    private final MathMiscConstant math;

    public IntervalOptimizer(MathMiscConstant math) {
        this.math = math;
    }

    private boolean iterate(Interval i, List workListRest) {
        ArrayList<Interval> tempList = new ArrayList<Interval>();
        boolean dirty = false;
        for (Interval curr : workListRest) {
            if (!(this.math.belongsTo(i.start, curr.start, curr.end) || this.math.belongsToII(i.end, curr.start, curr.end) || this.math.belongsTo(curr.start, i.start, i.end) || this.math.belongsToII(curr.end, i.start, i.end))) {
                tempList.add(curr);
                continue;
            }
            if (!this.math.belongsTo(i.start, curr.start, curr.end) && !this.math.belongsToII(i.end, curr.start, curr.end)) {
                dirty = true;
                tempList.add(curr);
                tempList.add(i);
                continue;
            }
            if (!this.math.belongsTo(i.start, curr.start, curr.end) && this.math.belongsToII(i.end, curr.start, curr.end)) {
                dirty = true;
                tempList.add(new Interval(i.start, curr.end));
                continue;
            }
            if (this.math.belongsTo(i.start, curr.start, curr.end) && !this.math.belongsToII(i.end, curr.start, curr.end)) {
                dirty = true;
                tempList.add(new Interval(curr.start, i.end));
                continue;
            }
            if (this.math.belongsTo(i.start, curr.start, curr.end) && this.math.belongsToII(i.end, curr.start, curr.end) && this.math.belongsTo(curr.start, i.start, i.end) && this.math.belongsToII(curr.end, i.start, i.end)) {
                dirty = true;
                tempList.add(new Interval(0L, this.math.modMinus(0L, 1L)));
                continue;
            }
            if (!this.math.belongsTo(i.start, curr.start, curr.end) || !this.math.belongsToII(i.end, curr.start, curr.end)) continue;
            dirty = true;
            tempList.add(curr);
        }
        workListRest.clear();
        workListRest.addAll(tempList);
        return dirty;
    }

    public List collapseIntervals(List intervalList) {
        LinkedList workList = new LinkedList(intervalList);
        LinkedList<Interval> finalList = new LinkedList<Interval>();
        while (!workList.isEmpty()) {
            if (workList.size() == 1) {
                LinkedList<Interval> tmp = new LinkedList<Interval>(workList);
                tmp.addAll(finalList);
                finalList = tmp;
                workList.clear();
                continue;
            }
            Interval head = (Interval)workList.remove(0);
            boolean dirty = this.iterate(head, workList);
            if (dirty) continue;
            finalList.add(head);
        }
        return finalList;
    }

    public List removeInterval(List list, Interval rem) {
        LinkedList<Interval> newList = new LinkedList<Interval>();
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            if (this.math.belongsToII(curr.start, rem.start, rem.end) && this.math.belongsToII(curr.end, rem.start, rem.end) && this.math.distanceClockWise(rem.start, curr.end) < this.math.distanceClockWise(rem.start, curr.start)) {
                newList.add(new Interval(rem.end, rem.start));
                continue;
            }
            if (this.math.belongsToII(curr.start, rem.start, rem.end) && this.math.belongsToII(curr.end, rem.start, rem.end)) continue;
            if (!this.math.belongsToII(rem.start, curr.start, curr.end) && !this.math.belongsToII(rem.end, curr.start, curr.end)) {
                newList.add(curr);
                continue;
            }
            if (this.math.belongsTo(rem.start, curr.start, curr.end)) {
                newList.add(new Interval(curr.start, rem.start));
            }
            if (!this.math.belongsToI(rem.end, curr.start, curr.end)) continue;
            newList.add(new Interval(rem.end, curr.end));
        }
        return newList;
    }

    public static void main(String[] arg) {
        IntervalOptimizer i = new IntervalOptimizer(new MathMiscConstant(0x40000000L, 2L));
        LinkedList<Interval> ints = new LinkedList<Interval>();
        ints.add(new Interval(536871413L, 0x20000001L));
        ints.add(new Interval(805306869L, 0x30000001L));
        ints.add(new Interval(939524597L, 939524097L));
        ints.add(new Interval(1006633461L, 1006632961L));
        ints.add(new Interval(1040187893L, 1040187393L));
        ints.add(new Interval(1056965109L, 1056964609L));
        ints.add(new Interval(1065353717L, 1065353217L));
        ints.add(new Interval(1069548021L, 1069547521L));
        ints.add(new Interval(1071645173L, 1071644673L));
        ints.add(new Interval(1072693749L, 1072693249L));
        ints.add(new Interval(1073218037L, 1073217537L));
        ints.add(new Interval(1073480181L, 1073479681L));
        ints.add(new Interval(1073611253L, 1073610753L));
        ints.add(new Interval(1073676789L, 1073676289L));
        ints.add(new Interval(1073709557L, 1073709057L));
        ints.add(new Interval(1073725941L, 1073725441L));
        ints.add(new Interval(1073734133L, 1073733633L));
        ints.add(new Interval(1073738229L, 1073737729L));
        ints.add(new Interval(1073740277L, 1073739777L));
        ints.add(new Interval(1073741301L, 1073740801L));
        ints.add(new Interval(0x3FFFFFF5L, 1073741313L));
        ints.add(new Interval(245L, 1073741569L));
        ints.add(new Interval(373L, 1073741697L));
        ints.add(new Interval(437L, 1073741761L));
        ints.add(new Interval(469L, 1073741793L));
        ints.add(new Interval(485L, 0x3FFFFFF1L));
        ints.add(new Interval(493L, 0x3FFFFFF9L));
        ints.add(new Interval(497L, 0x3FFFFFFDL));
        ints.add(new Interval(499L, 0x3FFFFFFFL));
        ints.add(new Interval(500L, 0L));
        List newints = i.collapseIntervals(ints);
        List newints2 = i.removeInterval(newints, new Interval(500L, 0L));
        for (Interval iv : newints2) {
            System.out.println("Interval " + iv);
        }
        System.out.println("");
    }
}

