/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_node;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.kth.dks.DKSAppInterface;
import org.kth.dks.DKSCallbackInterface;
import org.kth.dks.DKSMessagingInterface;
import org.kth.dks.DKSObject;
import org.kth.dks.DKSObjectTypes;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_comm.ThreadPool;
import org.kth.dks.dks_exceptions.DKSIdentifierAlreadyTaken;
import org.kth.dks.dks_exceptions.DKSNodeAlreadyRegistered;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_exceptions.DKSTooManyRestartJoins;
import org.kth.dks.dks_marshal.AckByeMsg;
import org.kth.dks.dks_marshal.AckHelloMsg;
import org.kth.dks.dks_marshal.AckJoinInitMsg;
import org.kth.dks.dks_marshal.AdaptLeaveMsg;
import org.kth.dks.dks_marshal.AdaptMsg;
import org.kth.dks.dks_marshal.BadPointerMsg;
import org.kth.dks.dks_marshal.BecomeNormalMsg;
import org.kth.dks.dks_marshal.BroadCastMsg;
import org.kth.dks.dks_marshal.ByeMsg;
import org.kth.dks.dks_marshal.CorrectionOnChangeInterface;
import org.kth.dks.dks_marshal.CorrectionOnJoinMsg;
import org.kth.dks.dks_marshal.CorrectionOnLeaveMsg;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_marshal.FailureMsg;
import org.kth.dks.dks_marshal.ForwardedMsgInterface;
import org.kth.dks.dks_marshal.HeartbeatMsg;
import org.kth.dks.dks_marshal.HelloMsg;
import org.kth.dks.dks_marshal.InsertNodeMsg;
import org.kth.dks.dks_marshal.JoinInitMsg;
import org.kth.dks.dks_marshal.LeaveAcceptMsg;
import org.kth.dks.dks_marshal.LeaveRejectMsg;
import org.kth.dks.dks_marshal.LeaveRequestMsg;
import org.kth.dks.dks_marshal.LookupMsg;
import org.kth.dks.dks_marshal.LookupRequestMsg;
import org.kth.dks.dks_marshal.LookupResponseMsg;
import org.kth.dks.dks_marshal.LookupResultMsg;
import org.kth.dks.dks_marshal.NodeLeftMsg;
import org.kth.dks.dks_marshal.RestartJoinMsg;
import org.kth.dks.dks_marshal.RestartOperationMsg;
import org.kth.dks.dks_node.DKSLookup;
import org.kth.dks.dks_node.DKSStatus;
import org.kth.dks.dks_node.DefaultAppHandler;
import org.kth.dks.dks_node.InsertManager;
import org.kth.dks.dks_node.Interval;
import org.kth.dks.dks_node.IntervalOptimizer;
import org.kth.dks.dks_node.LookupType;
import org.kth.dks.dks_node.Nonces;
import org.kth.dks.dks_node.OrderedDKSRefList;
import org.kth.dks.dks_node.RoutingTree;
import org.kth.dks.util.AsyncOperation;
import org.kth.dks.util.CommunicationInfo;
import org.kth.dks.util.MathMisc;
import org.kth.dks.util.MathMiscConstant;
import org.kth.dks.util.MessageInfo;
import org.kth.dks.util.NodeInfo;
import org.kth.dks.util.OperationType;
import org.kth.dks.util.Pair;
import org.kth.dks.util.RTEntry;

public class DKSNode
implements DKSCallbackInterface,
DKSMessagingInterface {
    private static Logger log = Logger.getLogger(DKSNode.class);
    public DKSMarshal marshal = null;
    public static long N = 0x100000000L;
    public static int K = 16;
    public static int L = 8;
    public static int F = 6;
    private static final int MAX_TIMEOUTS = 5;
    private static final int TIMEOUT_WINDOW = 10;
    private int numTimeouts = 0;
    private long lastTimeoutId = 0L;
    Vector jWSet = new Vector();
    Vector lWSet = new Vector();
    static final int RandomWaitAndRestart = 0;
    static final int LeaveAnywayBye = 1;
    int whatToDoWithLeaveReject = 1;
    DKSRef inserter = null;
    DKSRef predecessor = null;
    DKSRef successor = null;
    DKSStatus status = DKSStatus.NILL;
    boolean requestingToLeave = false;
    DKSRef pP = null;
    DKSRef pS = null;
    boolean IamInsertingNode = false;
    boolean IamRemovingNode = false;
    boolean stateReceived = false;
    InsertManager insertManager = new InsertManager();
    AsyncOperation joinFuture = null;
    AsyncOperation leaveFuture = null;
    DKSAppInterface appHandler = new DefaultAppHandler(this);
    protected ConnectionManager cm = null;
    RoutingTree routingTable = null;
    OrderedDKSRefList frontList = null;
    OrderedDKSRefList backList = null;
    LinkedList statisticsSentMessages = new LinkedList();
    DKSRef myDKSRef = null;
    MathMiscConstant math = new MathMiscConstant(N, K);
    private Nonces removedNonces = new Nonces();
    private static final int NONCESENDSIZE = 100;
    private ThreadPool threadPool = null;
    boolean IamPrinting = false;
    String data = null;
    private int MAX_RESTARTS = 25;
    private int joinExpBackoff = 1;
    private int joinBackoffCount = 0;
    private Heartbeat heartbeat = new Heartbeat();
    private final Timer heartbeatTimer = new Timer(DKSNode.class.getName() + ".HeartbeatTimer");
    private Map restartOpBackoffMap = new HashMap();

    public void setConnectionManager(ConnectionManager cm, DKSRef _dksRef) throws DKSNodeAlreadyRegistered {
        this.myDKSRef = _dksRef;
        this.cm = cm;
        this.marshal = cm.getDKSMarshal();
        this.frontList = new OrderedDKSRefList(this.myDKSRef, F, N, true);
        this.backList = new OrderedDKSRefList(this.myDKSRef, F, N, false);
        this.jWSet = new Vector();
        this.lWSet = new Vector();
        this.routingTable = new RoutingTree(N, K, L, this.myDKSRef);
        cm.registerDKSNode(this.myDKSRef, this);
        this.installHandlers();
        this.threadPool = ThreadPool.getInstance();
        long intDel = (long)Math.max(1000.0, cm.getNodeRTT(this.predecessor));
        intDel = Math.min(5000L, intDel);
        this.heartbeatTimer.schedule((TimerTask)this.heartbeat, 0L, intDel);
    }

    public void setMarshall(DKSMarshal dksMarshall) {
        this.marshal = dksMarshall;
    }

    private synchronized void updateMsgStatistics(DKSRef r, String s) {
        this.statisticsSentMessages.addLast(new MessageInfo(r, this.myDKSRef, s));
    }

    @Override
    public boolean send(DKSRef dest, DKSMessage msg) {
        log.info((Object)("DKSNode:" + msg.getName() + ":" + this.myDKSRef.getID() + "==>" + dest.getID()));
        this.updateMsgStatistics(dest, msg.getName());
        return this.marshal.send(this.myDKSRef, dest, msg);
    }

    private void updateRingInfo(DKSRef[] d) {
        for (int i = 0; i < d.length; ++i) {
            this.updateRingInfo(d[i]);
        }
    }

    private void updateRingInfo(DKSRef x) {
        if (this.removedNonces.containsNonce(x)) {
            log.warn((Object)("Node not added to RT because it has an old nonce [dksref=" + x + "]"));
            return;
        }
        if (x.getID() != this.myDKSRef.getID()) {
            log.debug((Object)("Incoporating node " + x.getID()));
            this.routingTable.foundNewNode(x);
            this.frontList.add(x);
            this.backList.add(x);
            log.debug((Object)("LeafSet " + this.backList.toStringReverse() + "--> " + this.myDKSRef.getID() + " --> " + this.frontList));
        }
    }

    public void nodeLeftH(DKSRef coord, NodeLeftMsg m) {
        boolean removed = this.nodeFailed(m.getOldNode());
        this.updateRingInfo(coord);
        for (DKSRef curr : m.getLiveRefs()) {
            this.updateRingInfo(curr);
        }
        if (coord.equals(this.successor) && removed) {
            this.send(coord, new NodeLeftMsg(m.getOldNode(), this.backList, this.removedNonces.getRecent(100)));
        }
        for (DKSRef curr : m.getNonces()) {
            this.nodeLeft(curr);
        }
    }

    private boolean nodeFailed(DKSRef failedNode) {
        this.nodeLeft(failedNode);
        boolean removed = false;
        if (failedNode.equals(this.successor)) {
            removed = true;
            if (this.frontList.size() < 1) {
                log.error((Object)"*MAJOR FAILURE* frontlist exhausted, cannot find replacement for failed successor (DKS F parameter too low?)");
                this.successor = this.myDKSRef;
                this.predecessor = this.myDKSRef;
            } else {
                this.successor = (DKSRef)this.frontList.get(0);
            }
        }
        if (failedNode.equals(this.predecessor)) {
            removed = true;
            if (this.backList.size() < 1) {
                log.error((Object)"*MAJOR FAILURE* backlist exhausted, cannot find replacement for failed predecessor (DKS F parameter too low?)");
            } else {
                this.predecessor = (DKSRef)this.backList.get(0);
            }
        }
        return removed;
    }

    private void nodeLeft(DKSRef leftNode) {
        this.removedNonces.addNonce(leftNode);
        this.routingTable.nodeLost(leftNode);
        this.frontList.remove(leftNode);
        this.backList.remove(leftNode);
    }

    public Set getNeighboursSet() {
        HashSet set = new HashSet();
        set.addAll(this.frontList.toList());
        set.addAll(this.backList.toList());
        set.addAll(this.routingTable.toList());
        return set;
    }

    private DKSRef[] getBackAndFrontList() {
        LinkedList ans = this.frontList.toList();
        LinkedList tmp = this.backList.toList();
        while (!tmp.isEmpty()) {
            DKSRef ele = (DKSRef)tmp.removeFirst();
            if (ans.contains(ele)) continue;
            ans.add(ele);
        }
        return ans.toArray(new DKSRef[0]);
    }

    private DKSRef[] getKnownDKSRefs() {
        DKSRef ele;
        LinkedList ans = this.frontList.toList();
        LinkedList tmp = this.backList.toList();
        while (!tmp.isEmpty()) {
            ele = (DKSRef)tmp.removeFirst();
            if (ans.contains(ele)) continue;
            ans.add(ele);
        }
        tmp = this.routingTable.toList();
        while (!tmp.isEmpty()) {
            ele = (DKSRef)tmp.removeFirst();
            if (ans.contains(ele)) continue;
            ans.add(ele);
        }
        return ans.toArray(new DKSRef[0]);
    }

    public AsyncOperation newNode(DKSRef nj, DKSRef n) throws DKSRefNoResponse {
        if (nj.getID() < 0L || nj.getID() >= N) {
            log.error((Object)("DKS ID is not valid (" + nj.getID() + ")"));
            return null;
        }
        this.pP = null;
        this.pS = null;
        this.whatToDoWithLeaveReject = 0;
        this.IamInsertingNode = false;
        this.IamRemovingNode = false;
        this.stateReceived = false;
        this.joinFuture = AsyncOperation.start(OperationType.JOINTYPE);
        if (n == null) {
            this.joinFuture.complete("FirstNode joined");
            this.predecessor = nj;
            this.successor = nj;
            this.status = DKSStatus.INSIDE;
            this.inserter = nj;
            log.debug((Object)"created a new dks");
        } else {
            this.inserter = null;
            this.predecessor = null;
            this.successor = null;
            this.status = DKSStatus.GETTINGIN;
            this.pS = null;
            log.debug((Object)("about to join node " + nj.getID() + " with type ADDRESS and msgId=" + this.joinFuture.getKey()));
            log.debug((Object)("Joining node " + nj.getID() + " with type ADDRESS and msgId=" + this.joinFuture.getKey()));
            LookupRequestMsg lm = new LookupRequestMsg(nj.getID(), LookupType.ADDRESS, this.joinFuture.getKey(), true);
            if (!this.send(n, lm)) {
                this.heartbeatTimer.cancel();
                throw new DKSRefNoResponse(n.getDKSNetAddress());
            }
        }
        return this.joinFuture;
    }

    public void insertNodeH(DKSRef nj, InsertNodeMsg msg) {
        log.debug((Object)("DKSNode:INSERTNODE:" + nj.getID() + "-->" + this.myDKSRef.getID()));
        if (this.status == DKSStatus.INSIDE) {
            if (MathMisc.belongsTonn(nj.getID(), this.predecessor.getID(), this.myDKSRef.getID(), N) && this.pP == null && !this.requestingToLeave) {
                this.pP = nj;
                this.IamInsertingNode = true;
                log.debug((Object)("Sending front and back-list to " + nj));
                log.debug((Object)(this.backList.toString() + this.frontList.toString()));
                this.send(nj, new JoinInitMsg(this.predecessor, this.getBackAndFrontList()));
            } else {
                log.debug((Object)("RestartJoin sent; reason: nj=" + nj.getID() + " p=" + this.predecessor.getID() + " n=" + this.myDKSRef.getID() + " pP=" + Boolean.toString(this.pP == null) + " reqLeave=" + this.requestingToLeave));
                this.send(nj, new RestartJoinMsg());
            }
        } else if (this.status == DKSStatus.GETTINGIN) {
            log.debug((Object)"RestartJoin sent; reason: gettingIn");
            this.send(nj, new RestartJoinMsg());
        } else if (this.status == DKSStatus.GETTINGOUT) {
            log.debug((Object)"RestartJoin sent; reason: gettingIn");
            this.send(nj, new RestartJoinMsg());
        }
    }

    public void restartOperationH(DKSRef from, RestartOperationMsg msg) {
        long secToWait;
        DKSMessage operation = msg.getOperation();
        if (!this.restartOpBackoffMap.containsKey(from)) {
            this.restartOpBackoffMap.put(from, new Long(100L));
        }
        if (Math.log(secToWait = ((Long)this.restartOpBackoffMap.get(from)).longValue()) / Math.log(2.0) > (double)this.MAX_RESTARTS) {
            secToWait = 1L;
            log.error((Object)("Restarted operation " + operation.getName() + " from node " + from + " MAX=" + this.MAX_RESTARTS + " times (shock starting)"));
        }
        secToWait += (long)new Random().nextInt(100);
        try {
            Thread.sleep(secToWait);
        }
        catch (Exception ex) {
            log.error((Object)("Was interrupted while sleeping in restartOperationH\n" + ex));
        }
        this.restartOpBackoffMap.put(from, new Long(secToWait *= 2L));
        this.send(from, operation);
    }

    public void joinInitH(DKSRef np, JoinInitMsg msg) {
        DKSRef rP = msg.getP();
        DKSRef[] dArray = msg.getDKSRefs();
        log.debug((Object)("DKSNode:JOININIT:" + np.getID() + "-->" + this.myDKSRef.getID()));
        if (this.status == DKSStatus.INSIDE) {
            log.debug((Object)"DKSNode:joinInitH:error:status is inside");
        } else if (this.status == DKSStatus.GETTINGIN) {
            if (this.inserter == null && np.getID() == this.pS.getID()) {
                this.inserter = np;
                this.predecessor = rP;
                this.stateReceived = true;
                this.updateRingInfo(np);
                this.updateRingInfo(rP);
                this.updateRingInfo(dArray);
                log.debug((Object)("JoinInit, not yet added " + np.getID()));
                log.debug((Object)(this.backList + " --> " + this.myDKSRef.getID() + " --> " + this.frontList));
                final DKSRef _pred = this.predecessor;
                final DKSRef _succ = np;
                Runnable callbackObj = new Runnable(){

                    @Override
                    public void run() {
                        DKSNode.this.appHandler.joinCallback(_pred, _succ);
                    }
                };
                this.threadPool.addJob(callbackObj);
            }
        } else if (this.status == DKSStatus.GETTINGOUT) {
            log.debug((Object)"DKSNode:joinInitH:error:status is gettingout");
        }
    }

    @Override
    public void joinCallbackReturn() {
        log.debug((Object)"JoinCallbackReturn, from appllication level");
        if (this.status == DKSStatus.GETTINGOUT || this.status == DKSStatus.INSIDE) {
            log.error((Object)"Received a joinCallbackReturn while status!=GettingIn");
        } else {
            log.debug((Object)("Sending on backlist " + this.backList));
            DKSRef[] bNfL = this.getBackAndFrontList();
            for (int i = 0; i < bNfL.length; ++i) {
                if (bNfL[i].getID() == this.myDKSRef.getID()) continue;
                this.jWSet.add(bNfL[i]);
                log.debug((Object)("Sending hello to " + bNfL[i].getID() + " JoinWait setsize: " + this.jWSet.size()));
                this.send(bNfL[i], new HelloMsg("BACK_AND_FRONT_LIST"));
            }
        }
    }

    public void helloH(DKSRef nj, HelloMsg msg) {
        String typelist = msg.getType();
        log.debug((Object)("DKSNode:HELLO:" + nj.getID() + "-->" + this.myDKSRef.getID() + " type(" + typelist + ")"));
        this.updateRingInfo(nj);
        this.send(nj, new AckHelloMsg(this.getBackAndFrontList()));
    }

    public void ackHelloH(DKSRef nj, AckHelloMsg msg) {
        DKSRef[] dArray = msg.getDKSRefs();
        log.debug((Object)("DKSNode:ACKHELLO:" + nj.getID() + "-->" + this.myDKSRef.getID() + " JoinWait setsize: " + this.jWSet.size()));
        if (this.status != DKSStatus.NILL) {
            if (this.status == DKSStatus.GETTINGIN) {
                this.updateRingInfo(nj);
                this.updateRingInfo(dArray);
                this.jWSet.remove(nj);
                if (this.jWSet.size() == 0) {
                    AckJoinInitMsg ajim = new AckJoinInitMsg();
                    this.send(this.pS, ajim);
                }
            } else if (this.status == DKSStatus.INSIDE) {
                log.debug((Object)"DKSNode:ackHello:error:status is inside");
            } else if (this.status == DKSStatus.GETTINGOUT) {
                log.debug((Object)"DKSNode:askHello:error:status is gettingout");
            }
        }
    }

    public void ackJoinInitH(DKSRef nj, AckJoinInitMsg msg) {
        log.debug((Object)("DKSNode:ACKJOININIT:" + nj.getID() + "-->" + this.myDKSRef.getID()));
        if (this.status == DKSStatus.INSIDE || this.status == DKSStatus.GETTINGOUT) {
            if (this.IamInsertingNode && this.pP.getID() == nj.getID()) {
                DKSRef oldP = this.predecessor;
                this.predecessor = this.pP;
                this.updateRingInfo(this.pP);
                this.pP = null;
                this.IamInsertingNode = false;
                this.send(nj, new BecomeNormalMsg(oldP));
            }
        } else {
            log.debug((Object)"DKSNode:ackJoinInitH:error:status is wrong");
        }
    }

    private void initializeRT() {
        for (int l = this.routingTable.a_levels; l >= 1; --l) {
            for (int i = 1; i < this.routingTable.a_k_factor; ++i) {
                AsyncOperation find = AsyncOperation.start(OperationType.DATATYPE);
                long start = this.routingTable.getBegin(l, i);
                LookupRequestMsg lm = new LookupRequestMsg(start, LookupType.JOINADDRESS, find.getKey(), true);
                this.send(this.myDKSRef, lm);
            }
        }
    }

    Pair getNodeIntervals(long id) {
        long myId = this.myDKSRef.getID();
        long nodeId = this.math.distanceClockWise(myId, id);
        int logLevel = (int)(Math.log(nodeId) / Math.log(K));
        int level = L - logLevel;
        int interval = (int)(nodeId == 0L ? 0L : nodeId / (long)Math.pow(K, logLevel));
        return new Pair(new Integer(level), new Integer(interval));
    }

    public void fixNextPointer(DKSRef targetRef) {
        Pair p = this.getNodeIntervals(targetRef.getID());
        int level = (Integer)p.first();
        int interval = (Integer)p.second();
        if (interval != 0) {
            if (++interval == K) {
                interval = 1;
                if (--level == 0) {
                    return;
                }
            }
            AsyncOperation find = AsyncOperation.start(OperationType.DATATYPE);
            long start = this.math.nThroughKPowerL(level) * (long)interval;
            LookupRequestMsg lm = new LookupRequestMsg(start, LookupType.JOINADDRESS, find.getKey(), true);
            this.send(this.myDKSRef, lm);
        }
    }

    public void becomeNormalH(DKSRef nj, BecomeNormalMsg msg) {
        this.joinExpBackoff = 1;
        DKSRef newp = msg.getP();
        log.debug((Object)("DKSNode:BECOMENORMAL:" + nj.getID() + "-->" + this.myDKSRef.getID()));
        if (this.status == DKSStatus.INSIDE) {
            log.error((Object)"DKSNode:becomeNormaltH:error:status is inside");
        } else if (this.status == DKSStatus.GETTINGIN) {
            if (this.inserter.getID() == nj.getID()) {
                this.status = DKSStatus.INSIDE;
                this.successor = this.pS;
                this.predecessor = newp;
                this.updateRingInfo(this.pS);
                this.pS = null;
                this.send(this.predecessor, new AdaptMsg());
                log.debug((Object)"DKSNode:becomeNormaltH:JOIN FINISHED!!!");
                this.initializeRT();
                this.correctionOnChangeJoin();
                this.joinFuture.complete("Join completed");
            }
        } else if (this.status == DKSStatus.GETTINGOUT) {
            log.error((Object)"DKSNode:becomeNormaltH:error:status is gettingout");
        }
    }

    public List getDependentIntervals(DKSRef pred, DKSRef succ) {
        LinkedList<Interval> depIntervals = new LinkedList<Interval>();
        for (int l = 1; l <= L; ++l) {
            for (int i = 1; i < K; ++i) {
                long start = this.math.modMinus(pred.getID(), this.math.nThroughKPowerL(l));
                long end = this.math.modMinus(succ.getID(), this.math.nThroughKPowerL(l));
                start = this.math.modPlus(start, 1L);
                end = this.math.modPlus(end, 1L);
                depIntervals.add(new Interval(start, end));
            }
        }
        IntervalOptimizer opt = new IntervalOptimizer(this.math);
        List collapsedIntervals = opt.collapseIntervals(depIntervals);
        long myId = succ.getID();
        long predId = pred.getID();
        List finalIntervals = opt.removeInterval(collapsedIntervals, new Interval(predId, myId));
        return finalIntervals;
    }

    public void correctionOnChangeJoin() {
        List intervals = this.getDependentIntervals(this.predecessor, this.myDKSRef);
        ListIterator iter = intervals.listIterator();
        while (iter.hasNext()) {
            Interval curr = (Interval)iter.next();
            byte[] msg = new CorrectionOnJoinMsg(this.myDKSRef, curr).flatten();
            this.routeAsync(curr.start, new DKSObject(msg), true);
        }
    }

    public void correctionOnChangeLeave(DKSRef leavingPred, DKSRef leavingNode, DKSRef leavingSucc) {
        List intervals = this.getDependentIntervals(leavingPred, leavingNode);
        ListIterator iter = intervals.listIterator();
        while (iter.hasNext()) {
            Interval currInterval = (Interval)iter.next();
            byte[] msg = new CorrectionOnLeaveMsg(leavingNode, leavingSucc, currInterval).flatten();
            this.routeAsyncFrom(currInterval.start, new DKSObject(msg), true, this.successor);
        }
    }

    public void cocJoinNotificationH(CorrectionOnJoinMsg msg) {
        log.debug((Object)("CorrectionOnChange at " + this.myDKSRef + ", Node " + msg.getNewNode() + " joined"));
        this.updateRingInfo(msg.getNewNode());
        Interval i = msg.getInterval();
        if (this.pP != null) {
            CorrectionOnJoinMsg cocJoin = new CorrectionOnJoinMsg(msg.getNewNode(), new Interval(this.pP.getID(), this.pP.getID()));
            this.send(this.pP, cocJoin);
        }
    }

    public void cocJoinInterleavedH(DKSRef succ, CorrectionOnJoinMsg msg) {
        this.updateRingInfo(msg.getNewNode());
    }

    public void cocLeaveNotificationH(CorrectionOnLeaveMsg msg) {
        log.debug((Object)("CorrectionOnChange at " + this.myDKSRef + ", Node " + msg.getOldNode() + " with successor " + msg.getNewNode() + " left"));
        this.nodeLeft(msg.getOldNode());
        this.updateRingInfo(msg.getNewNode());
    }

    public void correctionOnChangeH(CorrectionOnChangeInterface cocMsg) {
        Interval i = cocMsg.getInterval();
        if (this.math.belongsToI(this.myDKSRef.getID(), i.start, i.end)) {
            if (cocMsg instanceof CorrectionOnJoinMsg) {
                CorrectionOnJoinMsg joinMsg = (CorrectionOnJoinMsg)cocMsg;
                this.updateRingInfo(joinMsg.getNewNode());
            } else if (cocMsg instanceof CorrectionOnLeaveMsg) {
                CorrectionOnLeaveMsg leaveMsg = (CorrectionOnLeaveMsg)cocMsg;
                this.nodeLeft(leaveMsg.getOldNode());
                this.updateRingInfo(leaveMsg.getNewNode());
            }
            DKSObject rawMsg = new DKSObject(((DKSMessage)((Object)cocMsg)).flatten());
            this.send(this.myDKSRef, new BroadCastMsg(i.start, i.end, rawMsg, true));
        }
    }

    public void restartJoinH(DKSRef nj, RestartJoinMsg msg) throws DKSTooManyRestartJoins {
        if (this.joinBackoffCount >= this.MAX_RESTARTS) {
            this.joinExpBackoff = 1;
            this.joinBackoffCount = 0;
            log.debug((Object)"RestartJoinH cancel restarts");
            this.joinFuture.cancel(new DKSTooManyRestartJoins(this.MAX_RESTARTS));
            return;
        }
        Random rnd = new Random();
        log.debug((Object)("RestartJoinH going to sleep " + this.joinExpBackoff));
        try {
            Thread.sleep(rnd.nextInt(1000) + this.joinExpBackoff);
        }
        catch (Exception ex) {
            log.warn((Object)("Got exception while sleeping inside restartJoin handler\n" + ex));
        }
        this.joinExpBackoff *= 2;
        ++this.joinBackoffCount;
        log.debug((Object)("DKSNode:restartJoinH:" + nj.getID() + "-->" + this.myDKSRef.getID() + " msgId=" + this.joinFuture.getKey()));
        LookupRequestMsg lm = new LookupRequestMsg(this.myDKSRef.getID(), LookupType.ADDRESS, this.joinFuture.getKey(), true);
        this.send(nj, lm);
    }

    public void adaptH(DKSRef nj, AdaptMsg msg) {
        log.debug((Object)("DKSNode:adaptH:" + nj.getID() + "-->" + this.myDKSRef.getID()));
        this.successor = nj;
    }

    public void adaptLeaveH(DKSRef nj, AdaptLeaveMsg msg) {
        log.debug((Object)("DKSNode:adaptLeaveH:" + nj.getID() + "-->" + this.myDKSRef.getID()));
        this.successor = nj;
    }

    public AsyncOperation prepareForLeave() {
        if (this.status == DKSStatus.INSIDE) {
            this.leaveFuture = AsyncOperation.start(OperationType.LEAVETYPE);
            if (this.pP == null) {
                this.requestingToLeave = true;
                if (this.predecessor.equals(this.myDKSRef)) {
                    this.heartbeatTimer.cancel();
                    this.leaveFuture.complete("Leave completed (last node)");
                    return this.leaveFuture;
                }
                this.send(this.successor, new LeaveRequestMsg(this.predecessor));
            }
            return this.leaveFuture;
        }
        if (this.status == DKSStatus.GETTINGIN) {
            this.leaveFuture.complete("Leave completed automatically");
            return this.leaveFuture;
        }
        if (this.status == DKSStatus.GETTINGOUT) {
            log.error((Object)"DKSLeave:prepareForLeave:error:status is gettingout");
            this.leaveFuture.complete("Leave completed");
            return this.leaveFuture;
        }
        this.leaveFuture.complete("Leave completed");
        return this.leaveFuture;
    }

    public void leaveRequestH(DKSRef source, LeaveRequestMsg msg) {
        log.debug((Object)("DKSLeave:leaveRequestH from " + source.getID()));
        DKSRef pnl = msg.getP();
        if (this.status == DKSStatus.INSIDE) {
            if (source.getID() == this.predecessor.getID()) {
                if (this.requestingToLeave) {
                    if (source.getID() < this.myDKSRef.getID()) {
                        this.send(source, new LeaveRejectMsg());
                    } else {
                        this.pP = pnl;
                        this.requestingToLeave = false;
                        this.IamRemovingNode = true;
                        this.send(source, new LeaveAcceptMsg());
                    }
                } else if (this.pP == null) {
                    this.pP = pnl;
                    this.IamRemovingNode = true;
                    this.send(source, new LeaveAcceptMsg());
                } else {
                    this.send(source, new LeaveRejectMsg());
                }
            }
        } else if (this.status == DKSStatus.GETTINGIN) {
            log.error((Object)"DKSLeave:leaveRequestH:error:status is gettingin");
        } else if (this.status == DKSStatus.GETTINGOUT && source.getID() == this.predecessor.getID()) {
            this.send(source, new LeaveRejectMsg());
        }
    }

    public void leaveAcceptH(DKSRef source, LeaveAcceptMsg msg) {
        log.debug((Object)("DKSNode:leaveAccceptH:" + source.getID() + "-->" + this.myDKSRef.getID()));
        if (this.status == DKSStatus.INSIDE) {
            if (this.requestingToLeave && source.getID() == this.successor.getID()) {
                final DKSRef _pred = this.predecessor;
                final DKSRef _succ = source;
                Runnable callbackObj = new Runnable(){

                    @Override
                    public void run() {
                        DKSNode.this.appHandler.leaveCallback(_pred, _succ);
                    }
                };
                this.threadPool.addJob(callbackObj);
            }
        } else if (this.status == DKSStatus.GETTINGIN) {
            log.debug((Object)"DKSLeave:leaveAcceptH:error:status is gettingin");
        } else if (this.status == DKSStatus.GETTINGOUT) {
            log.error((Object)"DKSLeave:leaveAcceptH:error:status is gettingout");
        }
    }

    @Override
    public void leaveCallbackReturn() {
        if (this.status == DKSStatus.GETTINGOUT) {
            log.error((Object)"Received a leaveCallback while status=gettingOut!");
        } else {
            this.status = DKSStatus.GETTINGOUT;
            this.goodBye();
        }
    }

    public void leaveRejectH(DKSRef source, LeaveRejectMsg msg) {
        if (this.status == DKSStatus.INSIDE) {
            if (this.requestingToLeave && source.getID() == this.successor.getID()) {
                switch (this.whatToDoWithLeaveReject) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.lWSet = new Vector();
                        DKSRef[] da = this.getBackAndFrontList();
                        for (int i = 0; i < da.length; ++i) {
                            if (this.lWSet.contains(da[i])) continue;
                            this.lWSet.addElement(da[i]);
                        }
                        this.goodBye();
                    }
                }
            }
        } else if (this.status == DKSStatus.GETTINGIN) {
            log.debug((Object)"DKSLeave:leaveRejectH:error:status is gettingin");
        } else if (this.status == DKSStatus.GETTINGOUT) {
            log.error((Object)"DKSLeave:leaveRejectH:error:status is gettingout");
        }
    }

    public void byeH(DKSRef source, ByeMsg msg) {
        DKSRef[] dArray = msg.getDKSRefs();
        String typeList = msg.getTypeList();
        log.debug((Object)("byeH:BYE:" + source.getID() + "-->" + this.myDKSRef.getID()));
        if (this.status == DKSStatus.INSIDE || this.status == DKSStatus.GETTINGIN) {
            if (typeList.equals("FL") && source.getID() == this.predecessor.getID()) {
                this.predecessor = this.pP;
                this.pP = null;
                this.IamRemovingNode = false;
                if (this.predecessor.equals(this.myDKSRef)) {
                    this.successor = this.myDKSRef;
                }
            }
            log.debug((Object)("Before Bye: backlist:" + this.backList.toStringReverse() + " myId:" + this.myDKSRef.getID() + " frontlist:" + this.frontList));
            log.debug((Object)("Removing node " + source.getID()));
            this.nodeLeft(source);
            log.debug((Object)("After bye: backlist" + this.backList.toStringReverse() + " myId:" + this.myDKSRef.getID() + " frontlist:" + this.frontList));
            this.updateRingInfo(dArray);
            log.debug((Object)("After bye sorted: backlist:" + this.backList.toStringReverse() + " myId:" + this.myDKSRef.getID() + " frontlist:" + this.frontList));
            if (source.equals(this.successor)) {
                log.debug((Object)("Changing successor from " + this.successor + " to " + this.frontList.getFirst()));
                this.successor = (DKSRef)this.frontList.getFirst();
            }
            this.send(source, new AckByeMsg());
        } else if (!this.stateReceived) {
            log.error((Object)"not in state received -- byeH");
        } else {
            this.nodeLeft(source);
            this.updateRingInfo(dArray);
            this.send(source, new AckByeMsg());
        }
    }

    public void ackByeH(DKSRef source, AckByeMsg msg) {
        if (this.status == DKSStatus.INSIDE) {
            log.debug((Object)"DKSLeave:ackByeH:error:status is inside");
        } else if (this.status == DKSStatus.GETTINGIN) {
            log.debug((Object)"DKSLeave:ackByeH:error:status is gettingin");
        } else if (this.status == DKSStatus.GETTINGOUT) {
            this.lWSet.remove(source);
            if (this.lWSet.size() == 0) {
                log.debug((Object)"DKSLeave:ackByeH:Leave is FINISHED!");
                this.correctionOnChangeLeave(this.predecessor, this.myDKSRef, this.successor);
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.predecessor = this.successor = this.myDKSRef;
                this.heartbeatTimer.cancel();
                this.leaveFuture.complete("Leave completed");
            }
        }
    }

    public void goodBye() {
        this.lWSet = new Vector();
        DKSRef[] fl = (DKSRef[])this.frontList.toArray();
        for (int i = 0; i < fl.length; ++i) {
            this.send(fl[i], new ByeMsg("FL", this.getBackAndFrontList()));
            this.lWSet.add(fl[i]);
        }
        DKSRef[] bl = (DKSRef[])this.backList.toArray();
        for (int i = 0; i < bl.length; ++i) {
            if (this.frontList.contains(bl[i])) continue;
            this.send(bl[i], new ByeMsg("BL", this.getBackAndFrontList()));
            this.lWSet.add(bl[i]);
        }
    }

    public void lookupRequestH(DKSRef sender, LookupRequestMsg lm) {
        final long t = lm.getTarget();
        LookupType type = lm.getType();
        String msgId = lm.getMsgId();
        final boolean internal = lm.getInternal();
        final DKSObject payload = lm.getPayload();
        log.debug((Object)("LOOKUPREQUEST:" + sender.getID() + "-->" + this.myDKSRef.getID() + " type(" + type + ") msgID(" + msgId + ") " + this.status));
        if (this.status == DKSStatus.GETTINGIN) {
            log.debug((Object)"DKSNode:lookupReqH:error:Status is gettingin (restarting)!");
            this.send(sender, new RestartOperationMsg(lm));
        } else if (MathMisc.belongsTo(t, this.predecessor.getID(), this.myDKSRef.getID(), N)) {
            log.debug((Object)("lookup_req:type:" + type + " from " + sender.getID()));
            if (type == LookupType.ADDRESS || type == LookupType.JOINADDRESS) {
                DKSRef n = this.myDKSRef;
                LookupResponseMsg lrm = new LookupResponseMsg(n, type, msgId);
                this.send(sender, lrm);
            } else if (type == LookupType.ASYNCDATA) {
                log.debug((Object)("lookupRequestH:type:" + type + " from " + sender.getID()));
                Runnable callbackObj = new Runnable(){

                    @Override
                    public void run() {
                        DKSNode.this.routeCallbackAsync(t, payload, internal);
                    }
                };
                this.threadPool.addJob(callbackObj);
            } else if (type == LookupType.SYNCDATA) {
                log.debug((Object)("lookupRequestH:type:" + type + " from " + sender.getID()));
                DKSRef n = this.myDKSRef;
                DKSObject responsePayload = this.appHandler.routeCallback(t, payload);
                LookupResponseMsg lrm = new LookupResponseMsg(n, type, responsePayload, msgId);
                this.send(sender, lrm);
            } else {
                log.debug((Object)("LookupType unknown (DKSNode:lookupRequestH:type:" + type + ")   from " + sender.getID()));
            }
        } else {
            log.debug((Object)("lookupRequestH Forwarding lookup for key: " + t + " sent from " + sender.getID()));
            LookupMsg lookupmsg = type == LookupType.ASYNCDATA || type == LookupType.SYNCDATA ? new LookupMsg(t, type, sender, this.myDKSRef, payload, msgId, lm.getInternal()) : new LookupMsg(t, type, sender, this.myDKSRef, msgId, lm.getInternal());
            this.forward(lookupmsg);
        }
    }

    public void lookupH(DKSRef np, LookupMsg msg) {
        final long target = msg.getTarget();
        final boolean internal = msg.getInternal();
        LookupType type = msg.getType();
        Vector stack = msg.getStack();
        String msgId = msg.getMsgId();
        final DKSObject payload = msg.getPayload();
        log.debug((Object)("DKSNode:LOOKUP:" + np.getID() + "-->" + this.myDKSRef.getID() + " msgID(" + msgId + "), target=" + target + ", pred=" + this.predecessor.getID() + ", TYPE=" + type + ", STACK=" + stack.size()));
        if (this.correctionOnUse(np, msg)) {
            return;
        }
        log.debug((Object)"AFTER COU");
        if (MathMisc.belongsTo(target, this.predecessor.getID(), this.myDKSRef.getID(), N)) {
            if (type == LookupType.ADDRESS || type == LookupType.JOINADDRESS || type == LookupType.SYNCDATA) {
                DKSRef n = this.myDKSRef;
                DKSRef dest = (DKSRef)stack.elementAt(0);
                stack.removeElementAt(0);
                LookupResultMsg lrmsg = null;
                if (type == LookupType.ADDRESS || type == LookupType.JOINADDRESS) {
                    lrmsg = new LookupResultMsg(n, type, stack, msgId);
                } else if (type == LookupType.SYNCDATA) {
                    DKSObject responsePayload = this.appHandler.routeCallback(target, payload);
                    lrmsg = new LookupResultMsg(n, type, stack, responsePayload, msgId);
                }
                this.send(dest, lrmsg);
            } else if (type == LookupType.ASYNCDATA) {
                Runnable callbackObj = new Runnable(){

                    @Override
                    public void run() {
                        DKSNode.this.routeCallbackAsync(target, payload, internal);
                    }
                };
                this.threadPool.addJob(callbackObj);
            } else {
                log.error((Object)("Unknown LookupType (type=" + type + ")"));
            }
        } else {
            log.debug((Object)("FORWARDING MSG because: target=" + target + " "));
            msg.getStack().add(0, this.myDKSRef);
            this.forward(msg);
        }
    }

    public void lookupResponseH(DKSRef np, LookupResponseMsg lrm) {
        DKSRef targetRef = lrm.getTargetRef();
        LookupType type = lrm.getType();
        String msgId = lrm.getMsgId();
        DKSObject payload = lrm.getPayload();
        log.debug((Object)("DKSNode:LOOKUPRESPONSE:" + np.getID() + "-->" + this.myDKSRef.getID() + " msgID(" + msgId + ")"));
        if (this.status == DKSStatus.INSIDE || this.status == DKSStatus.GETTINGOUT) {
            if (type == LookupType.SYNCDATA) {
                AsyncOperation thisOp = AsyncOperation.get(msgId);
                if (thisOp != null) {
                    thisOp.complete(payload);
                }
            } else if (type == LookupType.ADDRESS) {
                AsyncOperation thisOp = AsyncOperation.get(msgId);
                if (thisOp != null) {
                    thisOp.complete(targetRef);
                }
            } else if (type == LookupType.JOINADDRESS) {
                this.updateRingInfo(targetRef);
            }
        } else if (type == LookupType.ADDRESS) {
            AsyncOperation thisOp = AsyncOperation.get(msgId);
            if (thisOp != null && (OperationType)thisOp.getState() == OperationType.JOINTYPE && targetRef.getID() == this.myDKSRef.getID()) {
                this.joinFuture.cancel(new DKSIdentifierAlreadyTaken());
            } else if ((OperationType)thisOp.getState() == OperationType.JOINTYPE) {
                this.pS = targetRef;
                this.send(targetRef, new InsertNodeMsg());
            } else if (type == LookupType.JOINADDRESS) {
                this.updateRingInfo(targetRef);
            } else {
                log.error((Object)"DKSNode::lookupResponseH: Lookup (TYPE=ADDR) received while not in the system");
            }
        }
    }

    public void lookupResultH(DKSRef np, LookupResultMsg msg) {
        DKSRef t = msg.getT();
        LookupType type = msg.getType();
        Vector stack = msg.getStack();
        String msgId = msg.getMsgId();
        DKSObject payload = msg.getPayload();
        log.debug((Object)("DKSNode:LOOKUPRESULT:" + np.getID() + "-->" + this.myDKSRef.getID() + " msgID(" + msgId + ")), t=" + t + ", pred=" + this.predecessor.getID() + ", TYPE=" + type + ", STACK=" + stack.size()));
        if (type == LookupType.ADDRESS || type == LookupType.JOINADDRESS || type == LookupType.SYNCDATA) {
            if (stack.size() == 1) {
                LookupResponseMsg lrm = null;
                if (type == LookupType.ADDRESS || type == LookupType.JOINADDRESS) {
                    lrm = new LookupResponseMsg(t, type, msgId);
                }
                if (type == LookupType.SYNCDATA) {
                    lrm = new LookupResponseMsg(t, type, payload, msgId);
                }
                DKSRef dest = (DKSRef)stack.elementAt(0);
                this.send(dest, lrm);
            } else if (stack.size() > 1) {
                DKSRef dest = (DKSRef)stack.elementAt(0);
                stack.removeElementAt(0);
                LookupResultMsg lrm = null;
                if (type == LookupType.ADDRESS || type == LookupType.JOINADDRESS) {
                    lrm = new LookupResultMsg(t, type, stack, msgId);
                }
                if (type == LookupType.SYNCDATA) {
                    lrm = new LookupResultMsg(t, type, stack, payload, msgId);
                }
                this.send(dest, lrm);
            }
        }
    }

    private void broadcastCallbackInternal(DKSObject payload, boolean internal) {
        if (!internal) {
            this.appHandler.broadcastCallback(payload);
        } else {
            DKSMessage msg = DKSMessage.unmarshal(payload.getData());
            if (msg instanceof CorrectionOnJoinMsg) {
                this.cocJoinNotificationH((CorrectionOnJoinMsg)msg);
            } else if (msg instanceof CorrectionOnLeaveMsg) {
                this.cocLeaveNotificationH((CorrectionOnLeaveMsg)msg);
            } else {
                log.error((Object)"broadcastCallbackInternal got an unknown internal message");
            }
        }
    }

    public void broadCastH(DKSRef sender, BroadCastMsg msg) {
        long start = msg.getStart();
        long limit = msg.getLimit();
        long myId = this.myDKSRef.getID();
        DKSObject payload = msg.getPayload();
        log.debug((Object)("ReceivedBroadCast from: " + sender.getID() + " start: " + start + " limit: " + limit));
        this.broadcastCallbackInternal(payload, msg.getInternal());
        if (!sender.equals(this.myDKSRef) && MathMisc.belongsToII(this.predecessor.getID(), start, myId, N)) {
            this.send(this.predecessor, new BroadCastMsg(start, myId, payload, msg.getInternal()));
            this.send(sender, new BadPointerMsg(this.predecessor));
        }
        for (int l = 1; l <= this.routingTable.getLevels(); ++l) {
            for (int i = K - 1; i > 0; --i) {
                DKSRef responsible = this.routingTable.getResponsible(l, i);
                if (!MathMisc.belongsTonn(responsible.getID(), myId, limit, N)) continue;
                long bc_start = this.routingTable.getBegin(l, i);
                this.send(responsible, new BroadCastMsg(bc_start, limit, payload, msg.getInternal()));
                limit = bc_start;
            }
        }
    }

    public void badPointerH(DKSRef sender, BadPointerMsg msg) {
        DKSRef p = msg.getP();
        log.debug((Object)("DKSNode:BADPOINTER:" + sender.getID() + "-->" + this.myDKSRef.getID() + " better ref " + p.getID()));
        this.updateRingInfo(p);
    }

    public void forward(ForwardedMsgInterface msg) {
        long target = msg.getTarget();
        DKSRef nextHop = this.routingTable.getIntervalResp(target);
        long start = this.routingTable.getIntervalStart(target);
        msg.setIntervalStart(start);
        this.send(nextHop, (DKSMessage)((Object)msg));
    }

    public DKSRef bestCandidate(DKSRef node, long target) {
        DKSRef cand = this.myDKSRef;
        ListIterator iter = this.backList.listIterator();
        while (iter.hasNext()) {
            DKSRef ele = (DKSRef)iter.next();
            if (!MathMisc.belongsTo(target, node.getID(), ele.getID(), N)) continue;
            cand = ele;
        }
        return cand;
    }

    public boolean correctionOnUse(DKSRef sender, ForwardedMsgInterface msg) {
        this.updateRingInfo(sender);
        long start = msg.getIntervalStart();
        long target = msg.getTarget();
        if (sender.equals(this.predecessor)) {
            return false;
        }
        if (MathMisc.belongsTo(start, sender.getID(), this.predecessor.getID(), N)) {
            log.debug((Object)("CorUse sender: " + sender.getID() + " target: " + target + " start: " + start));
            log.debug((Object)("Backlist " + this.backList));
            DKSRef cand = this.bestCandidate(sender, start);
            log.debug((Object)("bestCandidate: " + cand.getID()));
            this.send(sender, new BadPointerMsg(cand));
            if (MathMisc.belongsTo(target, sender.getID(), this.predecessor.getID(), N)) {
                this.send(cand, (DKSMessage)((Object)msg));
                return true;
            }
        }
        return false;
    }

    public AsyncOperation findResponsible(long identifier) {
        AsyncOperation find = AsyncOperation.start(OperationType.FINDTYPE);
        LookupRequestMsg lm = new LookupRequestMsg(identifier, LookupType.ADDRESS, find.getKey(), true);
        this.send(this.myDKSRef, lm);
        return find;
    }

    public AsyncOperation route(long identifier, DKSObject payload) {
        AsyncOperation find = AsyncOperation.start(OperationType.DATATYPE);
        LookupRequestMsg lm = new LookupRequestMsg(identifier, LookupType.SYNCDATA, payload, find.getKey(), false);
        this.send(this.myDKSRef, lm);
        return find;
    }

    public void routeAsync(long identifier, DKSObject payload) {
        this.routeAsync(identifier, payload, false);
    }

    public void routeAsync(long identifier, DKSObject payload, boolean internal) {
        this.routeAsyncFrom(identifier, payload, internal, this.myDKSRef);
    }

    public void routeAsyncFrom(long identifier, DKSObject payload, boolean internal, DKSRef firstNode) {
        AsyncOperation find = AsyncOperation.start(OperationType.DATATYPE);
        LookupRequestMsg lm = new LookupRequestMsg(identifier, LookupType.ASYNCDATA, payload, find.getKey(), internal);
        this.send(firstNode, lm);
    }

    private void routeCallbackAsync(long target, DKSObject payload, boolean internal) {
        if (payload.getType() == DKSObjectTypes.DKSRESTBCAST) {
            this.broadCastRestrictedCallback(payload);
        } else if (!internal) {
            this.appHandler.routeCallbackAsync(target, payload);
        } else {
            DKSMessage msg = DKSMessage.unmarshal(payload.getData());
            if (msg instanceof CorrectionOnChangeInterface) {
                this.correctionOnChangeH((CorrectionOnChangeInterface)((Object)msg));
            } else {
                log.error((Object)"routeCallbackAsync got an unknown internal message");
            }
        }
    }

    public DKSMarshal getDKSMarshal() {
        return this.marshal;
    }

    @Override
    public DKSCallbackInterface setCallbackHandler(DKSAppInterface appHandler) {
        this.appHandler = appHandler;
        return this;
    }

    public void search(long key, JTextField jtvalue, String msgId) {
    }

    public DKSObject[] lookup(long key) {
        return DKSLookup.lookup(this, key);
    }

    public NodeInfo getNodeInfo() {
        int levels = this.routingTable.getLevels();
        NodeInfo ans = new NodeInfo(N, K, L, this.status);
        ans.frontList = (DKSRef[])this.frontList.toArray();
        ans.backList = (DKSRef[])this.backList.toArray();
        ans.predecessor = this.predecessor;
        ans.successor = this.successor;
        for (int l = 1; l <= levels; ++l) {
            for (int i = 0; i < K; ++i) {
                RTEntry rt;
                ans.routingTable[l - 1][i] = rt = new RTEntry(this.routingTable.getBegin(l, i), this.routingTable.getEnd(l, i), this.routingTable.getResponsible(l, i));
            }
        }
        return ans;
    }

    public Serializable getDebugInfo() {
        return null;
    }

    public CommunicationInfo getComInfo() {
        return this.cm.getComInfo();
    }

    public synchronized MessageInfo[] getMessageInfo() {
        MessageInfo[] array = this.statisticsSentMessages.toArray(new MessageInfo[0]);
        this.statisticsSentMessages.clear();
        return array;
    }

    public DKSRef getDKSRef() {
        return this.myDKSRef;
    }

    public void broadCast(DKSObject message) {
        log.debug((Object)"broadCast request");
        this.send(this.myDKSRef, new BroadCastMsg(this.myDKSRef.getID(), this.myDKSRef.getID(), message));
    }

    public void broadCastRestricted(DKSObject message, long startId, long endId) {
        log.debug((Object)"broadCastRestricted request");
        BroadCastMsg m = new BroadCastMsg(startId, endId, message);
        DKSObject obj = new DKSObject(DKSObjectTypes.DKSRESTBCAST, m.flatten());
        this.routeAsync(startId, obj);
    }

    public void broadCastRestrictedCallback(DKSObject message) {
        if (message.getType() == DKSObjectTypes.DKSRESTBCAST) {
            BroadCastMsg m = (BroadCastMsg)DKSMessage.unmarshal(message.getData());
            log.debug((Object)"broadCastRest started from start of interval");
            this.send(this.myDKSRef, m);
        } else {
            log.error((Object)"Got a broadCastRestrictedCallback() but message type was not DKSRESTBCAST");
        }
    }

    public void failureHandler(DKSRef src, FailureMsg fm) {
        log.warn((Object)("Failure sending from:" + fm.getSrc() + " to:" + fm.getDest() + " msg:" + fm.getMsg()));
        if (fm.getMsg() instanceof HeartbeatMsg) {
            long currTimeoutId = ((HeartbeatMsg)fm.getMsg()).getValue();
            if (Math.abs(currTimeoutId - this.lastTimeoutId) > 10L) {
                this.numTimeouts = 0;
            }
            if (this.numTimeouts++ >= 5) {
                this.numTimeouts = 0;
                final DKSRef failed = this.predecessor;
                this.nodeLeft(failed);
                this.predecessor = (DKSRef)this.backList.getFirst();
                if (this.predecessor == null) {
                    this.predecessor = this.myDKSRef;
                }
                this.nodeFailed(failed);
                if (this.IamInsertingNode || this.IamRemovingNode || this.status != DKSStatus.INSIDE) {
                    log.warn((Object)("Node failure while doing atomic action: IamInserting:" + this.IamInsertingNode + " IamRemoving:" + this.IamRemovingNode + " failed:" + src + " status:" + this.status));
                }
                this.IamInsertingNode = false;
                this.IamRemovingNode = false;
                DKSRef pred = null;
                if (this.backList.size() >= 1) {
                    pred = (DKSRef)this.backList.get(0);
                }
                if (pred != null && failed != null && this.myDKSRef != null) {
                    DKSRef n;
                    this.correctionOnChangeLeave(pred, failed, this.myDKSRef);
                    ListIterator it = this.backList.listIterator();
                    while (it.hasNext()) {
                        n = (DKSRef)it.next();
                        this.send(n, new NodeLeftMsg(failed, this.frontList, this.removedNonces.getRecent(100)));
                    }
                    it = this.frontList.listIterator();
                    while (it.hasNext()) {
                        n = (DKSRef)it.next();
                        this.send(n, new NodeLeftMsg(failed, this.backList, this.removedNonces.getRecent(100)));
                    }
                    try {
                        final DKSRef pred2 = DKSRef.valueOf(pred.getDKSURL());
                        Runnable callbackObj = new Runnable(){

                            @Override
                            public void run() {
                                DKSNode.this.appHandler.failCallback(failed, pred2);
                            }
                        };
                        this.threadPool.addJob(callbackObj);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            this.lastTimeoutId = ((HeartbeatMsg)fm.getMsg()).getValue();
        }
    }

    public void heartbeatH(DKSRef succ, HeartbeatMsg hm) {
    }

    public boolean addMsgHandler(DKSMessage msg, Object handlerObject, String methodName) {
        DKSOverlayAddress oa = this.myDKSRef.getOverlayAddress();
        return this.marshal.addMsgHandler(oa, msg.getClass().getName(), handlerObject.getClass().getName(), methodName, handlerObject);
    }

    protected void installHandlers() {
        DKSOverlayAddress oa = this.myDKSRef.getOverlayAddress();
        DKSMessage.addMessageTypePrefixed("LOOKUPREQUEST", "dks_marshal.LookupRequestMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.LookupRequestMsg", "dks_node.DKSNode", "lookupRequestH", this);
        DKSMessage.addMessageTypePrefixed("LOOKUP", "dks_marshal.LookupMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.LookupMsg", "dks_node.DKSNode", "lookupH", this);
        DKSMessage.addMessageTypePrefixed("LOOKUPRESPONSE", "dks_marshal.LookupResponseMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.LookupResponseMsg", "dks_node.DKSNode", "lookupResponseH", this);
        DKSMessage.addMessageTypePrefixed("ACKJOININIT", "dks_marshal.AckJoinInitMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.AckJoinInitMsg", "dks_node.DKSNode", "ackJoinInitH", this);
        DKSMessage.addMessageTypePrefixed("HELLO", "dks_marshal.HelloMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.HelloMsg", "dks_node.DKSNode", "helloH", this);
        DKSMessage.addMessageTypePrefixed("ACKHELLO", "dks_marshal.AckHelloMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.AckHelloMsg", "dks_node.DKSNode", "ackHelloH", this);
        DKSMessage.addMessageTypePrefixed("BECOMENORMAL", "dks_marshal.BecomeNormalMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.BecomeNormalMsg", "dks_node.DKSNode", "becomeNormalH", this);
        DKSMessage.addMessageTypePrefixed("JOININIT", "dks_marshal.JoinInitMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.JoinInitMsg", "dks_node.DKSNode", "joinInitH", this);
        DKSMessage.addMessageTypePrefixed("RESTARTJOIN", "dks_marshal.RestartJoinMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.RestartJoinMsg", "dks_node.DKSNode", "restartJoinH", this);
        DKSMessage.addMessageTypePrefixed("ADAPT", "dks_marshal.AdaptMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.AdaptMsg", "dks_node.DKSNode", "adaptH", this);
        DKSMessage.addMessageTypePrefixed("ADAPTLEAVE", "dks_marshal.AdaptLeaveMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.AdaptLeaveMsg", "dks_node.DKSNode", "adaptLeaveH", this);
        DKSMessage.addMessageTypePrefixed("LEAVEREQUEST", "dks_marshal.LeaveRequestMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.LeaveRequestMsg", "dks_node.DKSNode", "leaveRequestH", this);
        DKSMessage.addMessageTypePrefixed("LEAVEREJECT", "dks_marshal.LeaveRejectMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.LeaveRejectMsg", "dks_node.DKSNode", "leaveRejectH", this);
        DKSMessage.addMessageTypePrefixed("LEAVEACCEPT", "dks_marshal.LeaveAcceptMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.LeaveAcceptMsg", "dks_node.DKSNode", "leaveAcceptH", this);
        DKSMessage.addMessageTypePrefixed("BYE", "dks_marshal.ByeMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.ByeMsg", "dks_node.DKSNode", "byeH", this);
        DKSMessage.addMessageTypePrefixed("ACKBYE", "dks_marshal.AckByeMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.AckByeMsg", "dks_node.DKSNode", "ackByeH", this);
        DKSMessage.addMessageTypePrefixed("LOOKUPRESULT", "dks_marshal.LookupResultMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.LookupResultMsg", "dks_node.DKSNode", "lookupResultH", this);
        DKSMessage.addMessageTypePrefixed("INSERTNODE", "dks_marshal.InsertNodeMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.InsertNodeMsg", "dks_node.DKSNode", "insertNodeH", this);
        DKSMessage.addMessageTypePrefixed("BADPOINTER", "dks_marshal.BadPointerMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.BadPointerMsg", "dks_node.DKSNode", "badPointerH", this);
        DKSMessage.addMessageTypePrefixed("BROADCAST", "dks_marshal.BroadCastMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.BroadCastMsg", "dks_node.DKSNode", "broadCastH", this);
        DKSMessage.addMessageTypePrefixed("CORRECTIONONJOIN", "dks_marshal.CorrectionOnJoinMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.CorrectionOnJoinMsg", "dks_node.DKSNode", "cocJoinInterleavedH", this);
        DKSMessage.addMessageTypePrefixed("RESTARTOPERATION", "dks_marshal.RestartOperationMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.RestartOperationMsg", "dks_node.DKSNode", "restartOperationH", this);
        DKSMessage.addMessageTypePrefixed("CORRECTIONONLEAVE", "dks_marshal.CorrectionOnLeaveMsg");
        DKSMessage.addMessageTypePrefixed("NODELEFTMSG", "dks_marshal.NodeLeftMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.NodeLeftMsg", "dks_node.DKSNode", "nodeLeftH", this);
        DKSMessage.addMessageTypePrefixed("FAILUREMSG", "dks_marshal.FailureMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.FailureMsg", "dks_node.DKSNode", "failureHandler", this);
        DKSMessage.addMessageTypePrefixed("HEARTBEATMSG", "dks_marshal.HeartbeatMsg");
        this.marshal.addMsgHandlerPrefixed(oa, "dks_marshal.HeartbeatMsg", "dks_node.DKSNode", "heartbeatH", this);
    }

    private class Heartbeat
    extends TimerTask {
        private long counter = 0L;

        private Heartbeat() {
        }

        @Override
        public void run() {
            HeartbeatMsg h;
            if (DKSNode.this.predecessor == null || DKSNode.this.predecessor.equals(DKSNode.this.myDKSRef)) {
                return;
            }
            if (!DKSNode.this.send(DKSNode.this.predecessor, h = new HeartbeatMsg(this.counter++))) {
                DKSNode.this.failureHandler(DKSNode.this.predecessor, new FailureMsg(DKSNode.this.myDKSRef, DKSNode.this.predecessor, h));
            }
        }
    }
}

