/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.kth.dks.dks_marshal.SAXHandler;
import org.kth.dks.dks_marshal.XMLAttribute;
import org.kth.dks.dks_marshal.XMLElement;
import org.kth.dks.dks_marshal.XMLMessage;
import org.kth.dks.util.Future;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSAXParser {
    protected SAXParser saxParser = new SAXParser();

    public XMLSAXParser(Future xmlFutureBuffer) {
        this.saxParser.setContentHandler((ContentHandler)new SAXHandler(this, xmlFutureBuffer));
    }

    public void parse(byte[] inputXML) {
        if (this.saxParser == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(inputXML);
        InputSource is = new InputSource(bais);
        try {
            this.saxParser.parse(is);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
    }

    public static String make(XMLMessage xmlMsg) {
        String xml = null;
        OutputFormat outputFormat = new OutputFormat("XML", "ISO-8859-1", true);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)stringWriter, outputFormat);
        try {
            ContentHandler handler = serializer.asContentHandler();
            handler.startDocument();
            AttributesImpl atts = new AttributesImpl();
            XMLElement xmlElement = null;
            XMLElement xmlElementRoot = null;
            XMLAttribute xmlAttribute = null;
            String data = null;
            xmlElementRoot = xmlMsg.getElementAt(0);
            data = xmlElementRoot.getData();
            atts.clear();
            for (int j = 0; j < xmlElementRoot.getAttributesCount(); ++j) {
                xmlAttribute = xmlElementRoot.getAttributeAt(j);
                atts.addAttribute("", "", xmlAttribute.getName(), "CDATA", xmlAttribute.getValue());
            }
            handler.startElement("", "", xmlElementRoot.getName(), atts);
            if (data != null) {
                handler.characters(data.toCharArray(), 0, data.length());
            }
            for (int i = 1; i < xmlMsg.size(); ++i) {
                xmlElement = xmlMsg.getElementAt(i);
                data = xmlElement.getData();
                atts.clear();
                for (int j = 0; j < xmlElement.getAttributesCount(); ++j) {
                    xmlAttribute = xmlElement.getAttributeAt(j);
                    atts.addAttribute("", "", xmlAttribute.getName(), "CDATA", xmlAttribute.getValue());
                }
                handler.startElement("", "", xmlElement.getName(), atts);
                if (data != null) {
                    handler.characters(data.toCharArray(), 0, data.length());
                }
                handler.endElement("", "", xmlElement.getName());
            }
            handler.endElement("", "", xmlElementRoot.getName());
            handler.endDocument();
            xml = stringWriter.getBuffer().toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            xml = null;
        }
        catch (SAXException ex1) {
            ex1.printStackTrace();
        }
        return xml;
    }
}

