/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.util.Vector;
import org.kth.dks.dks_marshal.XMLAttribute;
import org.kth.dks.dks_marshal.XMLElement;
import org.kth.dks.dks_marshal.XMLMessage;
import org.kth.dks.dks_marshal.XMLSAXParser;
import org.kth.dks.util.Future;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXHandler
extends DefaultHandler {
    private Vector elements = null;
    private String data = null;
    private XMLSAXParser myParent = null;
    private Future xmlFutureBuffer = null;

    SAXHandler(XMLSAXParser myparent, Future xmlFutureBuffer) {
        this.myParent = myparent;
        this.elements = new Vector();
        this.xmlFutureBuffer = xmlFutureBuffer;
    }

    @Override
    public void startDocument() throws SAXException {
        this.elements.clear();
        this.data = null;
    }

    @Override
    public void endDocument() throws SAXException {
        XMLMessage xmlMsg = new XMLMessage();
        for (int i = 0; i < this.elements.size(); ++i) {
            xmlMsg.addElement((XMLElement)this.elements.elementAt(i));
        }
        this.xmlFutureBuffer.store(xmlMsg);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        XMLElement xmlElement = new XMLElement(qName, null);
        this.elements.add(xmlElement);
        this.data = null;
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                xmlElement.addAttribute(new XMLAttribute(attrs.getQName(i), attrs.getValue(i)));
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (this.data != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                XMLElement xmle = (XMLElement)this.elements.elementAt(i);
                if (!xmle.getName().equals(qName)) continue;
                xmle.setData(this.data);
                break;
            }
            this.data = null;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.data = new String(buf, offset, len);
    }
}

