/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;

public class ObjectAdapter
implements Runnable {
    private Logger log = Logger.getLogger(ObjectAdapter.class);
    private boolean stopped = false;
    private List msgQueue = Collections.synchronizedList(new LinkedList());
    private final long MAXQUEUE = 1000000L;
    private Map handlerMap = new HashMap();

    @Override
    public void run() {
        while (!this.stopped) {
            MessagePair mp = this.getMessagePair();
            if (mp == null) continue;
            this.callMessageHandler(mp.getMsg(), mp.getSrc());
        }
        this.msgQueue.clear();
    }

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessagePair(DKSMessage m, DKSRef s) {
        List list = this.msgQueue;
        synchronized (list) {
            while ((long)this.msgQueue.size() >= 1000000L) {
                try {
                    this.msgQueue.wait();
                }
                catch (Exception ex) {
                    this.log.error((Object)(ex + ""));
                }
            }
            boolean result = this.msgQueue.add(new MessagePair(m, s));
            if (this.msgQueue.size() == 1) {
                this.msgQueue.notify();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessagePair getMessagePair() {
        MessagePair mp = null;
        List list = this.msgQueue;
        synchronized (list) {
            while (this.msgQueue.isEmpty()) {
                try {
                    this.msgQueue.wait();
                }
                catch (InterruptedException ex) {
                    this.stop();
                    return null;
                }
            }
            if ((long)this.msgQueue.size() == 1000000L) {
                this.msgQueue.notifyAll();
            }
            mp = (MessagePair)this.msgQueue.remove(0);
        }
        return mp;
    }

    public boolean addMsgHandler(String messageClassZ, String handlerClassZ, String handlerMethodZ, Object handlerObject) {
        try {
            Class<?> cdksref = Class.forName("org.kth.dks.dks_comm.DKSRef");
            Class<?> msgClass = Class.forName(messageClassZ);
            Class<?> handlerClass = Class.forName(handlerClassZ);
            Method handlerMethod = handlerClass.getDeclaredMethod(handlerMethodZ, cdksref, msgClass);
            this.handlerMap.put(msgClass, new HandlerPair(handlerMethod, handlerObject));
            return true;
        }
        catch (Exception ex) {
            this.log.error((Object)("Class not found, could not install unmarshaller (MessageClass=" + messageClassZ + ") (HandlerClass=" + handlerClassZ + ") (HandlerMethod=" + handlerMethodZ + ")\n" + ex));
            return false;
        }
    }

    public boolean callMessageHandler(DKSMessage dksMsg, DKSRef source) {
        try {
            Class<?> messageClass = dksMsg.getClass();
            if (this.handlerMap.get(messageClass) == null) {
                return false;
            }
            HandlerPair hp = (HandlerPair)this.handlerMap.get(messageClass);
            Method handlerMethod = hp.getMethod();
            Object handlerObject = hp.getHandlerObject();
            this.log.debug((Object)("Invoking(msg:" + dksMsg.getClass() + ", src:" + source + ")"));
            handlerMethod.invoke(handlerObject, source, dksMsg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    class MessagePair {
        private final DKSMessage msg;
        private final DKSRef src;

        public MessagePair(DKSMessage m, DKSRef s) {
            this.msg = m;
            this.src = s;
        }

        public DKSMessage getMsg() {
            return this.msg;
        }

        public DKSRef getSrc() {
            return this.src;
        }
    }

    class HandlerPair {
        private final Method method;
        private final Object handlerObject;

        public HandlerPair(Method m, Object o) {
            this.method = m;
            this.handlerObject = o;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getHandlerObject() {
            return this.handlerObject;
        }
    }
}

