/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_marshal.MarshalInterface;
import org.kth.dks.dks_marshal.XMLAttribute;
import org.kth.dks.dks_marshal.XMLElement;
import org.kth.dks.dks_marshal.XMLMessage;
import org.kth.dks.dks_marshal.XMLSAXParser;
import org.kth.dks.util.Future;
import org.kth.dks.util.ReusableFuture;

public class MarshalXML
extends MarshalInterface {
    private static Logger log = Logger.getLogger(MarshalXML.class);
    protected int pCount = 0;
    protected XMLMessage xmsg = null;
    protected XMLElement ele;
    protected int eleCnt = 0;
    private static final String BASEPACKAGE = "org.kth.dks.";
    private static Future xmlPlaceholder = new ReusableFuture();
    private static XMLSAXParser saxParser = new XMLSAXParser(xmlPlaceholder);

    public MarshalXML(DKSMessage m) {
        super(m);
    }

    @Override
    public byte[] flatten() {
        this.pCount = 0;
        this.eleCnt = 0;
        this.xmsg = new XMLMessage();
        this.ele = new XMLElement(this.msg.getName(), null);
        this.xmsg.addElement(this.ele);
        try {
            if (this.msg.getSendRef() != null) {
                this.msg.marshaler.addDKSRef(this.msg.getSendRef(), "SrcRef");
            }
            if (this.msg.getRecvRef() != null) {
                this.msg.marshaler.addDKSRef(this.msg.getRecvRef(), "DstRef");
            }
            this.msg.marshal();
        }
        catch (IOException ex) {
            log.error((Object)("Error marshaling:\n" + ex));
        }
        return MarshalXML.marshalXMLToMessage(this.xmsg);
    }

    public void unflatten(DKSMessage msg, XMLMessage xml) {
        this.pCount = 0;
        this.eleCnt = 0;
        this.xmsg = xml;
        this.ele = xml.getElementAt(0);
        try {
            msg.setSendRef(msg.marshaler.remDKSRef("SrcRef"));
            msg.setRecvRef(msg.marshaler.remDKSRef("DstRef"));
            msg.unmarshal();
        }
        catch (IOException ex) {
            log.error((Object)("Error unmarshaling:\n" + ex));
        }
        this.xmsg = null;
        this.ele = null;
    }

    public static DKSMessage unflatten(byte[] raw) {
        XMLMessage xmlMsg = MarshalXML.byteToXML(raw);
        DKSMessage dksMsg = MarshalXML.xmlToDKSMessage(xmlMsg);
        if (null == dksMsg) {
            log.error((Object)("DKSMarshal -- Got an unknown message " + xmlMsg.getElementAt(0).getName()));
            return null;
        }
        ((MarshalXML)dksMsg.marshaler).unflatten(dksMsg, xmlMsg);
        return dksMsg;
    }

    public static byte[] marshalXMLToMessage(XMLMessage xmlmsg) {
        String xml = XMLSAXParser.make(xmlmsg);
        return xml.getBytes();
    }

    public static synchronized XMLMessage byteToXML(byte[] input) {
        saxParser.parse(input);
        XMLMessage result = null;
        try {
            result = (XMLMessage)xmlPlaceholder.get();
        }
        catch (Exception ex) {
            log.error((Object)("Interrupted while waiting for SAX parser to parse document (" + ex.getMessage() + ")\n"));
        }
        return result;
    }

    public static DKSMessage xmlToDKSMessage(XMLMessage xmlMsg) {
        if (xmlMsg == null) {
            return null;
        }
        XMLElement xmlElement = xmlMsg.getElementAt(0);
        if (xmlElement == null) {
            return null;
        }
        if (DKSMessage.messageMap.get(xmlElement.getName()) != null) {
            try {
                Class messageClass = (Class)DKSMessage.messageMap.get(xmlElement.getName());
                DKSMessage msg = (DKSMessage)messageClass.newInstance();
                return msg;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void addLong(long val) {
        this.addLong(val, String.valueOf(this.pCount));
    }

    @Override
    public void addLong(long val, String na) {
        this.ele.addAttribute(new XMLAttribute(na, String.valueOf(val)));
        ++this.pCount;
    }

    @Override
    public void addInt(int val) {
        this.addInt(val, String.valueOf(this.pCount));
    }

    @Override
    public void addInt(int val, String na) {
        this.ele.addAttribute(new XMLAttribute(na, String.valueOf(val)));
        ++this.pCount;
    }

    @Override
    public void addString(String val) {
        this.addString(val, String.valueOf(this.pCount));
    }

    @Override
    public void addString(String val, String na) {
        this.ele.addAttribute(new XMLAttribute(na, val));
        ++this.pCount;
    }

    @Override
    public void addBool(boolean val) {
        this.addBool(val, String.valueOf(this.pCount));
    }

    @Override
    public void addBool(boolean val, String na) {
        this.ele.addAttribute(new XMLAttribute(na, Boolean.toString(val)));
        ++this.pCount;
    }

    @Override
    public void addDKSObject(DKSObject val) {
        this.addDKSObject(val, String.valueOf(this.pCount));
    }

    @Override
    public void addDKSObject(DKSObject val, String na) {
        this.ele.addAttribute(new XMLAttribute(na, val.toString()));
        ++this.pCount;
    }

    @Override
    public void addDKSRef(DKSRef val) {
        this.addDKSRef(val, String.valueOf(this.pCount));
    }

    @Override
    public void addDKSRef(DKSRef val, String na) {
        this.ele.addAttribute(new XMLAttribute(na, val.getDKSURL()));
        ++this.pCount;
    }

    @Override
    public void addDKSNetAddress(DKSNetAddress val) {
        this.addDKSNetAddress(val, String.valueOf(this.pCount));
    }

    @Override
    public void addDKSNetAddress(DKSNetAddress val, String na) {
        this.ele.addAttribute(new XMLAttribute(na, val.getDKSNetURL()));
        ++this.pCount;
    }

    @Override
    public void addDKSRefArray(DKSRef[] val) {
        this.addDKSRefArray(val, String.valueOf(this.pCount));
    }

    @Override
    public void addDKSRefArray(DKSRef[] val, String na) {
        XMLElement ele = new XMLElement(na, "");
        for (int i = 0; i < val.length; ++i) {
            ele.addAttribute(new XMLAttribute("DKSREF" + i, val[i].getDKSURL()));
        }
        this.xmsg.addElement(ele);
        ++this.pCount;
    }

    @Override
    public final void addByteArray(byte[] m) throws IOException {
        this.addByteArray(m, "");
    }

    @Override
    public final void addByteArray(byte[] m, String na) throws IOException {
        DKSObject o = new DKSObject(m);
        this.addString(o.toString(), na);
    }

    @Override
    public String remString() {
        return this.remString(String.valueOf(this.pCount));
    }

    @Override
    public String remString(String na) {
        do {
            Iterator i = this.ele.getAttributes().iterator();
            while (i.hasNext()) {
                XMLAttribute attrs = (XMLAttribute)i.next();
                if (!attrs.getName().equals(na)) continue;
                ++this.pCount;
                i.remove();
                return attrs.getValue();
            }
            ++this.eleCnt;
            this.ele = this.xmsg.getElementAt(this.eleCnt);
        } while (this.eleCnt < this.xmsg.size());
        this.eleCnt = 0;
        this.ele = this.xmsg.getElementAt(this.eleCnt);
        return null;
    }

    @Override
    public long remLong() {
        return this.remLong(String.valueOf(this.pCount));
    }

    @Override
    public long remLong(String na) {
        return Long.parseLong(this.remString(na));
    }

    @Override
    public int remInt() {
        return this.remInt(String.valueOf(this.pCount));
    }

    @Override
    public int remInt(String na) {
        return Integer.parseInt(this.remString(na));
    }

    @Override
    public boolean remBool() {
        return this.remBool(String.valueOf(this.pCount));
    }

    @Override
    public boolean remBool(String na) {
        return Boolean.valueOf(this.remString(na));
    }

    @Override
    public DKSObject remDKSObject() {
        return this.remDKSObject(String.valueOf(this.pCount));
    }

    @Override
    public DKSObject remDKSObject(String na) {
        String s = this.remString(na);
        return na != null ? new DKSObject(s) : null;
    }

    @Override
    public DKSRef remDKSRef() {
        return this.remDKSRef(String.valueOf(this.pCount));
    }

    @Override
    public DKSRef remDKSRef(String na) {
        try {
            String s = this.remString(na);
            return s == null ? null : DKSRef.valueOf(s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public DKSNetAddress remDKSNetAddress() {
        return this.remDKSNetAddress(String.valueOf(this.pCount));
    }

    @Override
    public DKSNetAddress remDKSNetAddress(String na) {
        try {
            String s = this.remString(na);
            return s == null ? null : new DKSNetAddress(s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public List remDKSRefArray() {
        return this.remDKSRefArray(String.valueOf(this.pCount));
    }

    @Override
    public List remDKSRefArray(String na) {
        ArrayList<DKSRef> l = new ArrayList<DKSRef>();
        for (XMLElement e : this.xmsg.getElements()) {
            if (!e.getName().equals(na)) continue;
            for (XMLAttribute a : e.getAttributes()) {
                try {
                    l.add(DKSRef.valueOf(a.getValue()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++this.pCount;
            return l;
        }
        return null;
    }

    @Override
    public final byte[] remByteArray() throws IOException {
        return this.remByteArray("");
    }

    @Override
    public final byte[] remByteArray(String na) throws IOException {
        DKSObject o = new DKSObject(this.remString(na));
        return o.getData();
    }
}

