/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.kth.dks.DKSObject;
import org.kth.dks.DKSObjectTypes;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_marshal.MarshalInterface;

public class MarshalBinary
extends MarshalInterface {
    private Logger log = Logger.getLogger(MarshalBinary.class);
    private DataInputStream rawIn;
    private DataOutputStream rawOut;
    private static final String BASEPACKAGE = "org.kth.dks.";

    public MarshalBinary(DKSMessage m) {
        super(m);
    }

    @Override
    public byte[] flatten() {
        ByteArrayOutputStream as = new ByteArrayOutputStream();
        this.rawOut = new DataOutputStream(as);
        try {
            this.rawOut.writeUTF(this.msg.getName());
            this.rawOut.writeBoolean(this.msg.getSendRef() != null);
            if (this.msg.getSendRef() != null) {
                this.msg.marshaler.addDKSRef(this.msg.getSendRef(), "SrcRef");
            }
            this.rawOut.writeBoolean(this.msg.getRecvRef() != null);
            if (this.msg.getRecvRef() != null) {
                this.msg.marshaler.addDKSRef(this.msg.getRecvRef(), "DstRef");
            }
            this.msg.marshal();
        }
        catch (IOException ex) {
            this.log.error((Object)("Error marshaling:\n" + ex));
        }
        byte[] ret = as.toByteArray();
        as = null;
        this.rawOut = null;
        return ret;
    }

    public void unflatten(DataInputStream raw) {
        this.rawIn = raw;
        try {
            boolean anydest;
            boolean anysrc = this.msg.marshaler.remBool();
            if (anysrc) {
                this.msg.setSendRef(this.msg.marshaler.remDKSRef("SrcRef"));
            }
            if (anydest = this.msg.marshaler.remBool()) {
                this.msg.setRecvRef(this.msg.marshaler.remDKSRef("DstRef"));
            }
            this.msg.unmarshal();
        }
        catch (IOException ex) {
            this.rawIn = null;
            this.log.error((Object)("Error unmarshaling:\n" + ex));
        }
        this.rawIn = null;
    }

    public static DKSMessage unflatten(byte[] raw) {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(raw);
            DataInputStream din = new DataInputStream(bin);
            String name = din.readUTF();
            DKSMessage msg = null;
            if (DKSMessage.messageMap.get(name) != null) {
                Class messageClass = (Class)DKSMessage.messageMap.get(name);
                msg = (DKSMessage)messageClass.newInstance();
                ((MarshalBinary)msg.marshaler).unflatten(din);
            }
            return msg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public final void addLong(long val) throws IOException {
        this.addLong(val, null);
    }

    @Override
    public final void addLong(long val, String na) throws IOException {
        this.rawOut.writeLong(val);
    }

    @Override
    public final void addInt(int val) throws IOException {
        this.addInt(val, null);
    }

    @Override
    public final void addInt(int val, String na) throws IOException {
        this.rawOut.writeInt(val);
    }

    @Override
    public final void addString(String val) throws IOException {
        this.addString(val, null);
    }

    @Override
    public final void addString(String val, String na) throws IOException {
        this.rawOut.writeUTF(val);
    }

    @Override
    public final void addBool(boolean val) throws IOException {
        this.addBool(val, null);
    }

    @Override
    public final void addBool(boolean val, String na) throws IOException {
        this.rawOut.writeBoolean(val);
    }

    @Override
    public final void addDKSObject(DKSObject val) throws IOException {
        this.addDKSObject(val, null);
    }

    @Override
    public final void addDKSObject(DKSObject val, String na) throws IOException {
        this.addString(val.getType().getName());
        this.rawOut.writeInt(val.getData().length);
        this.rawOut.write(val.getData());
    }

    @Override
    public final void addDKSRef(DKSRef val) throws IOException {
        this.addDKSRef(val, null);
    }

    @Override
    public final void addDKSRef(DKSRef val, String na) throws IOException {
        this.addDKSNetAddress(val.getDKSNetAddress(), null);
        this.addDKSOverlayAddress(val.getOverlayAddress());
        this.addLong(val.getNonce());
    }

    @Override
    public final void addDKSNetAddress(DKSNetAddress val) throws IOException {
        this.addDKSNetAddress(val, null);
    }

    @Override
    public final void addDKSNetAddress(DKSNetAddress val, String na) throws IOException {
        this.addString(val.getIP());
        this.addInt(val.getPort());
    }

    public final void addDKSOverlayAddress(DKSOverlayAddress val) throws IOException {
        this.addLong(val.getID());
        this.addLong(val.getGroupId());
        this.addLong(val.getGUID());
    }

    @Override
    public final void addDKSRefArray(DKSRef[] val) throws IOException {
        this.addDKSRefArray(val, null);
    }

    @Override
    public final void addDKSRefArray(DKSRef[] val, String na) throws IOException {
        this.addInt(val.length);
        for (int i = 0; i < val.length; ++i) {
            this.addDKSRef(val[i]);
        }
    }

    @Override
    public final void addByteArray(byte[] m) throws IOException {
        this.addByteArray(m, "");
    }

    @Override
    public final void addByteArray(byte[] m, String na) throws IOException {
        this.addInt(m.length);
        this.rawOut.write(m, 0, m.length);
    }

    @Override
    public final String remString() throws IOException {
        return this.remString(null);
    }

    @Override
    public final String remString(String na) throws IOException {
        return this.rawIn.readUTF();
    }

    @Override
    public final long remLong() throws IOException {
        return this.remLong(null);
    }

    @Override
    public final long remLong(String na) throws IOException {
        return this.rawIn.readLong();
    }

    @Override
    public final int remInt() throws IOException {
        return this.remInt(null);
    }

    @Override
    public final int remInt(String na) throws IOException {
        return this.rawIn.readInt();
    }

    @Override
    public final boolean remBool() throws IOException {
        return this.remBool(null);
    }

    @Override
    public final boolean remBool(String na) throws IOException {
        return this.rawIn.readBoolean();
    }

    @Override
    public final DKSObject remDKSObject() throws IOException {
        return this.remDKSObject(null);
    }

    @Override
    public final DKSObject remDKSObject(String na) throws IOException {
        String type = this.remString();
        int len = this.remInt();
        byte[] obj = new byte[len];
        this.rawIn.read(obj, 0, len);
        return new DKSObject(DKSObjectTypes.valueOf(type), obj);
    }

    @Override
    public final DKSRef remDKSRef() throws IOException {
        return this.remDKSRef(null);
    }

    @Override
    public final DKSRef remDKSRef(String na) throws IOException {
        DKSNetAddress netadr = this.remDKSNetAddress();
        DKSOverlayAddress ovradr = this.remDKSOverlayAddress();
        return DKSRef.valueOfByParts(ovradr, netadr, this.remLong());
    }

    @Override
    public final DKSNetAddress remDKSNetAddress() throws IOException {
        return this.remDKSNetAddress(null);
    }

    @Override
    public final DKSNetAddress remDKSNetAddress(String na) throws IOException {
        return new DKSNetAddress(this.remString(), this.remInt());
    }

    public final DKSOverlayAddress remDKSOverlayAddress() throws IOException {
        return new DKSOverlayAddress(this.remLong(), this.remLong(), this.remLong());
    }

    @Override
    public final List remDKSRefArray() throws IOException {
        return this.remDKSRefArray(null);
    }

    @Override
    public final List remDKSRefArray(String na) throws IOException {
        int len = this.remInt();
        ArrayList<DKSRef> arr = new ArrayList<DKSRef>(len + 1);
        for (int i = 0; i < len; ++i) {
            arr.add(this.remDKSRef());
        }
        return arr;
    }

    @Override
    public final byte[] remByteArray() throws IOException {
        return this.remByteArray("");
    }

    @Override
    public final byte[] remByteArray(String na) throws IOException {
        int s = this.remInt();
        byte[] ret = new byte[s];
        this.rawIn.read(ret, 0, s);
        return ret;
    }
}

