/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import java.util.Vector;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.LookupType;

public class LookupResultMsg
extends DKSMessage {
    private static String NAME = "LOOKUPRESULT";
    private DKSRef t;
    private LookupType type;
    private Vector stack;
    private String msgId;
    private DKSObject payload = null;

    @Override
    public String getName() {
        return NAME;
    }

    public DKSRef getT() {
        return this.t;
    }

    public LookupType getType() {
        return this.type;
    }

    public Vector getStack() {
        return this.stack;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public DKSObject getPayload() {
        return this.payload;
    }

    public LookupResultMsg() {
    }

    public LookupResultMsg(DKSRef t, LookupType type, Vector stack, String msgId) {
        this.t = t;
        this.type = type;
        this.stack = stack;
        this.msgId = msgId;
    }

    public LookupResultMsg(DKSRef t, LookupType type, Vector vector, DKSObject payload, String msgId) {
        this.t = t;
        this.type = type;
        this.stack = vector;
        this.msgId = msgId;
        this.payload = payload;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addDKSRef(this.t, "target");
        this.marshaler.addString(this.type.toString(), "type");
        this.marshaler.addBool(this.payload != null, "anypayload");
        if (this.payload != null) {
            this.marshaler.addDKSObject(this.payload, "payload");
        }
        this.marshaler.addBool(this.msgId != null, "anyinsertid");
        if (this.msgId != null) {
            this.marshaler.addString(this.msgId, "insertid");
        }
        this.marshaler.addDKSRefArray(this.stack.toArray(new DKSRef[0]), "stack");
    }

    @Override
    public void unmarshal() throws IOException {
        boolean anyId;
        this.t = this.marshaler.remDKSRef("target");
        this.type = LookupType.valueOf(this.marshaler.remString("type"));
        boolean anyLoad = this.marshaler.remBool("anypayload");
        if (anyLoad) {
            this.payload = this.marshaler.remDKSObject("payload");
        }
        if (anyId = this.marshaler.remBool("anyinsertid")) {
            this.msgId = this.marshaler.remString("insertid");
        }
        this.stack = new Vector(this.marshaler.remDKSRefArray("stack"));
    }
}

