/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.LookupType;

public class LookupResponseMsg
extends DKSMessage {
    private static String NAME = "LOOKUPRESPONSE";
    private DKSRef targetRef;
    private LookupType type;
    private String msgId;
    private DKSObject payload = null;

    @Override
    public String getName() {
        return NAME;
    }

    public DKSRef getTargetRef() {
        return this.targetRef;
    }

    public LookupType getType() {
        return this.type;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public DKSObject getPayload() {
        return this.payload;
    }

    public LookupResponseMsg() {
    }

    public LookupResponseMsg(DKSRef target, LookupType type, String msgId) {
        this.targetRef = target;
        this.type = type;
        this.msgId = msgId;
    }

    public LookupResponseMsg(DKSRef target, LookupType type, DKSObject payload, String msgId) {
        this.targetRef = target;
        this.type = type;
        this.msgId = msgId;
        this.payload = payload;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addDKSRef(this.targetRef, "target");
        this.marshaler.addString(this.type.toString(), "type");
        this.marshaler.addBool(this.payload != null, "anypayload");
        if (this.payload != null) {
            this.marshaler.addDKSObject(this.payload, "payload");
        }
        this.marshaler.addBool(this.msgId != null, "anyinsertid");
        if (this.msgId != null) {
            this.marshaler.addString(this.msgId, "insertid");
        }
    }

    @Override
    public void unmarshal() throws IOException {
        boolean anyId;
        this.targetRef = this.marshaler.remDKSRef("target");
        this.type = LookupType.valueOf(this.marshaler.remString("type"));
        boolean anyLoad = this.marshaler.remBool("anypayload");
        if (anyLoad) {
            this.payload = this.marshaler.remDKSObject("payload");
        }
        if (anyId = this.marshaler.remBool("anyinsertid")) {
            this.msgId = this.marshaler.remString("insertid");
        }
    }
}

