/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.LookupType;

public class LookupRequestMsg
extends DKSMessage {
    private static String NAME = "LOOKUPREQUEST";
    private long target;
    private LookupType type;
    private String msgId;
    private boolean internal;
    private DKSObject payload = null;

    @Override
    public String getName() {
        return NAME;
    }

    public long getTarget() {
        return this.target;
    }

    public LookupType getType() {
        return this.type;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public DKSObject getPayload() {
        return this.payload;
    }

    public boolean getInternal() {
        return this.internal;
    }

    public LookupRequestMsg() {
    }

    public LookupRequestMsg(long target, LookupType type, String msgId, boolean intern) {
        this.target = target;
        this.type = type;
        this.msgId = msgId;
        this.internal = intern;
    }

    public LookupRequestMsg(long target, LookupType type, DKSObject payload, String msgId, boolean intern) {
        this.target = target;
        this.type = type;
        this.msgId = msgId;
        this.payload = payload;
        this.internal = intern;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addLong(this.target, "target");
        this.marshaler.addString(this.type.toString(), "type");
        this.marshaler.addBool(this.payload != null, "anypayload");
        if (this.payload != null) {
            this.marshaler.addDKSObject(this.payload, "payload");
        }
        this.marshaler.addBool(this.msgId != null, "anyinsertid");
        if (this.msgId != null) {
            this.marshaler.addString(this.msgId, "insertid");
        }
        this.marshaler.addBool(this.internal, "internal");
    }

    @Override
    public void unmarshal() throws IOException {
        boolean anyId;
        this.target = this.marshaler.remLong("target");
        this.type = LookupType.valueOf(this.marshaler.remString("type"));
        boolean anyLoad = this.marshaler.remBool("anypayload");
        if (anyLoad) {
            this.payload = this.marshaler.remDKSObject("payload");
        }
        if (anyId = this.marshaler.remBool("anyinsertid")) {
            this.msgId = this.marshaler.remString("insertid");
        }
        this.internal = this.marshaler.remBool("internal");
    }
}

