/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import java.util.Vector;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_marshal.ForwardedMsgInterface;
import org.kth.dks.dks_node.LookupType;

public class LookupMsg
extends DKSMessage
implements ForwardedMsgInterface {
    private static String NAME = "LOOKUP";
    private long target;
    private long intervalStart;
    private LookupType type;
    private Vector stack = new Vector();
    private DKSRef source;
    private String msgId;
    private DKSObject payload = null;
    private boolean internal;

    @Override
    public String getName() {
        return NAME;
    }

    public LookupType getType() {
        return this.type;
    }

    public Vector getStack() {
        return this.stack;
    }

    public DKSRef getSource() {
        return this.source;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public DKSObject getPayload() {
        return this.payload;
    }

    public boolean getInternal() {
        return this.internal;
    }

    @Override
    public long getTarget() {
        return this.target;
    }

    @Override
    public long getIntervalStart() {
        return this.intervalStart;
    }

    @Override
    public void setIntervalStart(long s) {
        this.intervalStart = s;
    }

    public LookupMsg() {
    }

    public LookupMsg(long target, LookupType type, DKSRef source, DKSRef start, String msgId, boolean intern) {
        this.target = target;
        this.type = type;
        this.source = source;
        this.msgId = msgId;
        this.internal = intern;
        this.stack.add(0, source);
        this.stack.add(0, start);
    }

    public LookupMsg(long target, LookupType type, DKSRef source, DKSRef start, DKSObject payload, String msgId, boolean intern) {
        this.target = target;
        this.type = type;
        this.msgId = msgId;
        this.payload = payload;
        this.internal = intern;
        this.stack.add(0, source);
        this.stack.add(0, start);
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addLong(this.target, "target");
        this.marshaler.addLong(this.intervalStart, "start");
        this.marshaler.addBool(this.internal, "internal");
        this.marshaler.addString(this.type.toString(), "ltype");
        this.marshaler.addBool(this.msgId != null, "anyinsertid");
        if (this.msgId != null) {
            this.marshaler.addString(this.msgId, "insertid");
        }
        this.marshaler.addBool(this.payload != null, "anypayload");
        if (this.payload != null) {
            this.marshaler.addDKSObject(this.payload, "payload");
        }
        this.marshaler.addDKSRefArray(this.stack.toArray(new DKSRef[0]), "stack");
    }

    @Override
    public void unmarshal() throws IOException {
        boolean anyLoad;
        this.target = this.marshaler.remLong("target");
        this.intervalStart = this.marshaler.remLong("start");
        this.internal = this.marshaler.remBool("internal");
        this.type = LookupType.valueOf(this.marshaler.remString("ltype"));
        boolean anyId = this.marshaler.remBool("anyinsertid");
        if (anyId) {
            this.msgId = this.marshaler.remString("insertid");
        }
        if (anyLoad = this.marshaler.remBool("anypayload")) {
            this.payload = this.marshaler.remDKSObject("payload");
        }
        this.stack = new Vector(this.marshaler.remDKSRefArray("stack"));
    }
}

