/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.MarshalBinary;
import org.kth.dks.dks_marshal.MarshalInterface;
import org.kth.dks.dks_marshal.MarshalXML;
import org.kth.dks.dks_marshal.XMLElement;
import org.kth.dks.dks_marshal.XMLMessage;

public abstract class DKSMessage {
    private static Logger log = Logger.getLogger(DKSMessage.class);
    protected static Map messageMapUnsync = new HashMap();
    protected static Map messageMap = Collections.synchronizedMap(messageMapUnsync);
    private static final String BASEPACKAGE = "org.kth.dks.";
    private DKSRef sendRef = null;
    private DKSRef recvRef = null;
    protected MarshalInterface marshaler = new MarshalBinary(this);
    protected int pCount = 0;
    protected XMLMessage xmsg = null;
    protected XMLElement ele;
    protected int eleCnt = 0;

    public final DKSRef getSendRef() {
        return this.sendRef;
    }

    public final DKSRef getRecvRef() {
        return this.recvRef;
    }

    public final void setSendRef(DKSRef s) {
        this.sendRef = s;
    }

    public final void setRecvRef(DKSRef r) {
        this.recvRef = r;
    }

    public static DKSMessage unmarshal(byte[] raw) {
        return DKSMessage.unmarshal((byte)1, raw);
    }

    public static DKSMessage unmarshal(byte transType, byte[] raw) {
        switch (transType) {
            case 0: {
                return MarshalXML.unflatten(raw);
            }
            case 1: {
                return MarshalBinary.unflatten(raw);
            }
        }
        log.error((Object)"Could not understand tranport type in incoming message, ignoring.");
        return null;
    }

    public static synchronized void addMessageType(String msgInternalXMLTAG, String nameOfClass) {
        String className = nameOfClass;
        try {
            messageMap.put(msgInternalXMLTAG, Class.forName(className));
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)("Class not found, could not install unmarshaller for message (" + className + ")\n"));
        }
    }

    public static synchronized void addMessageTypePrefixed(String msgInternalXMLTAG, String nameOfClass) {
        String className = BASEPACKAGE + nameOfClass;
        try {
            messageMap.put(msgInternalXMLTAG, Class.forName(className));
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)("Class not found, could not install unmarshaller for message (" + className + ")\n"));
        }
    }

    public abstract String getName();

    public abstract void marshal() throws IOException;

    public abstract void unmarshal() throws IOException;

    public final byte[] flatten() {
        switch (1) {
            case 0: {
                return this.marshaler.flatten();
            }
            case 1: {
                return this.marshaler.flatten();
            }
        }
        log.error((Object)"Could not understand tranport type in incoming message, ignoring. (flatten)");
        return null;
    }
}

