/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_exceptions.DKSNodeAlreadyRegistered;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_marshal.FailureMsg;
import org.kth.dks.dks_marshal.MsgSrcDestWrapper;
import org.kth.dks.dks_marshal.ObjectAdapter;

public class DKSMarshal {
    private Logger log = Logger.getLogger(DKSMarshal.class);
    private static final String BASEPACKAGE = "org.kth.dks.";
    private boolean LOGICAL_COMM = false;
    private ConnectionManager cm = null;
    private Map objectAdapterMap = new HashMap();
    private Map objectAdapterThreadList = new HashMap();
    public static final byte TRANSTYPEXML = 0;
    public static final byte TRANSTYPEBINARY = 1;
    public static final byte TRANSDEFAULT = 1;

    public DKSMarshal(ConnectionManager cm) {
        this.cm = cm;
    }

    public boolean unmarshalDispatch(byte transType, byte[] input, DKSNetAddress source) {
        DKSMessage dksMsg = DKSMessage.unmarshal(transType, input);
        return dksMsg == null ? false : this.dispatchOA(dksMsg, dksMsg.getSendRef(), dksMsg.getRecvRef().getOverlayAddress());
    }

    public boolean dispatchOA(DKSMessage dksMsg, DKSRef source, DKSOverlayAddress dest) {
        if (!this.objectAdapterMap.containsKey(dest)) {
            this.log.error((Object)("Destination DKSOverlayAddress " + dest + " is not registered in the marshaler" + source));
            return false;
        }
        ObjectAdapter oa = (ObjectAdapter)this.objectAdapterMap.get(dest);
        return oa.putMessagePair(dksMsg, source);
    }

    public void failureHandler(MsgSrcDestWrapper triple) {
        if (!this.objectAdapterMap.containsKey(triple.getSrc().getOverlayAddress())) {
            this.log.error((Object)"Source DKSOverlayAddress is not registered in the marshaler (in failureHandler)");
        } else {
            this.log.error((Object)("DKSMarshal -- Failure detected to" + triple.getDest().getOverlayAddress()));
            ObjectAdapter oa = (ObjectAdapter)this.objectAdapterMap.get(triple.getSrc().getOverlayAddress());
            oa.putMessagePair(new FailureMsg(triple.getSrc(), triple.getDest(), triple.getMsg()), null);
        }
    }

    public void registerDKSNode(DKSOverlayAddress addr) throws DKSNodeAlreadyRegistered {
        if (this.objectAdapterMap.containsKey(addr)) {
            throw new DKSNodeAlreadyRegistered();
        }
        ObjectAdapter oa = new ObjectAdapter();
        Thread oaThread = new Thread(oa);
        oaThread.setName(ObjectAdapter.class.getName());
        oaThread.start();
        this.objectAdapterThreadList.put(oa, oaThread);
        this.objectAdapterMap.put(addr, oa);
    }

    public void unregisterDKSNode(DKSOverlayAddress addr) {
        Thread oaThr;
        ObjectAdapter oa = (ObjectAdapter)this.objectAdapterMap.remove(addr);
        if (oa != null && (oaThr = (Thread)this.objectAdapterThreadList.remove(oa)) != null) {
            oaThr.interrupt();
        }
    }

    public boolean addMsgHandlerPrefixed(DKSOverlayAddress addr, String messageClassZ, String handlerClassZ, String handlerMethodZ, Object handlerObject) {
        return this.addMsgHandler(addr, BASEPACKAGE + messageClassZ, BASEPACKAGE + handlerClassZ, handlerMethodZ, handlerObject);
    }

    public boolean addMsgHandler(DKSOverlayAddress addr, String messageClassZ, String handlerClassZ, String handlerMethodZ, Object handlerObject) {
        if (!this.objectAdapterMap.containsKey(addr)) {
            this.log.warn((Object)("Could not regisiter handler for " + handlerMethodZ + ", because no ObjectAdapter is registered yet\n"));
            return false;
        }
        ObjectAdapter oa = (ObjectAdapter)this.objectAdapterMap.get(addr);
        return oa.addMsgHandler(messageClassZ, handlerClassZ, handlerMethodZ, handlerObject);
    }

    public boolean send(DKSRef src, DKSRef dest, DKSMessage msg) {
        if (src.getIP().equals(dest.getIP()) && src.getPort() == dest.getPort() && this.LOGICAL_COMM) {
            this.log.info((Object)("send local(" + src.getID() + " to " + dest.getID() + "): " + msg.getName()));
            this.log.info((Object)("receive local(" + dest.getID() + " from " + src.getID() + "): " + msg.getName()));
            this.dispatchOA(msg, src, dest.getOverlayAddress());
            return true;
        }
        this.log.info((Object)("send remote(" + dest.getID() + " to " + src.getID() + "): " + msg.getName()));
        return this.cm.send(new MsgSrcDestWrapper(msg, src, dest));
    }

    public byte[] marshalMsgSrcDestWrapper(MsgSrcDestWrapper wr) {
        DKSMessage msg = wr.getMsg();
        DKSRef src = wr.getSrc();
        DKSRef dest = wr.getDest();
        msg.setRecvRef(dest);
        msg.setSendRef(src);
        return msg.flatten();
    }

    public void end() {
        this.objectAdapterMap.clear();
        for (Thread oaThread : this.objectAdapterThreadList.values()) {
            oaThread.interrupt();
        }
        this.objectAdapterThreadList.clear();
    }
}

