/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.CorrectionOnChangeInterface;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.Interval;

public class CorrectionOnLeaveMsg
extends DKSMessage
implements CorrectionOnChangeInterface {
    private static String NAME = "CORRECTIONONLEAVE";
    private DKSRef oldNode;
    private DKSRef newNode;
    private Interval interval;

    @Override
    public String getName() {
        return NAME;
    }

    public DKSRef getNewNode() {
        return this.newNode;
    }

    public DKSRef getOldNode() {
        return this.oldNode;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    public CorrectionOnLeaveMsg() {
    }

    public CorrectionOnLeaveMsg(DKSRef oldNode, DKSRef newNode, Interval i) {
        this.oldNode = oldNode;
        this.newNode = newNode;
        this.interval = i;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addDKSRef(this.newNode, "newnode");
        this.marshaler.addDKSRef(this.oldNode, "oldnode");
        this.marshaler.addLong(this.interval.start, "intervalstart");
        this.marshaler.addLong(this.interval.end, "intervalend");
    }

    @Override
    public void unmarshal() throws IOException {
        this.newNode = this.marshaler.remDKSRef("newnode");
        this.oldNode = this.marshaler.remDKSRef("oldnode");
        long s = this.marshaler.remLong("intervalstart");
        long e = this.marshaler.remLong("intervalend");
        this.interval = new Interval(s, e);
    }
}

