/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_marshal;

import java.io.IOException;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class BroadCastMsg
extends DKSMessage {
    private static String NAME = "BROADCAST";
    private long limit;
    private long start;
    private DKSObject payload;
    private boolean internal = false;
    private boolean leaf = false;

    @Override
    public String getName() {
        return NAME;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getStart() {
        return this.start;
    }

    public boolean getInternal() {
        return this.internal;
    }

    public DKSObject getPayload() {
        return this.payload;
    }

    public BroadCastMsg() {
    }

    public BroadCastMsg(long start, long limit, DKSObject pl) {
        this.start = start;
        this.limit = limit;
        this.payload = pl;
    }

    public BroadCastMsg(long start, long limit, DKSObject pl, boolean internal) {
        this.start = start;
        this.limit = limit;
        this.payload = pl;
        this.internal = internal;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addLong(this.limit, "limit");
        this.marshaler.addLong(this.start, "start");
        this.marshaler.addString(this.payload.toString(), "payload");
        this.marshaler.addBool(this.internal, "internal");
    }

    @Override
    public void unmarshal() throws IOException {
        this.limit = this.marshaler.remLong("limit");
        this.start = this.marshaler.remLong("start");
        this.payload = new DKSObject(this.marshaler.remString("payload"));
        this.internal = this.marshaler.remBool("internal");
    }
}

