/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_dht.StoreTriplet;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.Interval;

public class ReplicateMsg
extends DKSMessage {
    public static final String NAME = "REPLICATEMSG";
    private List tripletEntries = null;
    private List intervals = null;
    private ReplicationType replicationType;

    @Override
    public String getName() {
        return NAME;
    }

    public List getTripletList() {
        return this.tripletEntries;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public ReplicationType getReplicationType() {
        return this.replicationType;
    }

    public ReplicateMsg() {
    }

    public ReplicateMsg(List te, List in, ReplicationType type) {
        this.tripletEntries = te;
        this.replicationType = type;
        this.intervals = in;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addString(this.replicationType.toString(), "reptype");
        this.marshaler.addInt(this.tripletEntries.size(), "tripsize");
        int cnt = 1;
        for (StoreTriplet curr : this.tripletEntries) {
            this.marshaler.addLong(curr.key, "key" + cnt);
            this.marshaler.addInt(curr.index, "ind" + cnt);
            this.marshaler.addDKSObject(curr.obj, "obj" + cnt);
            ++cnt;
        }
        this.marshaler.addInt(this.intervals.size(), "intervalsize");
        cnt = 1;
        for (Interval in : this.intervals) {
            this.marshaler.addLong(in.start, "start" + cnt);
            this.marshaler.addLong(in.end, "end" + cnt);
            ++cnt;
        }
    }

    @Override
    public void unmarshal() throws IOException {
        int cnt;
        this.replicationType = ReplicationType.valueOf(this.marshaler.remString("reptype"));
        int sz = this.marshaler.remInt("tripsize");
        this.tripletEntries = new ArrayList();
        for (cnt = 1; cnt <= sz; ++cnt) {
            long k = this.marshaler.remLong("key" + cnt);
            int i = this.marshaler.remInt("ind" + cnt);
            DKSObject o = this.marshaler.remDKSObject("obj" + cnt);
            this.tripletEntries.add(new StoreTriplet(i, new Long(k), o));
        }
        sz = this.marshaler.remInt("intervalsize");
        this.intervals = new ArrayList();
        for (cnt = 1; cnt <= sz; ++cnt) {
            long start = this.marshaler.remLong("start" + cnt);
            long end = this.marshaler.remLong("end" + cnt);
            this.intervals.add(new Interval(start, end));
        }
    }

    public static class ReplicationType {
        public static final ReplicationType JOIN = new ReplicationType("JOIN");
        public static final ReplicationType LEAVE = new ReplicationType("LEAVE");
        private String name;

        public ReplicationType(String a) {
            this.name = a;
        }

        public String toString() {
            return this.name;
        }

        public static ReplicationType valueOf(String a) {
            if (a.equals(LEAVE.toString())) {
                return LEAVE;
            }
            if (a.equals(JOIN.toString())) {
                return JOIN;
            }
            return null;
        }
    }
}

