/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.kth.dks.dks_dht.FailedIntervalCallbackInterface;
import org.kth.dks.dks_node.Interval;
import org.kth.dks.dks_node.IntervalOptimizer;
import org.kth.dks.util.MathMiscConstant;

class FailedIntervalHandler
extends IntervalOptimizer
implements Runnable {
    Map intervals;
    MathMiscConstant _math;
    int f_factor;
    long timeout;
    int ctr;
    FailedIntervalCallbackInterface dht;
    Thread worker;

    public FailedIntervalHandler(FailedIntervalCallbackInterface d, MathMiscConstant math, int f, long t) {
        super(math);
        this.dht = d;
        this._math = math;
        this.intervals = new HashMap();
        this.f_factor = f - 1;
        this.timeout = t;
        this.ctr = 0;
        this.worker = new Thread(this);
        this.worker.setName(FailedIntervalHandler.class.getName());
        this.worker.start();
    }

    long now() {
        return new Date().getTime();
    }

    @Override
    public void run() {
        this.handleIntervals();
    }

    private synchronized void handleIntervals() {
        block2: while (true) {
            FailedInterval fi;
            long now = this.now();
            long waitTime = -1L;
            for (Map.Entry entry : this.intervals.entrySet()) {
                fi = (FailedInterval)entry.getValue();
                waitTime = waitTime < fi.timeout ? fi.timeout : waitTime;
            }
            try {
                if (waitTime == -1L) {
                    this.wait();
                } else {
                    this.wait(waitTime - now);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = this.now();
            Iterator entryIter = this.intervals.entrySet().iterator();
            while (true) {
                Map.Entry entry;
                if (!entryIter.hasNext()) continue block2;
                entry = entryIter.next();
                fi = (FailedInterval)entry.getValue();
                if (fi.timeout > now) continue;
                fi.incCC();
                fi.timeout = now + this.timeout;
                int id = (Integer)entry.getKey();
                this.dht.sendRestoreIntervals(fi.interval, fi.getCC(), id);
            }
            break;
        }
    }

    public synchronized void intervalFailed(Interval in) {
        int id = this.ctr++;
        FailedInterval fi = new FailedInterval(in, this.now() + this.timeout);
        this.intervals.put(new Integer(id), fi);
        this.dht.sendRestoreIntervals(fi.interval, fi.getCC(), id);
        this.notifyAll();
    }

    public synchronized int intervalRecieved(int id, Interval in, int items) {
        FailedInterval fi = (FailedInterval)this.intervals.get(new Integer(id));
        if (fi == null) {
            return -1;
        }
        fi.interval = this.removeInterval(fi.interval, in);
        fi.items += items;
        if (fi.interval.isEmpty()) {
            this.intervals.remove(new Integer(id));
            return fi.items;
        }
        return -1;
    }

    public synchronized boolean inFailedInterval(long identifier) {
        for (Map.Entry entry : this.intervals.entrySet()) {
            FailedInterval fi = (FailedInterval)entry.getValue();
            for (Interval iv : fi.interval) {
                if (!this._math.belongsTo(identifier, iv.start, iv.end)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized List intervalIntersection(Interval in) {
        List<Interval> li = new LinkedList<Interval>();
        li.add(in);
        List differance = this.intervalDifference(in);
        Iterator it = differance.iterator();
        while (it.hasNext()) {
            li = this.removeInterval(li, (Interval)it.next());
        }
        return li;
    }

    public synchronized List intervalDifference(Interval in) {
        List<Interval> ans = new LinkedList<Interval>();
        ans.add(in);
        for (Map.Entry entry : this.intervals.entrySet()) {
            FailedInterval fi = (FailedInterval)entry.getValue();
            LinkedList tmp = new LinkedList();
            for (Interval failed : fi.interval) {
                ans = this.removeInterval(ans, failed);
            }
        }
        return ans;
    }

    public synchronized void removeInterval(Interval in) {
        Iterator entryIter = this.intervals.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry entry = entryIter.next();
            FailedInterval fi = (FailedInterval)entry.getValue();
            fi.interval = this.removeInterval(fi.interval, in);
            if (!fi.interval.isEmpty()) continue;
            entryIter.remove();
        }
    }

    public synchronized boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    class FailedInterval {
        public int f = 0;
        public List interval = new LinkedList();
        public long timeout;
        public int items;

        public FailedInterval(Interval i, long t) {
            this.timeout = t;
            this.items = 0;
            this.interval.add(i);
        }

        public int getCC() {
            return this.f + 2;
        }

        public void incCC() {
            this.f = (this.f + 1) % FailedIntervalHandler.this.f_factor;
        }
    }
}

