/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.kth.dks.DKSDHTVisualizationInterface;
import org.kth.dks.DKSMCastDHTInterface;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_dht.CreateMCastGroupMsg;
import org.kth.dks.dks_dht.CreateMCastGroupReplyMsg;
import org.kth.dks.dks_dht.DKSDHTCallback;
import org.kth.dks.dks_dht.DKSDHTImpl;
import org.kth.dks.dks_dht.JoinMCastGroupMsg;
import org.kth.dks.dks_dht.MCastGroupInfoMsg;
import org.kth.dks.dks_dht.MCastGroupInfoReplyMsg;
import org.kth.dks.dks_exceptions.DKSIdentifierAlreadyTaken;
import org.kth.dks.dks_exceptions.DKSMCastNoSouchGroup;
import org.kth.dks.dks_exceptions.DKSNodeAlreadyRegistered;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_exceptions.DKSTooManyRestartJoins;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.util.AsyncOperation;

public class DKSMCastDHTImpl
implements DKSMCastDHTInterface,
DKSDHTCallback,
DKSDHTVisualizationInterface {
    private Logger log = Logger.getLogger(DKSMCastDHTImpl.class);
    DKSDHTImpl dht;
    DKSDHTCallback callbacks;
    AsyncOperation createOp = null;
    AsyncOperation infoOp = null;

    @Override
    public DKSMCastDHTInterface createGroup(long gid, DKSDHTCallback cb) throws DKSIdentifierAlreadyTaken, DKSTooManyRestartJoins {
        CreateMCastGroupReplyMsg reply;
        DKSRef ref = this.dht.myDKSImpl.getDKSRef();
        DKSOverlayAddress ov = new DKSOverlayAddress(ref.getID(), gid, ref.getGUID());
        DKSRef grpRef = DKSRef.newDKSRefByParts(ov, ref.getDKSNetAddress());
        DKSMCastDHTImpl newNode = new DKSMCastDHTImpl(this.dht.myDKSImpl.getCM(), ov, cb);
        CreateMCastGroupMsg msg = new CreateMCastGroupMsg(gid, grpRef, newNode.getDHT().myDKSImpl.getDKSRef());
        this.log.debug((Object)("createGroup(" + gid + ", " + grpRef + ") message sent"));
        this.dht.routeAsync(gid, DKSDHTImpl.message2obj(msg));
        this.createOp = AsyncOperation.start();
        this.log.debug((Object)("createGroup(" + gid + ") waiting for reply"));
        try {
            reply = (CreateMCastGroupReplyMsg)this.createOp.waitOn();
            this.createOp = null;
        }
        catch (Exception ex) {
            newNode.unregisterNode();
            throw new DKSIdentifierAlreadyTaken();
        }
        this.log.debug((Object)("createGroup(" + gid + ") got reply -> " + (reply.getStatus() ? "true" : "false")));
        if (!reply.getStatus()) {
            newNode.unregisterNode();
            throw new DKSIdentifierAlreadyTaken();
        }
        this.log.debug((Object)("createGroup(" + gid + ") new node created"));
        newNode.create();
        this.log.debug((Object)("createGroup(" + gid + ") completed successfully"));
        return newNode;
    }

    @Override
    public DKSMCastDHTInterface joinGroup(long gid, DKSDHTCallback cb) throws DKSMCastNoSouchGroup, DKSIdentifierAlreadyTaken, DKSRefNoResponse {
        DKSRef ref = this.dht.myDKSImpl.getDKSRef();
        DKSOverlayAddress ov = new DKSOverlayAddress(ref.getID(), gid, ref.getGUID());
        DKSRef grpRef = DKSRef.newDKSRefByParts(ov, ref.getDKSNetAddress());
        DKSMCastDHTImpl newNode = new DKSMCastDHTImpl(this.dht.myDKSImpl.getCM(), ov, cb);
        this.log.debug((Object)("joinGroup(" + gid + ") new node created"));
        DKSRef[] refs = null;
        try {
            refs = this.getGroupInfo(gid);
        }
        catch (DKSMCastNoSouchGroup e) {
            newNode.unregisterNode();
            throw e;
        }
        for (int i = 0; i < refs.length; ++i) {
            this.log.debug((Object)("Trying to connect to " + refs[i].toString()));
            try {
                newNode.join(refs[i]);
                this.log.debug((Object)("joinGroup(" + gid + ") new node started, returning"));
                this.dht.routeAsync(gid, DKSDHTImpl.message2obj(new JoinMCastGroupMsg(gid, newNode.getDHT().myDKSImpl.getDKSRef())));
                return newNode;
            }
            catch (DKSTooManyRestartJoins e) {
                continue;
            }
        }
        newNode.unregisterNode();
        this.log.debug((Object)("Failed to join group(" + gid + ")"));
        throw new DKSRefNoResponse(refs[0].getDKSNetAddress());
    }

    @Override
    public DKSRef[] getGroupInfo(long gid) throws DKSMCastNoSouchGroup {
        MCastGroupInfoReplyMsg reply;
        MCastGroupInfoMsg msg = new MCastGroupInfoMsg(gid, this.dht.myDKSImpl.getDKSRef());
        this.log.debug((Object)("groupinfo(" + gid + ") message sent"));
        this.dht.routeAsync(gid, DKSDHTImpl.message2obj(msg));
        this.infoOp = AsyncOperation.start();
        this.log.debug((Object)("groupinfo(" + gid + ") waiting for reply"));
        try {
            reply = (MCastGroupInfoReplyMsg)this.infoOp.waitOn();
        }
        catch (Exception ex) {
            this.infoOp = null;
            throw new DKSMCastNoSouchGroup();
        }
        this.log.debug((Object)("groupinfo(" + gid + ") got reply -> " + (reply.getRefs().length == 0 ? "no souch group" : "success")));
        if (reply.getRefs().length == 0) {
            throw new DKSMCastNoSouchGroup();
        }
        return reply.getRefs();
    }

    @Override
    public void addToBinding(long key, DKSObject value) {
        this.dht.addToBinding(key, this.addMeta(false, value));
    }

    @Override
    public void removeFromBinding(long key, DKSObject value) {
        this.dht.removeFromBinding(key, this.addMeta(false, value));
    }

    @Override
    public void changeBinding(long key, DKSObject oldValue, DKSObject newValue) {
        this.dht.changeBinding(key, this.addMeta(false, oldValue), this.addMeta(false, newValue));
    }

    @Override
    public DKSObject[] lookupBinding(long key) {
        return this.removeMeta(this.dht.lookupBinding(key));
    }

    @Override
    public DKSObject[] lookupBinding(long minKey, long maxKey) {
        return this.removeMeta(this.dht.lookupBinding(minKey, maxKey));
    }

    @Override
    public void broadcast(DKSObject message) {
        this.dht.broadcast(message);
    }

    @Override
    public void broadcastRestricted(DKSObject message, long startId, long endId) {
        this.dht.broadcastRestricted(message, startId, endId);
    }

    @Override
    public void join(DKSRef existingnodeAddress) throws DKSIdentifierAlreadyTaken, DKSTooManyRestartJoins, DKSRefNoResponse {
        this.dht.join(existingnodeAddress);
    }

    @Override
    public void create() {
        this.dht.create();
    }

    @Override
    public void logLevel(int level) {
        this.dht.logLevel(level);
    }

    @Override
    public void leave() {
        this.dht.leave();
        this.dht.unregisterNode();
    }

    @Override
    public DKSRef findResponsible(long identifier) {
        return this.dht.findResponsible(identifier);
    }

    @Override
    public DKSObject route(long identifier, DKSObject payload) {
        return this.dht.route(identifier, payload);
    }

    @Override
    public void routeAsync(long identifier, DKSObject payload) {
        this.dht.routeAsync(identifier, payload);
    }

    @Override
    public void routeAsyncFrom(long identifier, DKSObject payload, DKSRef fromNode) {
        this.dht.routeAsyncFrom(identifier, payload, fromNode);
    }

    @Override
    public String getDKSURL() {
        return this.dht.getDKSURL();
    }

    @Override
    public void unregisterNode() {
        this.dht.unregisterNode();
    }

    public DKSMCastDHTImpl(ConnectionManager cm, DKSOverlayAddress over, DKSDHTCallback cb) {
        this.log.debug((Object)("--------------- 0 " + over));
        try {
            this.dht = new DKSDHTImpl(cm, over, this);
        }
        catch (DKSNodeAlreadyRegistered e) {
            this.log.error((Object)("internal error " + e));
        }
        this.log.debug((Object)"--------------- 1");
        this.callbacks = cb;
        DKSMessage.addMessageTypePrefixed("JOINMCASTGROUPMSG", "dks_dht.JoinMCastGroupMsg");
        DKSMessage.addMessageTypePrefixed("CREATEMCASTGROUPMSG", "dks_dht.CreateMCastGroupMsg");
        DKSMessage.addMessageTypePrefixed("CREATEMCASTGROUPREPLYMSG", "dks_dht.CreateMCastGroupReplyMsg");
        DKSMessage.addMessageTypePrefixed("MCASTGROUPINFOMSG", "dks_dht.MCastGroupInfoMsg");
        DKSMessage.addMessageTypePrefixed("MCASTGROUPINFOREPLYMSG", "dks_dht.MCastGroupInfoReplyMsg");
    }

    @Override
    public void dhtBroadcastCallback(DKSObject value) {
        this.callbacks.dhtBroadcastCallback(value);
    }

    @Override
    public DKSMessage dhtRouteCallback(long identifier, DKSMessage value) {
        this.log.debug((Object)"dhtRouteCallback");
        return this.callbacks.dhtRouteCallback(identifier, value);
    }

    @Override
    public void dhtRouteCallbackAsync(long identifier, DKSMessage payload) {
        this.log.debug((Object)"dhtRouteCallbackAsync");
        if (payload instanceof CreateMCastGroupMsg) {
            this.log.debug((Object)"dhtRouteCallbackAsync: got CreateMCastGroupMsg");
            CreateMCastGroupMsg msg = (CreateMCastGroupMsg)payload;
            this.handleCreateGroup(msg);
        } else if (payload instanceof CreateMCastGroupReplyMsg) {
            this.log.debug((Object)"dhtRouteCallbackAsync: got CreateMCastGroupReplyMsg");
            this.handleCreateGroupReply((CreateMCastGroupReplyMsg)payload);
        } else if (payload instanceof JoinMCastGroupMsg) {
            this.log.debug((Object)"dhtRouteCallbackAsync: got JoinMCastGroupMsg");
            this.handleJoinGroup((JoinMCastGroupMsg)payload);
        } else if (payload instanceof MCastGroupInfoMsg) {
            this.log.debug((Object)"dhtRouteCallbackAsync: got MCastGroupInfoMsg");
            this.handleGroupInfo((MCastGroupInfoMsg)payload);
        } else if (payload instanceof MCastGroupInfoReplyMsg) {
            this.log.debug((Object)"dhtRouteCallbackAsync: got MCastGroupInfoReplyMsg");
            this.handleGroupInfoReply((MCastGroupInfoReplyMsg)payload);
        } else {
            this.callbacks.dhtRouteCallbackAsync(identifier, payload);
        }
    }

    @Override
    public DKSDHTImpl getDHT() {
        return this.dht;
    }

    DKSObject addMeta(boolean isMeta, DKSObject value) {
        byte[] in = value.getData();
        byte[] data = new byte[in.length + 1];
        data[0] = isMeta ? (byte)1 : 0;
        for (int i = 0; i < in.length; ++i) {
            data[i + 1] = in[i];
        }
        return new DKSObject(data);
    }

    boolean isMeta(DKSObject value) {
        return value.getData()[0] == 1;
    }

    DKSObject removeMeta(DKSObject value) {
        byte[] in = value.getData();
        byte[] data = new byte[in.length - 1];
        for (int i = 0; i < in.length - 1; ++i) {
            data[i] = in[i + 1];
        }
        return new DKSObject(data);
    }

    DKSObject[] removeMeta(DKSObject[] value) {
        int n = 0;
        for (int i = 0; i < value.length; ++i) {
            if (this.isMeta(value[i])) continue;
            ++n;
        }
        DKSObject[] result = new DKSObject[n];
        int j = 0;
        for (int i = 0; i < value.length; ++i) {
            if (this.isMeta(value[i])) continue;
            result[j++] = this.removeMeta(value[i]);
        }
        return result;
    }

    DKSObject[] getMeta(DKSObject[] value) {
        int n = 0;
        for (int i = 0; i < value.length; ++i) {
            if (!this.isMeta(value[i])) continue;
            ++n;
        }
        DKSObject[] result = new DKSObject[n];
        int j = 0;
        for (int i = 0; i < value.length; ++i) {
            if (!this.isMeta(value[i])) continue;
            result[j++] = this.removeMeta(value[i]);
        }
        return result;
    }

    void handleCreateGroup(CreateMCastGroupMsg msg) {
        this.log.debug((Object)("Got create group for " + msg.getGroupId() + " from " + msg.getSource() + " participant: " + msg.getGroupNode()));
        DKSObject[] nodes = this.getMeta(this.dht.lookupBinding(msg.getGroupId()));
        this.dht.routeAsync(msg.getSource().getID(), DKSDHTImpl.message2obj(new CreateMCastGroupReplyMsg(nodes.length == 0)));
        if (nodes.length != 0) {
            return;
        }
        this.dht.addToBinding(msg.getGroupId(), this.addMeta(true, new DKSObject(msg.getGroupNode().toString().getBytes())));
    }

    void handleCreateGroupReply(CreateMCastGroupReplyMsg msg) {
        if (this.createOp != null) {
            this.log.debug((Object)"dhtRouteCallbackAsync: completing future");
            this.createOp.complete(msg);
        }
    }

    void handleJoinGroup(JoinMCastGroupMsg msg) {
        DKSRef participant = msg.getGroupNode();
        this.log.debug((Object)("Got join group for " + msg.getGroupId() + " from " + participant));
        this.dht.addToBinding(msg.getGroupId(), this.addMeta(true, new DKSObject(participant.toString().getBytes())));
    }

    void handleGroupInfo(MCastGroupInfoMsg msg) {
        this.log.debug((Object)("Got group info request for " + msg.getGroupId() + " from " + msg.getSource()));
        DKSObject[] nodes = this.getMeta(this.dht.lookupBinding(msg.getGroupId()));
        DKSRef[] refs = new DKSRef[nodes.length];
        this.log.debug((Object)(nodes.length + " known nodes"));
        for (int i = 0; i < nodes.length; ++i) {
            try {
                String str = new String(nodes[i].getData());
                refs[i] = DKSRef.valueOf(str);
                this.log.debug((Object)refs[i].toString());
                continue;
            }
            catch (MalformedURLException e) {
                this.log.error((Object)"Bad meta data");
            }
        }
        MCastGroupInfoReplyMsg reply = new MCastGroupInfoReplyMsg();
        reply.addRefs(refs);
        this.dht.routeAsync(msg.getSource().getID(), DKSDHTImpl.message2obj(reply));
    }

    @Override
    public void send(DKSRef target, DKSMessage message) {
        this.dht.send(target, message);
    }

    void handleGroupInfoReply(MCastGroupInfoReplyMsg msg) {
        if (this.infoOp != null) {
            this.log.debug((Object)"dhtRouteCallbackAsync: completing future");
            this.infoOp.complete(msg);
        }
    }

    @Override
    public DKSRef getDKSRef() {
        return this.dht.getDKSRef();
    }

    @Override
    public boolean addMsgHandler(DKSMessage msg, Object handlerObject, String methodName) {
        return this.dht.addMsgHandler(msg, handlerObject, methodName);
    }

    @Override
    public boolean addMsgHandler(String messageClassZ, String handlerClassZ, String handlerMethodZ, Object handlerObject) {
        DKSOverlayAddress oa = this.dht.myDKSImpl.getDKSRef().getOverlayAddress();
        DKSMarshal m = this.dht.myDKSImpl.getDKSMarshal();
        return m.addMsgHandler(oa, messageClassZ, handlerClassZ, handlerMethodZ, handlerObject);
    }
}

