/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kth.dks.DKSAppInterface;
import org.kth.dks.DKSCallbackInterface;
import org.kth.dks.DKSDHTInterface;
import org.kth.dks.DKSDHTVisualizationInterface;
import org.kth.dks.DKSImpl;
import org.kth.dks.DKSObject;
import org.kth.dks.DKSObjectTypes;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_dht.AddItemMsg;
import org.kth.dks.dks_dht.ChangeItemMsg;
import org.kth.dks.dks_dht.DHTDiskStorage;
import org.kth.dks.dks_dht.DHTMemoryStorage;
import org.kth.dks.dks_dht.DHTRestoreItemsMsg;
import org.kth.dks.dks_dht.DHTRestoreReplicasMsg;
import org.kth.dks.dks_dht.DHTResultMsg;
import org.kth.dks.dks_dht.DHTStatistics;
import org.kth.dks.dks_dht.DHTStatisticsItem;
import org.kth.dks.dks_dht.DHTStorage;
import org.kth.dks.dks_dht.DKSDHTCallback;
import org.kth.dks.dks_dht.FailedIntervalCallbackInterface;
import org.kth.dks.dks_dht.FailedIntervalHandler;
import org.kth.dks.dks_dht.GetItemsMsg;
import org.kth.dks.dks_dht.RemoveFromBindingMsg;
import org.kth.dks.dks_dht.RemoveItemMsg;
import org.kth.dks.dks_dht.ReplicateMsg;
import org.kth.dks.dks_dht.ReplicationFinishedMsg;
import org.kth.dks.dks_dht.RetrieveItemsMsg;
import org.kth.dks.dks_dht.StoreTriplet;
import org.kth.dks.dks_exceptions.DKSIdentifierAlreadyTaken;
import org.kth.dks.dks_exceptions.DKSNodeAlreadyRegistered;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_exceptions.DKSTooManyRestartJoins;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.DKSNode;
import org.kth.dks.dks_node.Interval;
import org.kth.dks.util.AsyncOperation;
import org.kth.dks.util.MathMisc;
import org.kth.dks.util.MathMiscConstant;
import org.kth.dks.util.TimeoutException;

public class DKSDHTImpl
implements DKSDHTInterface,
DKSAppInterface,
DKSDHTVisualizationInterface,
FailedIntervalCallbackInterface {
    private Logger log = Logger.getLogger(DKSDHTInterface.class);
    DKSCallbackInterface dksCallbacks = null;
    DHTStorage[] store = null;
    private static final long LOOKUPTIMEOUT = 5000L;
    private static final long INSERTTIMEOUT = 5000L;
    private static final long RESTOREITEMSTIMEOUT = 10000L;
    private static final int DHTSUCCESS = 0;
    private static final int DHTFAILURE = 0;
    private static final int DHTNOSUCHITEM = 0;
    private static final int LOOKUPRETRYFACTOR = 2;
    private static final int DHTSTATUSJOINING = 1;
    private static final int DHTSTATUSOPERATIONAL = 2;
    private static final int DHTSTATUSRESTORING = 3;
    private static final int DHTSTATUSLEAVING = 4;
    public DKSImpl myDKSImpl = null;
    private long myId;
    private int f_factor = 4;
    private int lookup_factor = 4;
    boolean insertSeen = false;
    boolean lookupSeen = false;
    private int status = 1;
    FailedIntervalHandler failedInterval = null;
    MathMiscConstant math = null;
    private DKSDHTCallback dhtCallback = null;

    public DKSDHTImpl(ConnectionManager cm, long nodeId, URL nodeAddress) throws DKSNodeAlreadyRegistered {
        this.store = new DHTMemoryStorage[this.f_factor];
        for (int i = 0; i < this.f_factor; ++i) {
            this.store[i] = new DHTMemoryStorage();
        }
        this.myDKSImpl = new DKSImpl(cm, nodeId, nodeAddress);
        this.myDKSImpl.setCallbackHandler(this);
        this.dksCallbacks = this.myDKSImpl.setCallbackHandler(this);
        this.setDKSCallbacks(this.dksCallbacks);
        this.myId = nodeId;
        this.math = new MathMiscConstant(DKSNode.N, 2L);
        this.failedInterval = new FailedIntervalHandler(this, this.math, this.f_factor, 10000L);
        this.installHandlers();
    }

    public static DKSDHTImpl createDKSDiskDHT(ConnectionManager cm, DKSOverlayAddress over) throws DKSNodeAlreadyRegistered {
        return new DKSDHTImpl(cm, over, DHTDiskStorage.class);
    }

    public DKSDHTImpl(ConnectionManager cm, DKSOverlayAddress over) throws DKSNodeAlreadyRegistered {
        this(cm, over, DHTMemoryStorage.class);
    }

    public DKSDHTImpl(ConnectionManager cm, DKSOverlayAddress over, Class ldht) throws DKSNodeAlreadyRegistered {
        this.store = new DHTStorage[this.f_factor];
        try {
            for (int i = 0; i < this.f_factor; ++i) {
                this.store[i] = (DHTStorage)ldht.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new InstantiationError();
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError();
        }
        this.myDKSImpl = new DKSImpl(cm, over);
        this.myDKSImpl.setCallbackHandler(this);
        this.dksCallbacks = this.myDKSImpl.setCallbackHandler(this);
        this.setDKSCallbacks(this.dksCallbacks);
        this.myId = over.getID();
        this.math = new MathMiscConstant(DKSNode.N, 2L);
        this.failedInterval = new FailedIntervalHandler(this, this.math, this.f_factor, 10000L);
        this.installHandlers();
    }

    public DKSDHTImpl(ConnectionManager cm, DKSOverlayAddress over, DKSDHTCallback cb) throws DKSNodeAlreadyRegistered {
        this.store = new DHTMemoryStorage[this.f_factor];
        for (int i = 0; i < this.f_factor; ++i) {
            this.store[i] = new DHTMemoryStorage();
        }
        this.dhtCallback = cb;
        this.myDKSImpl = new DKSImpl(cm, over);
        this.myDKSImpl.setCallbackHandler(this);
        this.dksCallbacks = this.myDKSImpl.setCallbackHandler(this);
        this.setDKSCallbacks(this.dksCallbacks);
        this.myId = over.getID();
        this.math = new MathMiscConstant(DKSNode.N, 2L);
        this.failedInterval = new FailedIntervalHandler(this, this.math, this.f_factor, 10000L);
        this.installHandlers();
    }

    private void installHandlers() {
        DKSOverlayAddress oa = this.myDKSImpl.getDKSRef().getOverlayAddress();
        DKSMessage.addMessageTypePrefixed("ADDITEMMSG", "dks_dht.AddItemMsg");
        DKSMessage.addMessageTypePrefixed("REMOVEITEMMSG", "dks_dht.RemoveItemMsg");
        DKSMessage.addMessageTypePrefixed("CHANGEITEMMSG", "dks_dht.ChangeItemMsg");
        DKSMessage.addMessageTypePrefixed("GETITEMSMSG", "dks_dht.GetItemsMsg");
        DKSMessage.addMessageTypePrefixed(DHTRestoreReplicasMsg.NAME, "dks_dht.DHTRestoreReplicasMsg");
        DKSMessage.addMessageTypePrefixed("DHTRESULTMSG", "dks_dht.DHTResultMsg");
        DKSMessage.addMessageTypePrefixed("RETRIEVEITEMS", "dks_dht.RetrieveItemsMsg");
        this.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(oa, "dks_dht.RetrieveItemsMsg", "dks_dht.DKSDHTImpl", "retrieveItemsH", this);
        DKSMessage.addMessageTypePrefixed("REPLICATEMSG", "dks_dht.ReplicateMsg");
        this.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(oa, "dks_dht.ReplicateMsg", "dks_dht.DKSDHTImpl", "replicateH", this);
        DKSMessage.addMessageTypePrefixed("REPLICATIONFINISHEDMSG", "dks_dht.ReplicationFinishedMsg");
        this.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(oa, "dks_dht.ReplicationFinishedMsg", "dks_dht.DKSDHTImpl", "replicationFinishedH", this);
        DKSMessage.addMessageTypePrefixed("LOSTITEMSMSG", "dks_dht.DHTRestoreItemsMsg");
        this.myDKSImpl.getDKSMarshal().addMsgHandlerPrefixed(oa, "dks_dht.DHTRestoreItemsMsg", "dks_dht.DKSDHTImpl", "RestoreItemsH", this);
    }

    @Override
    public void create() {
        this.status = 2;
        this.myDKSImpl.create();
    }

    public void join(long existingnodeId, URL existingnodeAddress) throws DKSTooManyRestartJoins, DKSIdentifierAlreadyTaken {
        this.myDKSImpl.join(existingnodeId, existingnodeAddress);
    }

    @Override
    public void join(DKSRef existingnodeAddress) throws DKSTooManyRestartJoins, DKSIdentifierAlreadyTaken, DKSRefNoResponse {
        this.myDKSImpl.join(existingnodeAddress);
    }

    @Override
    public void logLevel(int level) {
        this.myDKSImpl.logLevel(level);
    }

    @Override
    public void leave() {
        this.myDKSImpl.leave();
    }

    @Override
    public void addToBinding(long key, DKSObject value) {
        int r;
        key %= DKSNode.N;
        AsyncOperation[] ops = new AsyncOperation[this.f_factor];
        for (r = 0; r < this.f_factor; ++r) {
            long replicaKey = this.associatedIdentifier(key, r + 1);
            DKSObject dhtAddObj = new DKSObject(new AddItemMsg(key, r + 1, value).flatten());
            ops[r] = this.myDKSImpl.getMyDKSNode().route(replicaKey, dhtAddObj);
        }
        for (r = 1; r <= this.f_factor; ++r) {
            try {
                ops[r - 1].waitOn(5000L);
                continue;
            }
            catch (Exception ex) {
                this.log.error((Object)"route: AsyncOperation was interrupted or cancelled");
            }
        }
    }

    public AsyncOperation[] addToBindingAsync(long key, DKSObject value) {
        key %= DKSNode.N;
        AsyncOperation[] ops = new AsyncOperation[this.f_factor];
        for (int r = 1; r <= this.f_factor; ++r) {
            long replicaKey = this.associatedIdentifier(key, r);
            DKSObject dhtAddObj = new DKSObject(new AddItemMsg(key, r, value).flatten());
            ops[r - 1] = this.myDKSImpl.getMyDKSNode().route(replicaKey, dhtAddObj);
        }
        return ops;
    }

    @Override
    public DKSObject route(long identifier, DKSObject payload) {
        return this.myDKSImpl.route(identifier %= DKSNode.N, payload);
    }

    @Override
    public void routeAsync(long identifier, DKSObject payload) {
        this.myDKSImpl.routeAsync(identifier %= DKSNode.N, payload);
    }

    @Override
    public void routeAsyncFrom(long identifier, DKSObject payload, DKSRef fromNode) {
        this.myDKSImpl.routeAsyncFrom(identifier %= DKSNode.N, payload, fromNode);
    }

    @Override
    public void removeFromBinding(long key, DKSObject value) {
        int r;
        key %= DKSNode.N;
        AsyncOperation[] ops = new AsyncOperation[this.f_factor];
        for (r = 1; r <= this.f_factor; ++r) {
            long replicaKey = this.associatedIdentifier(key, r);
            DKSObject dhtRemoveObj = new DKSObject(new RemoveItemMsg(replicaKey, r, value).flatten());
            ops[r - 1] = this.myDKSImpl.getMyDKSNode().route(key, dhtRemoveObj);
        }
        for (r = 1; r <= this.f_factor; ++r) {
            try {
                ops[r - 1].waitOn();
                continue;
            }
            catch (Exception ex) {
                this.log.error((Object)"route: AsyncOperation was interrupted or cancelled");
            }
        }
    }

    @Override
    public void changeBinding(long key, DKSObject oldValue, DKSObject newValue) {
        int r;
        key %= DKSNode.N;
        AsyncOperation[] ops = new AsyncOperation[this.f_factor];
        for (r = 1; r <= this.f_factor; ++r) {
            long replicaKey = this.associatedIdentifier(key, r);
            DKSObject dhtChangeObj = new DKSObject(new ChangeItemMsg(replicaKey, r, oldValue, newValue).flatten());
            ops[r - 1] = this.myDKSImpl.getMyDKSNode().route(replicaKey, dhtChangeObj);
        }
        for (r = 1; r <= this.f_factor; ++r) {
            try {
                ops[r - 1].waitOn();
                continue;
            }
            catch (Exception ex) {
                this.log.error((Object)"route: AsyncOperation was interrupted or cancelled");
            }
        }
    }

    @Override
    public DKSObject[] lookupBinding(long key) {
        key %= DKSNode.N;
        for (int r = 1; r <= this.lookup_factor; ++r) {
            long replicaKey = this.associatedIdentifier(key, r);
            for (int iter = 2; iter > 0; --iter) {
                DKSObject obj = new DKSObject(new GetItemsMsg(key).flatten());
                AsyncOperation ops = this.myDKSImpl.getMyDKSNode().route(replicaKey, obj);
                try {
                    DKSObject res = (DKSObject)ops.waitOn(5000L);
                    DHTResultMsg rmsg = (DHTResultMsg)DKSMessage.unmarshal(res.getData());
                    if (rmsg.getResult() == 0 && rmsg.getPayload().length > 0) {
                        return rmsg.getPayload();
                    }
                    iter = 0;
                    continue;
                }
                catch (TimeoutException ex) {
                    this.log.error((Object)"lookupBinding timed out after 5000 msec");
                    continue;
                }
                catch (Exception ex) {
                    this.log.error((Object)("route: AsyncOperation was interrupted or cancelled\n" + ex));
                }
            }
        }
        return new DKSObject[0];
    }

    @Override
    public DKSObject[] lookupBinding(long minKey, long maxKey) {
        minKey %= DKSNode.N;
        maxKey %= DKSNode.N;
        return null;
    }

    public void send(DKSObject message, long recipientNodeId) {
        this.log.error((Object)"This version of send is not implemented!");
    }

    public void send(DKSObject message, DKSRef rec) {
    }

    @Override
    public void broadcast(DKSObject message) {
        this.myDKSImpl.broadcast(message);
    }

    @Override
    public void broadcastRestricted(DKSObject message, long startId, long endId) {
        this.myDKSImpl.broadcastRestricted(message, startId, endId);
    }

    public DKSMarshal getDKSMarshal() {
        return this.myDKSImpl.getDKSMarshal();
    }

    public void setDKSCallbacks(DKSCallbackInterface dksImpl) {
        this.dksCallbacks = dksImpl;
    }

    public static DKSObject message2obj(DKSMessage m) {
        byte[] arr = m.flatten();
        DKSObject newObj = new DKSObject(arr);
        return newObj;
    }

    @Override
    public void routeCallbackAsync(long identifier, DKSObject payload) {
        if (payload == null) {
            this.log.error((Object)"Error, payload null inside routeCallbackAsync in DHT!");
        }
        DKSMessage dksMsg = DKSMessage.unmarshal(payload.getData());
        if (this.dhtCallback != null) {
            this.dhtCallback.dhtRouteCallbackAsync(identifier, dksMsg);
        }
    }

    @Override
    public DKSObject routeCallback(long identifier, DKSObject payload) {
        if (payload == null) {
            this.log.error((Object)"Error, payload null inside routeCallback in DHT!");
        }
        DKSMessage dksMsg = DKSMessage.unmarshal(payload.getData());
        if (this.status == 4) {
            return DKSDHTImpl.message2obj(new DHTResultMsg(12L, 0));
        }
        if (dksMsg instanceof AddItemMsg) {
            AddItemMsg msg = (AddItemMsg)dksMsg;
            if (msg.index - 1 == 0) {
                this.insertSeen = true;
            }
            this.store[msg.index - 1].insertItem(msg.key, msg.payload);
            return DKSDHTImpl.message2obj(new DHTResultMsg(msg.key, 0));
        }
        if (dksMsg instanceof RemoveItemMsg) {
            RemoveItemMsg msg = (RemoveItemMsg)dksMsg;
            this.store[msg.index - 1].removeItem(msg.key, msg.payload);
            return DKSDHTImpl.message2obj(new DHTResultMsg(msg.key, 0));
        }
        if (dksMsg instanceof ChangeItemMsg) {
            ChangeItemMsg msg = (ChangeItemMsg)dksMsg;
            this.store[msg.index - 1].changeItem(msg.key, msg.oldPayload, msg.newPayload);
            return DKSDHTImpl.message2obj(new DHTResultMsg(msg.key, 0));
        }
        if (dksMsg instanceof RemoveFromBindingMsg) {
            RemoveFromBindingMsg msg = (RemoveFromBindingMsg)dksMsg;
            this.store[0].removeItem(identifier, msg.getPayload());
            DHTResultMsg res = new DHTResultMsg(msg.getMsgId(), 0);
            return DKSDHTImpl.message2obj(res);
        }
        if (dksMsg instanceof GetItemsMsg) {
            GetItemsMsg msg = (GetItemsMsg)dksMsg;
            for (int r = 1; r <= this.f_factor; ++r) {
                DKSObject[] res = this.store[r - 1].lookupItem(msg.getKey());
                if (r == 1) {
                    this.lookupSeen = true;
                }
                if (res.length <= 0) continue;
                return DKSDHTImpl.message2obj(new DHTResultMsg(msg.key, 0, res));
            }
            return DKSDHTImpl.message2obj(new DHTResultMsg(msg.key, 0, new DKSObject[0]));
        }
        DKSMessage result = null;
        if (this.dhtCallback != null) {
            result = this.dhtCallback.dhtRouteCallback(identifier, dksMsg);
        }
        if (result == null) {
            result = new DHTResultMsg(12L, 0);
            this.log.error((Object)("Message of type " + dksMsg.getName() + " not handled"));
        }
        return DKSDHTImpl.message2obj(result);
    }

    @Override
    public void failCallback(DKSRef failed, DKSRef failedPred) {
        if (this.f_factor <= 1) {
            return;
        }
        this.status = 3;
        this.printGraphRecv("F" + failed, "FAILURE DETECTED");
        Interval i = new Interval(failedPred.getID(), failed.getID());
        this.log.warn((Object)("FAILURE   --- restore interval " + i));
        this.failedInterval.intervalFailed(i);
    }

    public void retrieveItemsH(DKSRef sender, RetrieveItemsMsg msg) {
        this.log.debug((Object)("JOIN: RetrieveItems from: " + sender + " predecessor: " + this.myDKSImpl.getNodeInfo().predecessor));
        this.printGraphRecv("JN" + sender, "RETRIEVE");
        Interval in = new Interval(msg.getStart(), msg.getEnd());
        List validIntervals = this.failedInterval.intervalDifference(in);
        LinkedList entries = new LinkedList();
        for (Interval ii : validIntervals) {
            entries.addAll(this.getItemsInInterval(ii.start, ii.end, true));
        }
        List lostIntervals = this.failedInterval.intervalIntersection(in);
        this.log.debug((Object)("RetrieveItemsH: items: " + entries.size() + " validIntervals " + validIntervals + " lostIntervals " + lostIntervals));
        this.failedInterval.removeInterval(in);
        if (this.status == 3 && this.failedInterval.isEmpty()) {
            this.status = 2;
            this.log.error((Object)"FAILURE: now operational, passed failed interval to joining node");
        }
        this.printGraphSend("ITMS" + sender + "_" + this.myDKSImpl.getDKSRef(), "ITEMS(" + entries.size() + ")");
        this.myDKSImpl.send(sender, new ReplicateMsg(entries, lostIntervals, ReplicateMsg.ReplicationType.JOIN));
    }

    public void replicateH(DKSRef sender, ReplicateMsg msg) {
        this.printGraphRecv("ITMS" + this.myDKSImpl.getDKSRef() + "_" + sender, "ITEMS(" + msg.getTripletList().size() + ")");
        for (StoreTriplet st : msg.getTripletList()) {
            this.store[st.index - 1].insertItem(st.key, st.obj);
        }
        Iterator initer = msg.getIntervals().iterator();
        while (initer.hasNext()) {
            this.failedInterval.intervalFailed((Interval)initer.next());
        }
        if (msg.getReplicationType() == ReplicateMsg.ReplicationType.JOIN) {
            this.log.debug((Object)("JOIN: done, items: " + msg.getTripletList().size() + (this.failedInterval.isEmpty() ? " OPERATIONAL " : " RESTORING INTERVAL ")));
            this.dksCallbacks.joinCallbackReturn();
        } else if (msg.getReplicationType() == ReplicateMsg.ReplicationType.LEAVE) {
            this.log.debug((Object)("Predecessor left, items: " + msg.getTripletList().size() + (this.failedInterval.isEmpty() ? " OPERATIONAL " : " RESTORING INTERVAL ")));
            this.myDKSImpl.send(sender, new ReplicationFinishedMsg());
        }
        this.status = this.failedInterval.isEmpty() ? 2 : 3;
    }

    public void replicationFinishedH(DKSRef sender, ReplicationFinishedMsg rfmsg) {
        this.dksCallbacks.leaveCallbackReturn();
    }

    public void RestoreItemsH(DKSRef sender, DHTRestoreItemsMsg msg) {
        long N = this.myDKSImpl.addressSpace();
        int cc = msg.getCC();
        int id = msg.getId();
        this.printGraphRecv("IS" + this.myDKSImpl.getDKSRef() + "_" + sender + "_" + id + "_" + cc, "RESTORE(" + msg.getTripletList() + ")");
        this.log.debug((Object)("RestoreItems id: " + id + " Intervals: " + msg.getIntervals() + " items " + msg.getTripletList().size()));
        int shift = (this.f_factor - (cc - 1)) % this.f_factor + 1;
        for (Interval interval : msg.getIntervals()) {
            Interval complete = this.associatedInterval(interval, shift);
            this.failedInterval.intervalRecieved(id, complete, msg.getTripletList().size());
        }
        for (StoreTriplet st : msg.getTripletList()) {
            int indx1 = (this.f_factor + (st.index - 1 - (cc - 1))) % this.f_factor;
            if (!this.checkInsert(st.key, indx1 + 1)) continue;
            this.store[indx1].insertItem(st.key, st.obj);
        }
        if (this.failedInterval.isEmpty()) {
            this.log.debug((Object)"FAILURE --, received all items, now operational");
            this.status = 2;
        }
    }

    public void restoreReplicas(DHTRestoreReplicasMsg repMsg) {
        Interval intervalRec = repMsg.getInterval();
        Interval i = this.math.intervalIntersection(this.getResponsability(), intervalRec);
        if (i == null) {
            return;
        }
        if (this.status == 4 || this.status == 1) {
            return;
        }
        List inter = this.failedInterval.intervalDifference(i);
        if (inter.size() == 0) {
            return;
        }
        LinkedList entries = new LinkedList();
        for (Interval intr : inter) {
            List items = this.getItemsInInterval(intr.start, intr.end, false);
            entries.addAll(items);
        }
        this.printGraphRecv("RST" + repMsg.getNewNode() + "_" + repMsg.getId() + "_" + repMsg.getCC(), "RESTORE");
        this.log.debug((Object)("Restore match: " + i + " := " + inter + " entries: " + entries.size()));
        this.printGraphSend("IS" + repMsg.getNewNode() + "_" + this.myDKSImpl.getDKSRef() + "_" + repMsg.getId() + "_" + repMsg.getCC(), "RESTORE(" + entries.size() + ")");
        this.myDKSImpl.send(repMsg.getNewNode(), new DHTRestoreItemsMsg(repMsg.getCC(), repMsg.getId(), entries, inter));
    }

    @Override
    public void broadcastCallback(DKSObject payload) {
        if (payload.getType() == DKSObjectTypes.DKSMSG) {
            DKSMessage dksMsg = DKSMessage.unmarshal(payload.getData());
            if (dksMsg instanceof DHTRestoreReplicasMsg) {
                this.restoreReplicas((DHTRestoreReplicasMsg)dksMsg);
            }
        } else if (this.dhtCallback != null) {
            this.dhtCallback.dhtBroadcastCallback(payload);
        } else {
            this.log.error((Object)"Application level broadcast received -- no callback handler installed");
        }
    }

    @Override
    public void joinCallback(DKSRef pred, DKSRef succ) {
        this.log.debug((Object)("JOIN: asking " + succ));
        this.printGraphSend("JN" + this.myDKSImpl.getDKSRef(), "JOIN");
        RetrieveItemsMsg smsg = new RetrieveItemsMsg(pred.getID(), this.myDKSImpl.getDKSRef().getID());
        this.myDKSImpl.send(succ, smsg);
    }

    @Override
    public void leaveCallback(DKSRef pred, DKSRef succ) {
        this.status = 4;
        List entries = this.getItemsInInterval(pred.getID(), this.myDKSImpl.getDKSRef().getID(), true);
        Interval in = new Interval(pred.getID(), this.myDKSImpl.getDKSRef().getID());
        List lostIntervals = this.failedInterval.intervalIntersection(in);
        this.failedInterval.removeInterval(in);
        this.printGraphSend("ITMS" + succ + "_" + this.myDKSImpl.getDKSRef(), "LEAVE(" + entries.size() + ")");
        this.myDKSImpl.send(succ, new ReplicateMsg(entries, lostIntervals, ReplicateMsg.ReplicationType.LEAVE));
    }

    private long associatedIdentifier(long i, int x) {
        long N = this.myDKSImpl.addressSpace();
        return MathMisc.modPlus(i, (long)(x - 1) * (N / (long)this.f_factor), N);
    }

    private Interval associatedInterval(Interval i, int x) {
        return new Interval(this.associatedIdentifier(i.start, x), this.associatedIdentifier(i.end, x));
    }

    private List getItemsInInterval(long start, long end, boolean remove) {
        LinkedList<StoreTriplet> entries = new LinkedList<StoreTriplet>();
        for (int r = 1; r <= this.f_factor; ++r) {
            Iterator keyIter = this.store[r - 1].getEntriesIterator();
            while (keyIter.hasNext()) {
                Map.Entry entry = (Map.Entry)keyIter.next();
                Long key = (Long)entry.getKey();
                long id = this.associatedIdentifier(key, r);
                if (!MathMisc.belongsTo(id, start, end, DKSNode.N)) continue;
                for (DKSObject oo : (Set)entry.getValue()) {
                    entries.add(new StoreTriplet(r, key, oo));
                }
                if (!remove) continue;
                keyIter.remove();
            }
        }
        return entries;
    }

    public DHTStatistics getStatistics() {
        int numItems = 0;
        int sizeItems = 0;
        int numReplicationItems = 0;
        int sizeReplicationItems = 0;
        DHTStatisticsItem data = new DHTStatisticsItem(this.insertSeen, this.lookupSeen);
        this.insertSeen = false;
        this.lookupSeen = false;
        for (int r = 0; r < this.f_factor; ++r) {
            Iterator keyIter = this.store[r].getEntriesIterator();
            while (keyIter.hasNext()) {
                Map.Entry entry = (Map.Entry)keyIter.next();
                if (r == 0) {
                    ++numItems;
                } else {
                    ++numReplicationItems;
                }
                data.newEntry((Long)entry.getKey(), r, null);
                for (DKSObject oo : (Set)entry.getValue()) {
                    if (r == 0) {
                        sizeItems += oo.getData().length;
                        continue;
                    }
                    sizeReplicationItems += oo.getData().length;
                }
            }
        }
        return new DHTStatistics(numItems, sizeItems, numReplicationItems, sizeReplicationItems, data);
    }

    @Override
    public String getDKSURL() {
        return this.myDKSImpl.getDKSURL();
    }

    public long getMyId() {
        return this.myId;
    }

    public long getPredecessorId() {
        return this.myDKSImpl.getNodeInfo().predecessor.getID();
    }

    public long getKeyRange() {
        return DKSNode.N;
    }

    @Override
    public DKSRef findResponsible(long id) {
        return this.myDKSImpl.findResponsible(id %= DKSNode.N);
    }

    @Override
    public void unregisterNode() {
        this.myDKSImpl.unregisterNode();
    }

    @Override
    public DKSDHTImpl getDHT() {
        return this;
    }

    public DHTStorage[] getStorage() {
        return this.store;
    }

    @Override
    public void sendRestoreIntervals(List intervals, int cc, int id) {
        this.printGraphSend("RST" + this.myDKSImpl.getDKSRef() + "_" + id + "_" + cc, "RESTORE");
        for (Interval iv : intervals) {
            Interval i = this.associatedInterval(iv, cc);
            this.log.debug((Object)("Broadcasting request for " + iv + " id: " + id + " cc: " + cc + " in " + i));
            DHTRestoreReplicasMsg restMsg = new DHTRestoreReplicasMsg(this.myDKSImpl.getDKSRef(), i, cc, id);
            DKSObject obj = new DKSObject(DKSObjectTypes.DKSMSG, restMsg.flatten());
            this.broadcast(obj);
        }
    }

    private Interval getResponsability() {
        long predecessor = this.getPredecessorId();
        return new Interval(predecessor, this.myId);
    }

    private boolean checkInsert(long key, int indx) {
        long id = this.associatedIdentifier(key, indx);
        Interval rsp = this.getResponsability();
        return this.math.belongsTo(id, rsp.start, rsp.end);
    }

    public void printGraphSend(String id, String cnt) {
    }

    public void printGraphRecv(String id, String cnt) {
    }

    @Override
    public void send(DKSRef target, DKSMessage message) {
        this.myDKSImpl.send(target, message);
    }

    public int getReplicationDegree() {
        return this.f_factor;
    }

    public int getMultipleLookupCount() {
        return this.lookup_factor;
    }

    public void setReplicationDegree(int k) {
        this.f_factor = k;
    }

    public void setMultipleLookupCount(int k) {
        this.lookup_factor = k;
    }

    @Override
    public boolean addMsgHandler(DKSMessage msg, Object handlerObject, String methodName) {
        return this.myDKSImpl.addMsgHandler(msg, handlerObject, methodName);
    }

    @Override
    public DKSRef getDKSRef() {
        return this.myDKSImpl.getDKSRef();
    }
}

