/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class DHTStateTransferMsg
extends DKSMessage {
    private final Logger log = Logger.getLogger(DHTStateTransferMsg.class);
    public static final String NAME = "DHTSTATETRANSFERMSG";
    private DKSObject[] payload = new DKSObject[0];
    private long key;
    private int StateTransfer;
    public static final int LASTMSG = 0;
    public static final int DATATRANSFER = 1;
    public static final int LASTMSGRECEIVED = 2;
    public static final int STATEREQUEST = 3;
    private int type;

    @Override
    public String getName() {
        return NAME;
    }

    public DKSObject[] getPayload() {
        return this.payload;
    }

    public long getKey() {
        return this.key;
    }

    public long getType() {
        return this.type;
    }

    public DHTStateTransferMsg() {
    }

    public DHTStateTransferMsg(long k, DKSObject[] pld) {
        this.key = k;
        this.payload = pld;
        this.type = 1;
    }

    public DHTStateTransferMsg(long k, int t) {
        this.key = k;
        this.type = t;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addLong(this.key, "key");
        this.marshaler.addInt(this.type, "type");
        this.marshaler.addInt(this.payload.length, "arrlen");
        for (int i = 0; i < this.payload.length; ++i) {
            this.marshaler.addDKSObject(this.payload[i], "payload" + (i + 1));
        }
    }

    @Override
    public void unmarshal() throws IOException {
        this.key = this.marshaler.remLong("key");
        this.type = this.marshaler.remInt("type");
        int len = this.marshaler.remInt("arrlen");
        this.payload = new DKSObject[len];
        for (int i = 0; i < len; ++i) {
            this.payload[i] = this.marshaler.remDKSObject("payload" + (i + 1));
        }
        this.log.debug((Object)"in DHTSendstateunmarshal.");
        this.log.debug((Object)("Unmarshalling a " + this.type + " message."));
    }
}

