/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import org.kth.dks.DKSImpl;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_dht.DHTStateTransferMsg;
import org.kth.dks.dks_dht.DHTStorage;
import org.kth.dks.dks_node.DKSNode;
import org.kth.dks.util.MathMisc;

class DHTSendStateHandler
extends Thread {
    DKSImpl myDKS = null;
    long start;
    long stop;
    DKSRef target;
    boolean cont = true;
    DHTStorage store;

    public DHTSendStateHandler(DKSImpl dks, long strt, long stp, DKSRef trgt, DHTStorage s, boolean leave) {
        this.myDKS = dks;
        this.start = strt;
        this.stop = stp;
        this.store = s;
        this.target = trgt;
        this.setName(DHTSendStateHandler.class.getName());
    }

    @Override
    public void run() {
        try {
            long[] items = this.store.getAllKeys();
            for (int i = 0; i < items.length; ++i) {
                if (!MathMisc.belongsTo(items[i], this.start, this.stop, DKSNode.N)) continue;
                DKSObject[] objs = this.store.lookupItem(items[i]);
                for (int j = 0; j < objs.length; ++j) {
                    this.store.removeItem(items[i], objs[j]);
                }
                DHTStateTransferMsg msg = new DHTStateTransferMsg(items[i], objs);
                this.myDKS.send(this.target, msg);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DHTStateTransferMsg msg = new DHTStateTransferMsg(this.stop, 0);
        this.myDKS.send(this.target, msg);
    }

    public void finish() {
        this.cont = false;
    }
}

