/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.io.IOException;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_marshal.DKSMessage;

public class DHTResultMsg
extends DKSMessage {
    public static final String NAME = "DHTRESULTMSG";
    private DKSObject[] payload = new DKSObject[0];
    private long msgId;
    private int result;

    @Override
    public String getName() {
        return NAME;
    }

    public DKSObject[] getPayload() {
        return this.payload;
    }

    public long getMsgId() {
        return this.msgId;
    }

    public int getResult() {
        return this.result;
    }

    public DHTResultMsg() {
    }

    public DHTResultMsg(long id, int r, DKSObject[] pld) {
        this.result = r;
        this.msgId = id;
        this.payload = pld;
    }

    public DHTResultMsg(long id, int r) {
        this.result = r;
        this.msgId = id;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addLong(this.msgId, "id");
        this.marshaler.addInt(this.result, "index");
        this.marshaler.addInt(this.payload.length, "arrlen");
        for (int i = 0; i < this.payload.length; ++i) {
            this.marshaler.addDKSObject(this.payload[i], "payload" + (i + 1));
        }
    }

    @Override
    public void unmarshal() throws IOException {
        this.msgId = this.marshaler.remLong("id");
        this.result = this.marshaler.remInt("index");
        int len = this.marshaler.remInt("arrlen");
        this.payload = new DKSObject[len];
        for (int i = 0; i < len; ++i) {
            this.payload[i] = this.marshaler.remDKSObject("payload" + (i + 1));
        }
    }
}

