/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.io.IOException;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_marshal.CorrectionOnChangeInterface;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.Interval;

public class DHTRestoreReplicasMsg
extends DKSMessage
implements CorrectionOnChangeInterface {
    public static String NAME = "DHTRESTOREREPLICASMSG";
    private DKSRef newNode;
    private Interval interval;
    private int cc;
    private int id;

    @Override
    public String getName() {
        return NAME;
    }

    public int getCC() {
        return this.cc;
    }

    public int getId() {
        return this.id;
    }

    public DKSRef getNewNode() {
        return this.newNode;
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    public DHTRestoreReplicasMsg() {
    }

    public DHTRestoreReplicasMsg(DKSRef newNode, Interval i, int c, int id) {
        this.newNode = newNode;
        this.interval = i;
        this.cc = c;
        this.id = id;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addLong(this.interval.start, "intervalstart");
        this.marshaler.addLong(this.interval.end, "intervalend");
        this.marshaler.addInt(this.cc, "cc");
        this.marshaler.addInt(this.id, "id");
        this.marshaler.addDKSRef(this.newNode, "newnode");
    }

    @Override
    public void unmarshal() throws IOException {
        long s = this.marshaler.remLong("intervalstart");
        long e = this.marshaler.remLong("intervalend");
        this.interval = new Interval(s, e);
        this.cc = this.marshaler.remInt("cc");
        this.id = this.marshaler.remInt("id");
        this.newNode = this.marshaler.remDKSRef("newnode");
    }
}

