/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_dht.StoreTriplet;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.Interval;

public class DHTRestoreItemsMsg
extends DKSMessage {
    public static final String NAME = "LOSTITEMSMSG";
    private List tripletEntries = null;
    private List intervals = null;
    private int cc = -10;
    private int id;

    @Override
    public String getName() {
        return NAME;
    }

    public List getTripletList() {
        return this.tripletEntries;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public int getCC() {
        return this.cc;
    }

    public int getId() {
        return this.id;
    }

    public DHTRestoreItemsMsg() {
    }

    public DHTRestoreItemsMsg(int c, int id, List te, List in) {
        this.tripletEntries = te;
        this.intervals = in;
        this.cc = c;
        this.id = id;
    }

    @Override
    public void marshal() throws IOException {
        this.marshaler.addInt(this.cc, "cc");
        this.marshaler.addInt(this.id, "id");
        this.marshaler.addInt(this.tripletEntries.size(), "tripsize");
        int cnt = 1;
        for (StoreTriplet curr : this.tripletEntries) {
            this.marshaler.addLong(curr.key, "key" + cnt);
            this.marshaler.addInt(curr.index, "index" + cnt);
            this.marshaler.addDKSObject(curr.obj, "obj" + cnt);
            ++cnt;
        }
        this.marshaler.addInt(this.intervals.size(), "intervalsize");
        cnt = 1;
        for (Interval in : this.intervals) {
            this.marshaler.addLong(in.start, "start" + cnt);
            this.marshaler.addLong(in.end, "end" + cnt);
            ++cnt;
        }
    }

    @Override
    public void unmarshal() throws IOException {
        this.cc = this.marshaler.remInt("cc");
        this.id = this.marshaler.remInt("id");
        int tripSize = this.marshaler.remInt("tripsize");
        int cnt = 1;
        this.tripletEntries = new ArrayList();
        for (cnt = 1; cnt <= tripSize; ++cnt) {
            long k = this.marshaler.remLong("key" + cnt);
            int i = this.marshaler.remInt("index" + cnt);
            DKSObject o = this.marshaler.remDKSObject("obj" + cnt);
            this.tripletEntries.add(new StoreTriplet(i, new Long(k), o));
        }
        int sz = this.marshaler.remInt("intervalsize");
        this.intervals = new ArrayList();
        for (int cnt0 = 1; cnt0 <= sz; ++cnt0) {
            long start = this.marshaler.remLong("start" + cnt0);
            long end = this.marshaler.remLong("end" + cnt0);
            this.intervals.add(new Interval(start, end));
        }
    }
}

