/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_dht.DHTStorage;
import org.kth.dks.dks_dht.StoreTriplet;

public class DHTMemoryStorage
implements DHTStorage {
    private Logger log = Logger.getLogger(DHTMemoryStorage.class);
    protected Map localHT = new HashMap();

    @Override
    public synchronized void insertItem(long key, DKSObject value) {
        Long Key = new Long(key);
        if (this.localHT.get(Key) == null) {
            this.localHT.put(Key, new HashSet());
        }
        Set values = (Set)this.localHT.get(Key);
        values.add(value);
    }

    @Override
    public synchronized DKSObject[] lookupItem(long key) {
        Long Key = new Long(key);
        Set values = (Set)this.localHT.get(Key);
        if (values == null || values.isEmpty()) {
            return new DKSObject[0];
        }
        try {
            DKSObject[] dksObjArr = values.toArray(new DKSObject[0]);
            return dksObjArr;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            this.log.error((Object)("Caught exception: " + e.toString()));
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    @Override
    public synchronized void removeItem(long key, DKSObject value) {
        Long Key = new Long(key);
        Set values = (Set)this.localHT.get(Key);
        if (values == null) {
            return;
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            DKSObject dksobj = (DKSObject)iter.next();
            if (!Arrays.equals(value.getData(), dksobj.getData())) continue;
            iter.remove();
        }
        if (values.isEmpty()) {
            this.localHT.remove(Key);
        }
    }

    @Override
    public synchronized void changeItem(long key, DKSObject oldvalue, DKSObject newvalue) {
        Long Key = new Long(key);
        Set values = (Set)this.localHT.get(Key);
        for (DKSObject dksobj : values) {
            if (!Arrays.equals(oldvalue.getData(), dksobj.getData())) continue;
            values.remove(dksobj);
            values.add(newvalue);
        }
    }

    @Override
    public synchronized long[] getAllKeys() {
        Set s = this.localHT.keySet();
        Long[] v = new Long[]{};
        v = s.toArray(v);
        long[] v2 = new long[v.length];
        for (int i = 0; i < v.length; ++i) {
            v2[i] = v[i];
        }
        return v2;
    }

    @Override
    public synchronized List getAllItems(int r) {
        LinkedList<StoreTriplet> entries = new LinkedList<StoreTriplet>();
        for (Map.Entry entry : this.localHT.entrySet()) {
            Long key = (Long)entry.getKey();
            for (DKSObject oo : (Set)entry.getValue()) {
                entries.add(new StoreTriplet(r, key, oo));
            }
        }
        return entries;
    }

    @Override
    public synchronized Iterator getEntriesIterator() {
        return this.localHT.entrySet().iterator();
    }
}

