/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_dht;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_dht.DHTStorage;

public class DHTDiskStorage
implements DHTStorage {
    private Logger log = Logger.getLogger(DHTDiskStorage.class);
    File basedir;
    String basedirname;

    public DHTDiskStorage(String bd) {
        this.setBaseDir(bd);
    }

    void setBaseDir(String cd) {
        this.basedirname = cd;
        this.basedir = new File(cd);
        if (!this.basedir.exists() || !this.basedir.isDirectory()) {
            this.log.error((Object)(this.basedir + " is not a directory."));
            throw new NullPointerException();
        }
    }

    @Override
    public void insertItem(long key, DKSObject value) {
        String dirname = this.basedir + "/" + key;
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        }
        String[] filenames = dir.list();
        int count = filenames.length;
        String fn = dirname + "/" + count;
        File f = new File(fn);
        boolean cont = true;
        while (cont) {
            try {
                if (!f.exists()) {
                    cont = false;
                    f.createNewFile();
                    continue;
                }
                this.log.error((Object)"File existed");
                cont = true;
                cont = true;
                fn = dirname + "/" + ++count;
                f = new File(fn);
            }
            catch (IOException e) {
                this.log.error((Object)"Caught io-exception!");
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(value.getData());
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"No such file!");
        }
        catch (IOException e) {
            this.log.error((Object)"IO Exception!");
        }
    }

    @Override
    public DKSObject[] lookupItem(long key) {
        String dirname = this.basedir + "/" + key;
        File dir = new File(dirname);
        if (!dir.exists()) {
            this.log.error((Object)("No such item." + dirname));
            return null;
        }
        String[] filenames = dir.list();
        int count = 0;
        DKSObject[] result = new DKSObject[filenames.length];
        while (count < filenames.length) {
            try {
                File f = new File(dirname + "/" + filenames[count]);
                if (!f.exists()) {
                    this.log.error((Object)("Fix me!" + filenames[count]));
                    System.exit(-1);
                } else {
                    FileInputStream fis = new FileInputStream(f);
                    byte[] data = new byte[fis.available()];
                    fis.read(data);
                    result[count] = new DKSObject(data);
                    fis.close();
                }
                ++count;
            }
            catch (IOException e) {
                this.log.error((Object)("Caught io-exception!\n" + e));
            }
        }
        return result;
    }

    @Override
    public long[] getAllKeys() {
        File dir = new File(this.basedirname);
        if (!dir.exists()) {
            this.log.error((Object)("No basedir!" + this.basedirname));
            System.exit(-1);
        }
        String[] filenames = dir.list();
        int count = 0;
        int pos = 0;
        long[] result = new long[filenames.length];
        while (count < filenames.length) {
            try {
                ++count;
                result[pos] = Long.parseLong(filenames[pos]);
                ++pos;
            }
            catch (Exception e) {
                this.log.error((Object)"Some kind of exception");
            }
        }
        return result;
    }

    @Override
    public void removeItem(long key, DKSObject value) {
        String dirname = this.basedir + "/" + key;
        File dir = new File(dirname);
        if (!dir.exists()) {
            this.log.error((Object)("No such item." + dirname));
            return;
        }
        String[] filenames = dir.list();
        int count = 0;
        while (count < filenames.length) {
            try {
                File f = new File(dirname + "/" + filenames[count]);
                if (!f.exists()) {
                    this.log.error((Object)("Fix me!" + filenames[count]));
                    System.exit(-1);
                } else {
                    FileInputStream fis = new FileInputStream(f);
                    byte[] data = new byte[fis.available()];
                    fis.read(data);
                    String s1 = new String(data);
                    String s2 = new String(value.getData());
                    if (s1.equals(s2)) {
                        this.log.error((Object)"Removing data!");
                        f.delete();
                        if (filenames.length == 1) {
                            dir.delete();
                        }
                    }
                    fis.close();
                }
                ++count;
            }
            catch (IOException e) {
                this.log.error((Object)("Caught io-exception!\n" + e));
            }
        }
    }

    @Override
    public void changeItem(long key, DKSObject oldvalue, DKSObject newvalue) {
    }

    @Override
    public Iterator getEntriesIterator() {
        return null;
    }

    @Override
    public List getAllItems(int r) {
        return null;
    }
}

