/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_comm.ThreadPool;
import org.kth.dks.dks_node.DKSNode;
import org.kth.dks.util.CommunicationInfo;
import org.kth.dks.util.NodeInfo;

public class WebServer
implements Runnable {
    private final ServerSocket serverSocket;
    private boolean finish = false;
    private ConnectionManager cm;
    private String hostname;
    private String ip;
    private String port;
    private ThreadPool threadPool;

    public WebServer(ConnectionManager c, int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.cm = c;
        this.threadPool = ThreadPool.getInstance();
    }

    @Override
    public void run() {
        while (!this.getFinish()) {
            try {
                Socket socket = null;
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                this.threadPool.addJob(new WebInstance(socket));
            }
            catch (SocketTimeoutException ste) {
                ste.printStackTrace();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
    }

    public synchronized boolean getFinish() {
        return this.finish;
    }

    public synchronized void stop() {
        this.finish = true;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public class WebInstance
    implements Runnable {
        private Socket mySock;
        private PrintWriter out = null;

        public WebInstance(Socket mySock) {
            this.mySock = mySock;
        }

        public void closeSock() {
            try {
                this.mySock.close();
            }
            catch (IOException io) {
                io.printStackTrace();
            }
        }

        public String htmlUrl(DKSRef r) {
            return "<a href=\"" + r.getDKSWebURL() + "/info.html\">[Node " + r.getID() + "]</a>";
        }

        public void printError(String errMsg) throws IOException {
            this.out.write("HTTP/1.0 200 OK\n");
            this.out.write("Content-type: text/html\n\n");
            this.out.flush();
            this.out.write("<html><head><link href=\"http://dks.sics.se/bt2_main.css\" rel=\"stylesheet\" type=\"text/css\"></head><body>");
            this.out.write("<h2><b>Error: </b>" + errMsg + "</h2>\n");
            this.out.write("</body></html>");
            this.out.flush();
        }

        public void printInfo(DKSNode node) throws IOException {
            int x;
            this.out.write("HTTP/1.0 200 OK\n");
            this.out.write("Content-type: text/html\n\n");
            this.out.flush();
            this.out.write("<html><head><link href=\"http://dks.sics.se/bt2_main.css\" rel=\"stylesheet\" type=\"text/css\"></head><body>");
            this.out.write("<h1>DKSNode: " + this.htmlUrl(node.getDKSRef()) + "</h1>");
            this.out.write("<table cellspacing=10 cellpadding=10><tr><th>Routing Info</th><th>Statistics</th><th>System Info</th></tr>");
            this.out.write("<tr><td>");
            NodeInfo ni = node.getNodeInfo();
            CommunicationInfo ci = node.getComInfo();
            this.out.write("<b>Node Status</b>: " + ni.status.toString() + "<br>");
            this.out.write("<b>Successor</b>:   " + this.htmlUrl(ni.successor) + "<br>");
            this.out.write("<b>Predecessor</b>: " + this.htmlUrl(ni.predecessor));
            this.out.write("<br><b>Backlist</b>: ");
            for (x = 0; x < ni.backList.length - 1; ++x) {
                this.out.write(this.htmlUrl(ni.backList[x]) + ",");
            }
            if (ni.backList.length > 0) {
                this.out.write(this.htmlUrl(ni.backList[ni.backList.length - 1]));
            }
            this.out.write("<br><b>Frontlist</b>: ");
            for (x = 0; x < ni.frontList.length - 1; ++x) {
                this.out.write(this.htmlUrl(ni.frontList[x]) + ",");
            }
            if (ni.frontList.length > 0) {
                this.out.write(this.htmlUrl(ni.frontList[ni.frontList.length - 1]));
            }
            this.out.write("<br><b>Routing Table (unique entries)</b>:<br>");
            DKSRef tmp = null;
            for (int l = ni.levels; l >= 1; --l) {
                for (int i = 1; !(i >= ni.kFactor || tmp != null && tmp.equals(ni.routingTable[l - 1][i].responsible)); ++i) {
                    tmp = ni.routingTable[l - 1][i].responsible;
                    this.out.write("lev:" + l + " int:" + i + " [" + ni.routingTable[l - 1][i].begin + ", " + ni.routingTable[l - 1][i].end + "): " + this.htmlUrl(ni.routingTable[l - 1][i].responsible) + "<br>");
                }
            }
            this.out.write("</td><td>");
            this.out.write("<b>Byte out</b>: " + ci.bytesSent + "<br>");
            this.out.write("<b>Byte in</b>: " + ci.bytesReceived + "<br>");
            this.out.write("<b>Delivered</b>: " + ci.msgsDelivered + "<br>");
            this.out.write("<b>Failed</b>: " + ci.msgsFailed + "<br>");
            this.out.write("<b>Received</b>: " + ci.msgsReceived + "<br>");
            this.out.write("<b>Unacked</b>: " + ci.msgsUnacked + "<br>");
            this.out.write("<b>Open conns</b>: " + ci.establishedConnections + "<br>");
            this.out.write("<b>Total conns</b>: " + ci.totalConnections + "<br>");
            this.out.write("</td><td>");
            this.out.write("<b>OS</b>: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")<br>");
            this.out.write("<b>JVM</b>: " + System.getProperty("java.vm.name") + "<br>");
            this.out.write("<b>JVM Version</b>: " + System.getProperty("java.vm.version") + "<br>");
            this.out.write("<b>Hostname</b>: " + WebServer.this.hostname + "<br>");
            this.out.write("<b>IP Address</b>: " + WebServer.this.ip + "<br>");
            this.out.write("<b>Port</b>: " + WebServer.this.port + "<br>");
            this.out.write("<b>N</b>: " + DKSNode.N + "<br>");
            this.out.write("<b>K</b>: " + DKSNode.K + "<br>");
            this.out.write("<b>L</b>: " + DKSNode.L + "<br>");
            this.out.write("<b>F</b>: " + DKSNode.F + "<br>");
            this.out.write("</td></tr>");
            this.out.write("</table></body></html>");
        }

        public void cmdCgi(String rest) throws IOException {
            HashMap<String, String> cgiArgs = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(rest, "/& ");
            if (!st.hasMoreTokens()) {
                this.printError("CGI parse error: " + rest);
                throw new IllegalArgumentException();
            }
            while (st.hasMoreElements()) {
                String tok = st.nextToken();
                StringTokenizer eq = new StringTokenizer(tok, "=&");
                if (!eq.hasMoreTokens()) {
                    this.printError("CGI parse error: " + tok);
                    throw new IllegalArgumentException();
                }
                String key = eq.nextToken();
                if (!eq.hasMoreTokens()) break;
                String value = eq.nextToken();
                cgiArgs.put(key.toUpperCase(), value);
            }
        }

        public void cmdInfo(String rest) throws IOException {
            DKSNode node;
            StringTokenizer st = new StringTokenizer(rest, " /\n\r");
            long ring = -1L;
            long id = -1L;
            long guid = -1L;
            if (st.hasMoreTokens()) {
                ring = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                id = Long.parseLong(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                guid = Long.parseLong(st.nextToken());
            }
            if ((node = (DKSNode)((WebServer)WebServer.this).cm.nodes.get(new DKSOverlayAddress(id, ring, guid))) != null) {
                this.printInfo(node);
            } else {
                this.printError("DKSNode with identifier " + id + " does not exist");
            }
        }

        @Override
        public void run() {
            try {
                String req;
                this.out = new PrintWriter(this.mySock.getOutputStream());
                InputStreamReader ir = new InputStreamReader(this.mySock.getInputStream());
                BufferedReader in = new BufferedReader(ir);
                String rest = req = in.readLine();
                while (req != null && !rest.equals("") && rest != null) {
                    rest = in.readLine();
                }
                StringTokenizer st = new StringTokenizer(req, " /?\n\r");
                if (!st.hasMoreTokens()) {
                    this.printError("HTTP parse error: " + req);
                    throw new IllegalArgumentException();
                }
                String httpCmd = st.nextToken();
                if (httpCmd.equalsIgnoreCase("GET")) {
                    if (!st.hasMoreTokens()) {
                        this.printError("HTTP parse error: " + req);
                        throw new IllegalArgumentException();
                    }
                    String dksCmd = st.nextToken();
                    if (!st.hasMoreTokens()) {
                        this.printError("HTTP parse error: " + req);
                        throw new IllegalArgumentException();
                    }
                    String dksArgs = st.nextToken("\n");
                    if (dksCmd.equalsIgnoreCase("info")) {
                        this.cmdInfo(dksArgs);
                    } else if (dksCmd.equalsIgnoreCase("cgi")) {
                        this.cmdCgi(dksArgs);
                    } else {
                        this.printError("Unsupported DKS command: " + dksCmd);
                    }
                } else {
                    this.printError("Unsupported HTTP command " + httpCmd);
                }
                this.out.flush();
                this.mySock.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.closeSock();
            }
        }
    }
}

