/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ThreadPool {
    private Logger log = Logger.getLogger(ThreadPool.class);
    private static final int POOLSIZE_DEFAULT = 5;
    private int poolSize;
    private ThreadWorker[] workers;
    private LinkedList jobs = new LinkedList();
    private static final int MAXJOBS = 100000;
    private static ThreadPool instance = null;

    private ThreadPool() {
        this(5);
    }

    private ThreadPool(int poolSize) {
        this.poolSize = poolSize;
        this.workers = new ThreadWorker[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.workers[i] = new ThreadWorker(i);
            this.workers[i].start();
        }
    }

    public static ThreadPool getInstance() {
        if (instance == null) {
            instance = new ThreadPool();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Runnable job) {
        LinkedList linkedList = this.jobs;
        synchronized (linkedList) {
            while (this.jobs.size() == 100000) {
                try {
                    this.log.error((Object)"Hit upper limit of number of jobs in thread pool (100000)");
                    this.jobs.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            this.jobs.addLast(job);
            if (this.jobs.size() == 1) {
                this.jobs.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable remJob() {
        Runnable job;
        LinkedList linkedList = this.jobs;
        synchronized (linkedList) {
            while (this.jobs.isEmpty()) {
                try {
                    this.jobs.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            job = (Runnable)this.jobs.removeFirst();
            if (this.jobs.size() == 99999) {
                this.jobs.notify();
            }
        }
        return job;
    }

    public void end() {
        for (int x = 0; x < this.poolSize; ++x) {
            this.workers[x].finish(true);
        }
    }

    private class ThreadWorker
    extends Thread {
        private boolean finish = false;

        public ThreadWorker(int i) {
            this.setName("WorkerThread-" + i);
        }

        @Override
        public void run() {
            while (!this.finish()) {
                try {
                    Runnable job = ThreadPool.this.remJob();
                    job.run();
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                }
            }
        }

        public synchronized boolean finish() {
            return this.finish;
        }

        public synchronized void finish(boolean finish) {
            this.finish = finish;
        }
    }
}

