/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.ConnHandlerIn;
import org.kth.dks.dks_comm.ConnHandlerInNB;
import org.kth.dks.dks_comm.ConnHandlerOutNB;
import org.kth.dks.dks_comm.ConnectionHandler;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.Listener;
import org.kth.dks.dks_comm.ThreadPool;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.MsgSrcDestWrapper;
import org.kth.dks.util.AsyncOperation;
import org.kth.dks.util.AtomicBoolean;
import org.kth.dks.util.Pair;
import org.kth.dks.util.Triple;

class ListenerNB
extends Thread
implements Listener {
    private static Logger log = Logger.getLogger(ListenerNB.class);
    private static final int BACKLOG = 20;
    private int port = 0;
    private boolean finish = false;
    private Vector connList = new Vector();
    private ConnectionManager a_conMan;
    private ConnectionHandler connHandler;
    private final ServerSocket serverSocket;
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private SelectionKey myKey;
    private Map socketMap = Collections.synchronizedMap(new HashMap());
    private Map anonNodes = Collections.synchronizedMap(new HashMap());
    private List connectList = Collections.synchronizedList(new LinkedList());
    private AtomicBoolean checkTimeouts = new AtomicBoolean();
    ThreadPool threadPool = null;
    private final Timer rttTimer;
    private int statisticsBytesReceived = 0;
    private int statisticsMsgsReceived = 0;
    public DKSMarshal dksMarshal = null;

    public ListenerNB(int _port, ConnectionManager cm, DKSMarshal dksm, ConnectionHandler ch) throws IOException {
        this(_port, cm, dksm, ch, null);
    }

    public ListenerNB(int _port, ConnectionManager cm, DKSMarshal dksm, ConnectionHandler ch, InetAddress bindAddr) throws IOException {
        this.port = _port;
        this.dksMarshal = dksm;
        this.a_conMan = cm;
        this.connHandler = ch;
        this.serverChannel = ServerSocketChannel.open();
        this.serverSocket = this.serverChannel.socket();
        if (bindAddr != null) {
            this.serverSocket.bind(new InetSocketAddress(bindAddr, _port), 20);
        } else {
            this.serverSocket.bind(new InetSocketAddress(_port), 20);
        }
        this.serverChannel.configureBlocking(false);
        this.selector = Selector.open();
        this.myKey = this.serverChannel.register(this.selector, 16);
        this.serverSocket.setSoTimeout(1000);
        this.setName(ListenerNB.class.getName());
        this.threadPool = ThreadPool.getInstance();
        TimerTask timeoutDetector = new TimerTask(){

            @Override
            public void run() {
                ListenerNB.this.checkTimeouts.set(true);
                ListenerNB.this.selector.wakeup();
            }
        };
        this.rttTimer = new Timer(ListenerNB.class.getName() + ".RTTTimer");
        this.rttTimer.schedule(timeoutDetector, 0L, 8000L);
        this.start();
    }

    @Override
    public void end() {
        this.finish = true;
        this.threadPool.end();
        this.rttTimer.cancel();
    }

    public Pair createHandlers(SocketChannel newSock) {
        ConnHandlerOutNB cOut = new ConnHandlerOutNB(this, newSock, this.a_conMan.getDKSMarshal(), this.connHandler);
        ConnHandlerInNB cIn = new ConnHandlerInNB(this, newSock, cOut, this.a_conMan.getDKSMarshal(), this.connHandler);
        Pair connPair = new Pair(cIn, cOut);
        this.connHandler.statAddOpenConnection(1);
        this.connHandler.statAddTotalConnection(1);
        return connPair;
    }

    public void prepareTimeoutEvents() {
        for (Map.Entry entry : this.socketMap.entrySet()) {
            Pair pair = (Pair)entry.getValue();
            final ConnHandlerOutNB cout = (ConnHandlerOutNB)pair.second();
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    cout.checkTimeouts();
                }
            };
            this.threadPool.addJob(task);
        }
    }

    public synchronized void identifiedNode(ConnHandlerInNB connId, DKSNetAddress na) {
        Pair pair = (Pair)this.anonNodes.remove(connId);
        if (pair == null) {
            System.err.println("Identification of node failed: " + na);
            return;
        }
        ((ConnHandlerInNB)pair.first()).setRemoteAddress(na);
        ((ConnHandlerOutNB)pair.second()).setRemoteAddress(na);
        this.socketMap.put(na, pair);
    }

    public synchronized void connectionClosed(SelectionKey key, int status, DKSNetAddress remAddr) {
        key.cancel();
        if (remAddr != null) {
            log.error((Object)("Removing dead connection (status:" + status + "), DKSNetAddress established"));
            this.socketMap.remove(remAddr);
        } else {
            log.error((Object)("Removing dead connection (status:" + status + "), , DKSNetAddress not established"));
            Pair pair = (Pair)key.attachment();
            ConnHandlerInNB cin = (ConnHandlerInNB)pair.first();
            if (cin != null) {
                this.anonNodes.remove(cin);
            }
        }
        this.connHandler.statAddOpenConnection(-1);
    }

    public void checkTimeouts() {
    }

    @Override
    public void run() {
        while (!this.finish) {
            try {
                this.registerNewConnections();
                int num = this.selector.select();
                log.debug((Object)("Selector returned:" + num));
                if (this.checkTimeouts.compareAndSet(true, false)) {
                    this.prepareTimeoutEvents();
                }
                if (num == 0) continue;
                Set<SelectionKey> selKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = selKeys.iterator();
                while (it.hasNext()) {
                    Pair connPair;
                    SelectionKey currKey = it.next();
                    if (currKey.isValid() && currKey.isAcceptable()) {
                        SocketChannel newSock = ((ServerSocketChannel)currKey.channel()).accept();
                        log.debug((Object)("Accepted from:" + newSock.socket().getRemoteSocketAddress()));
                        newSock.configureBlocking(false);
                        Pair pair = this.createHandlers(newSock);
                        this.anonNodes.put(pair.first(), pair);
                        SelectionKey key = newSock.register(this.selector, 5, pair);
                        ((ConnHandlerInNB)pair.first()).setKey(key);
                        ((ConnHandlerOutNB)pair.second()).setKey(key);
                    }
                    if (currKey.isValid() && currKey.isConnectable()) {
                        SocketChannel sock = (SocketChannel)currKey.channel();
                        boolean doneConnect = false;
                        try {
                            doneConnect = sock.finishConnect();
                        }
                        catch (IOException ex) {
                            log.warn((Object)("IOException thrown when connecting to " + sock.socket() + "\n" + ex));
                        }
                        Triple triple = (Triple)currKey.attachment();
                        AsyncOperation syn = (AsyncOperation)triple.third();
                        if (doneConnect) {
                            Pair pair = new Pair(triple.first(), triple.second());
                            currKey.attach(pair);
                            currKey.interestOps(5);
                            log.debug((Object)"Properly connected to endpoint");
                            ((ConnHandlerInNB)triple.first()).setKey(currKey);
                            ((ConnHandlerOutNB)triple.second()).setKey(currKey);
                            ((ConnHandlerOutNB)triple.second()).connected();
                            syn.complete(Boolean.TRUE);
                        } else {
                            currKey.cancel();
                            syn.complete(Boolean.FALSE);
                        }
                    }
                    if (currKey.isValid() && currKey.isWritable()) {
                        connPair = (Pair)currKey.attachment();
                        ConnHandlerOutNB cOut = (ConnHandlerOutNB)connPair.second();
                        currKey.interestOps(currKey.interestOps() & 0xFFFFFFFB);
                        this.threadPool.addJob(cOut);
                    }
                    if (currKey.isValid() && currKey.isReadable()) {
                        connPair = (Pair)currKey.attachment();
                        ConnHandlerInNB cIn = (ConnHandlerInNB)connPair.first();
                        currKey.interestOps(currKey.interestOps() & 0xFFFFFFFE);
                        this.threadPool.addJob(cIn);
                    }
                    it.remove();
                }
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        while (!this.connList.isEmpty()) {
            ConnHandlerIn h = (ConnHandlerIn)this.connList.elementAt(0);
            h.end();
            this.connList.removeElementAt(0);
        }
        this.end();
    }

    private void registerNewConnections() {
        while (!this.connectList.isEmpty()) {
            Triple destSockSyn = (Triple)this.connectList.remove(0);
            DKSNetAddress dest = (DKSNetAddress)destSockSyn.first();
            SocketChannel sock = (SocketChannel)destSockSyn.second();
            AsyncOperation syn = (AsyncOperation)destSockSyn.third();
            Pair pair = this.createHandlers(sock);
            ((ConnHandlerInNB)pair.first()).setRemoteAddress(dest);
            ((ConnHandlerOutNB)pair.second()).setRemoteAddress(dest);
            Triple triple = new Triple(pair.first(), pair.second(), syn);
            this.socketMap.put(dest, pair);
            ConnHandlerOutNB cOut = (ConnHandlerOutNB)pair.second();
            try {
                SelectionKey key = sock.register(this.selector, 8, triple);
                log.debug((Object)"everything ok here");
            }
            catch (ClosedChannelException ex) {
                ex.printStackTrace();
                syn.complete(Boolean.FALSE);
            }
        }
    }

    public boolean createConnection(DKSNetAddress dest) {
        SocketChannel sock = ConnHandlerOutNB.createConnection(dest);
        if (sock == null) {
            return false;
        }
        AsyncOperation sync = AsyncOperation.start();
        Triple destSockSync = new Triple(dest, sock, sync);
        this.connectList.add(destSockSync);
        this.selector.wakeup();
        try {
            Boolean b = (Boolean)sync.waitOn();
            return b;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean send(MsgSrcDestWrapper triple) {
        DKSNetAddress src = triple.getSrc().getDKSNetAddress();
        DKSNetAddress dest = triple.getDest().getDKSNetAddress();
        if (!this.socketMap.containsKey(dest)) {
            log.debug((Object)"we have to create the connection first");
            if (!this.createConnection(dest)) {
                return false;
            }
            log.debug((Object)"connection created");
        }
        Pair p = (Pair)this.socketMap.get(dest);
        ConnHandlerOutNB o = (ConnHandlerOutNB)p.second();
        o.sendMessage(src, triple);
        log.debug((Object)"message enqueued sent");
        return true;
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public String getHostAddress() {
        byte[] ip = this.serverSocket.getInetAddress().getAddress();
        if (ip[0] == 0 && ip[1] == 0 && ip[2] == 0 && ip[3] == 0) {
            String currIp = null;
            try {
                Enumeration<NetworkInterface> cards = NetworkInterface.getNetworkInterfaces();
                while (cards.hasMoreElements()) {
                    NetworkInterface currNet = cards.nextElement();
                    Enumeration<InetAddress> ads = currNet.getInetAddresses();
                    while (ads.hasMoreElements()) {
                        InetAddress adr = ads.nextElement();
                        String c = adr.getHostAddress();
                        if (!(adr instanceof Inet4Address) || c.equals("127.0.0.1") || c.startsWith("169.") || c.startsWith("10.") || c.startsWith("192.")) continue;
                        currIp = c;
                    }
                }
                if (currIp == null) {
                    InetAddress ia = InetAddress.getLocalHost();
                    currIp = ia.getHostAddress();
                }
                return currIp;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            return this.serverSocket.getInetAddress().getHostAddress();
        }
        return null;
    }
}

