/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Vector;
import org.kth.dks.dks_comm.ConnHandlerIn;
import org.kth.dks.dks_comm.ConnectionHandler;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.Listener;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.MsgSrcDestWrapper;

class ListenerBlocking
extends Thread
implements Listener {
    private static final int BACKLOG = 20;
    private int port = 0;
    private boolean finish = false;
    private Vector connList = new Vector();
    private ConnectionManager a_conMan;
    private final ServerSocket serverSocket;
    private final ConnectionHandler connHandler;
    private int statisticsBytesReceived = 0;
    private int statisticsMsgsReceived = 0;
    public DKSMarshal dksMarshal = null;

    public ListenerBlocking(int _port, ConnectionManager cm, DKSMarshal dksm, ConnectionHandler ch) throws IOException {
        this.port = _port;
        this.connHandler = ch;
        this.dksMarshal = dksm;
        this.a_conMan = cm;
        this.serverSocket = new ServerSocket(this.port);
        this.serverSocket.setSoTimeout(1000);
        this.setName(ListenerBlocking.class.getName());
        this.start();
    }

    public ListenerBlocking(int _port, ConnectionManager cm, DKSMarshal dksm, ConnectionHandler ch, InetAddress bindAddr) throws IOException {
        this.port = _port;
        this.connHandler = ch;
        this.dksMarshal = dksm;
        this.a_conMan = cm;
        this.serverSocket = new ServerSocket(this.port, 20, bindAddr);
        this.serverSocket.setSoTimeout(1000);
        this.setName(ListenerBlocking.class.getName());
        this.start();
    }

    @Override
    public void end() {
        this.finish = true;
    }

    @Override
    public void run() {
        while (!this.finish) {
            try {
                Socket socket = null;
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                InetSocketAddress sa = (InetSocketAddress)socket.getRemoteSocketAddress();
                DKSNetAddress na = new DKSNetAddress(sa.getAddress().getHostAddress(), sa.getPort());
                this.connHandler.createConnection(socket, na);
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
        while (!this.connList.isEmpty()) {
            ConnHandlerIn h = (ConnHandlerIn)this.connList.elementAt(0);
            h.end();
            this.connList.removeElementAt(0);
        }
    }

    public boolean send(MsgSrcDestWrapper triple) {
        return this.connHandler.send(triple);
    }

    @Override
    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    @Override
    public String getHostAddress() {
        byte[] ip = this.serverSocket.getInetAddress().getAddress();
        if (ip[0] == 0 && ip[1] == 0 && ip[2] == 0 && ip[3] == 0) {
            String currIp = null;
            try {
                Enumeration<NetworkInterface> cards = NetworkInterface.getNetworkInterfaces();
                while (cards.hasMoreElements()) {
                    NetworkInterface currNet = cards.nextElement();
                    Enumeration<InetAddress> ads = currNet.getInetAddresses();
                    while (ads.hasMoreElements()) {
                        InetAddress adr = ads.nextElement();
                        String c = adr.getHostAddress();
                        if (!(adr instanceof Inet4Address) || c.equals("127.0.0.1") || c.startsWith("169.") || c.startsWith("10.") || c.startsWith("192.")) continue;
                        currIp = c;
                    }
                }
                if (currIp == null) {
                    InetAddress ia = InetAddress.getLocalHost();
                    currIp = ia.getHostAddress();
                }
                return currIp;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            return this.serverSocket.getInetAddress().getHostAddress();
        }
        return null;
    }
}

