/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.net.MalformedURLException;
import java.util.Random;
import java.util.regex.Pattern;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.DKSOverlayAddress;

public class DKSRef {
    DKSNetAddress netAddress = null;
    DKSOverlayAddress overlayAddress = null;
    long nonce;
    private static final Pattern dksUrl = Pattern.compile("^ *?dks://(.*?):(\\d*.?)/(\\d*?)/(\\d*?)/(\\d*?) *?$", 2);
    private static final Pattern dksRef = Pattern.compile("^ *?dksref://(.*?):(\\d*.?)/(\\d*?)/(\\d*?)/(\\d*?)/(\\d*?) *?$", 2);

    public static DKSRef newDKSRef(String dksURL) throws MalformedURLException {
        if (!dksUrl.matcher(dksURL).matches()) {
            throw new MalformedURLException("Only DKS scheme supported (dksref://<IP>:<PORT>/<GROUP_ID>/<NODE_ID>/<UNIQUE_GUID>)");
        }
        String colons = dksUrl.matcher(dksURL).replaceAll("$1:$2:$3:$4:$5");
        String[] sp = colons.split(":");
        DKSNetAddress netAddress = new DKSNetAddress(sp[0], Integer.parseInt(sp[1]));
        DKSOverlayAddress overlayAddress = new DKSOverlayAddress(Long.parseLong(sp[3]), Long.parseLong(sp[2]), Long.parseLong(sp[4]));
        long nonce = Math.abs(new Random().nextLong());
        return new DKSRef(overlayAddress, netAddress, nonce);
    }

    public static DKSRef valueOf(String dksREF) throws MalformedURLException {
        if (!dksRef.matcher(dksREF).matches()) {
            throw new MalformedURLException("Only DKSREF scheme supported (dksref://<IP>:<PORT>/<GROUP_ID>/<NODE_ID>/<UNIQUE_GUID>/<NONCE>)");
        }
        String colons = dksRef.matcher(dksREF).replaceAll("$1:$2:$3:$4:$5:$6");
        String[] sp = colons.split(":");
        DKSNetAddress netAddress = new DKSNetAddress(sp[0], Integer.parseInt(sp[1]));
        DKSOverlayAddress overlayAddress = new DKSOverlayAddress(Long.parseLong(sp[3]), Long.parseLong(sp[2]), Long.parseLong(sp[4]));
        long nonce = Math.abs(Long.parseLong(sp[5]));
        return new DKSRef(overlayAddress, netAddress, nonce);
    }

    public static DKSRef newDKSRefByParts(DKSOverlayAddress oa, DKSNetAddress na) {
        long nonce = Math.abs(new Random().nextLong());
        return new DKSRef(oa, na, nonce);
    }

    public static DKSRef valueOfByParts(DKSOverlayAddress oa, DKSNetAddress na, long nonce) {
        return new DKSRef(oa, na, nonce);
    }

    private DKSRef(DKSOverlayAddress oa, DKSNetAddress na, long nonce) {
        this.overlayAddress = oa;
        this.netAddress = na;
        this.nonce = Math.abs(nonce);
    }

    private DKSRef(String dksURL) throws MalformedURLException {
        if (!dksUrl.matcher(dksURL).matches()) {
            throw new MalformedURLException("Only DKS scheme supported (dks://<IP>:<PORT>/<GROUP_ID>/<NODE_ID>/<UNIQUE_GUID>)");
        }
        String colons = dksUrl.matcher(dksURL).replaceAll("$1:$2:$3:$4:$5");
        String[] sp = colons.split(":");
        this.netAddress = new DKSNetAddress(sp[0], Integer.parseInt(sp[1]));
        this.overlayAddress = new DKSOverlayAddress(Long.parseLong(sp[3]), Long.parseLong(sp[2]), Long.parseLong(sp[4]));
    }

    private DKSRef(int newPort, String newIP, long newId, long newGroupId, long newGUID) {
        this.netAddress = new DKSNetAddress(newIP, newPort);
        this.overlayAddress = new DKSOverlayAddress(newId, newGroupId, newGUID);
    }

    public String getDKSURL() {
        return "dksref://" + this.netAddress.getIP() + ":" + this.netAddress.getPort() + "/" + this.overlayAddress.getGroupId() + "/" + this.overlayAddress.getID() + "/" + this.overlayAddress.getGUID() + "/" + this.nonce;
    }

    public String getDKSWebURL() {
        return "http://" + this.netAddress.getIP() + ":" + (this.netAddress.getPort() + 1) + "/info/" + this.overlayAddress.getGroupId() + "/" + this.overlayAddress.getID() + "/" + this.overlayAddress.getGUID() + "/" + this.nonce;
    }

    public long getNonce() {
        return this.nonce;
    }

    public int getPort() {
        return this.netAddress.getPort();
    }

    public String getIP() {
        return this.netAddress.getIP();
    }

    public long getID() {
        return this.overlayAddress.getID();
    }

    public long getGUID() {
        return this.overlayAddress.getGroupId();
    }

    public long getR_GUID() {
        return this.overlayAddress.getGUID();
    }

    public DKSOverlayAddress getOverlayAddress() {
        return this.overlayAddress;
    }

    public DKSNetAddress getDKSNetAddress() {
        return this.netAddress;
    }

    public String toString() {
        return this.getDKSURL();
    }

    public boolean equals(Object b) {
        if (b == this) {
            return true;
        }
        if (!(b instanceof DKSRef)) {
            return false;
        }
        DKSRef r = (DKSRef)b;
        return this.overlayAddress.equals(r.overlayAddress) && this.nonce == r.nonce;
    }

    public int hashCode() {
        return this.overlayAddress.hashCode() + 37 * (int)(this.nonce ^ this.nonce >>> 32);
    }
}

