/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.net.MalformedURLException;
import java.util.regex.Pattern;

public class DKSOverlayAddress {
    private long id = 0L;
    private long groupId = 0L;
    private long guid = 0L;
    private static final Pattern dksUrl = Pattern.compile("^dksoverlay://(\\d*?)/(\\d*?)/(\\d*?)$", 2);

    public DKSOverlayAddress(long newId, long newGroupId, long newGUID) {
        this.id = newId;
        this.groupId = newGroupId;
        this.guid = newGUID;
    }

    public DKSOverlayAddress(String dksURL) throws MalformedURLException {
        if (!dksUrl.matcher(dksURL).matches()) {
            throw new MalformedURLException("Only DKSOverlay scheme supported (DKSOverlay://<GROUP_ID>/<NODE_ID>/<UNIQUE_GUID>)");
        }
        String colons = dksUrl.matcher(dksURL).replaceAll("$1:$2:$3");
        String[] sp = colons.split(":");
        this.groupId = Long.parseLong(sp[0]);
        this.id = Long.parseLong(sp[1]);
        this.guid = Long.parseLong(sp[2]);
    }

    public String getDKSOverlayURL() {
        return "DKSOverlay://" + this.groupId + "/" + this.id + "/" + this.guid;
    }

    public String toString() {
        return this.getDKSOverlayURL();
    }

    public long getID() {
        return this.id;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public long getGUID() {
        return this.guid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DKSOverlayAddress)) {
            return false;
        }
        DKSOverlayAddress addr = (DKSOverlayAddress)o;
        return addr.id == this.id && addr.groupId == this.groupId && addr.guid == this.guid;
    }

    public int hashCode() {
        int tmp = 17;
        tmp = 37 * tmp + (int)(this.id ^ this.id >>> 32);
        tmp = 37 * tmp + (int)(this.groupId ^ this.groupId >>> 32);
        tmp = 37 * tmp + (int)(this.guid ^ this.guid >>> 32);
        return tmp;
    }
}

