/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.net.MalformedURLException;
import java.util.regex.Pattern;

public class DKSNetAddress {
    private int port = 0;
    private String ip = null;
    private static final Pattern dksUrl = Pattern.compile("^dksnet://(.*?):(\\d*.?)$", 2);

    public DKSNetAddress(String dksURL) throws MalformedURLException {
        if (!dksUrl.matcher(dksURL).matches()) {
            throw new MalformedURLException("Only DKS scheme supported (dksnet://<IP>:<PORT>)");
        }
        String colons = dksUrl.matcher(dksURL).replaceAll("$1:$2");
        String[] sp = colons.split(":");
        this.ip = sp[0];
        this.port = Integer.parseInt(sp[1]);
    }

    public DKSNetAddress(String newip, int newport) {
        this.port = newport;
        this.ip = newip;
    }

    public String getDKSNetURL() {
        return "DKSNet://" + this.ip + ":" + this.port;
    }

    public String toString() {
        return this.getDKSNetURL();
    }

    public int getPort() {
        return this.port;
    }

    public String getIP() {
        return this.ip;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DKSNetAddress)) {
            return false;
        }
        DKSNetAddress addr = (DKSNetAddress)o;
        return this.port == addr.port && this.ip.equals(addr.ip);
    }

    public int hashCode() {
        int tmp = 17;
        tmp = 37 * tmp + this.port;
        tmp = 37 * tmp + this.ip.hashCode();
        return tmp;
    }
}

