/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.ConnectionHandler;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_comm.Listener;
import org.kth.dks.dks_comm.ListenerBlocking;
import org.kth.dks.dks_comm.ListenerNB;
import org.kth.dks.dks_comm.WebServer;
import org.kth.dks.dks_exceptions.DKSNodeAlreadyRegistered;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.MsgSrcDestWrapper;
import org.kth.dks.dks_node.DKSNode;
import org.kth.dks.util.CommunicationInfo;

public class ConnectionManager {
    private static ConnectionManager INSTANCE = null;
    private Logger log = Logger.getLogger(ConnectionManager.class);
    private boolean WEBSERVER = true;
    private Thread webServerThread = null;
    private WebServer webServer = null;
    Map nodes = Collections.synchronizedMap(new HashMap());
    private ConnectionHandler connHandler;
    private Listener listener = null;
    private CommMode commMode = CommMode.BLOCKING;
    private DKSMarshal dksMarshal = null;
    private int port = 0;
    private long globalRTT = 10000L;

    public static synchronized ConnectionManager newInstance(int port) throws IOException {
        return new ConnectionManager(port, null);
    }

    public ConnectionHandler getConnHandler() {
        return this.connHandler;
    }

    public static synchronized ConnectionManager getInstance(int port) throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionManager(port, null);
        }
        return INSTANCE;
    }

    public static synchronized ConnectionManager getInstanceMultiHome(int port, InetAddress bindAddr) throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionManager(port, bindAddr);
        }
        return INSTANCE;
    }

    public synchronized int getLocalPort() {
        return this.listener.getLocalPort();
    }

    public String getHostAddress() {
        return this.listener.getHostAddress();
    }

    private ConnectionManager(int _port, InetAddress bindAddr) throws IOException {
        this.port = _port;
        this.dksMarshal = new DKSMarshal(this);
        this.connHandler = new ConnectionHandler(this.dksMarshal, this);
        try {
            if (this.commMode == CommMode.BLOCKING) {
                this.listener = bindAddr == null ? new ListenerBlocking(this.port, this, this.dksMarshal, this.connHandler) : new ListenerBlocking(this.port, this, this.dksMarshal, this.connHandler, bindAddr);
            } else if (this.commMode == CommMode.NONBLOCKING) {
                this.listener = bindAddr == null ? new ListenerNB(this.port, this, this.dksMarshal, this.connHandler) : new ListenerNB(this.port, this, this.dksMarshal, this.connHandler, bindAddr);
            }
            if (this.WEBSERVER) {
                int webServerPort = this.listener.getLocalPort() + 1;
                this.webServer = new WebServer(this, webServerPort);
                this.webServerThread = new Thread((Runnable)this.webServer, WebServer.class.getName());
                this.webServerThread.start();
            }
        }
        catch (BindException be) {
            this.log.error((Object)("DKS port (" + this.port + ") already in use\n"));
            throw be;
        }
        catch (IOException ioex) {
            throw ioex;
        }
    }

    public void registerDKSNode(DKSRef _dksRef, DKSNode node) throws DKSNodeAlreadyRegistered {
        this.nodes.put(_dksRef.getOverlayAddress(), node);
        this.dksMarshal.registerDKSNode(_dksRef.getOverlayAddress());
    }

    public void unregisterDKSNode(DKSRef _dksRef) {
        this.dksMarshal.unregisterDKSNode(_dksRef.getOverlayAddress());
        this.nodes.remove(_dksRef.getDKSNetAddress());
    }

    public Collection getAllNodes() {
        return this.nodes.values();
    }

    long getGlobalRTT() {
        return this.globalRTT;
    }

    void setGlobalRTT(long newRTT) {
        this.globalRTT = newRTT;
        this.log.debug((Object)("New global RTT=" + this.globalRTT));
    }

    public boolean send(MsgSrcDestWrapper triple) {
        if (triple.getDest() == null || triple.getSrc() == null) {
            return false;
        }
        if (this.commMode == CommMode.BLOCKING) {
            return this.connHandler.send(triple);
        }
        return ((ListenerNB)this.listener).send(triple);
    }

    public void register(Object obj) {
    }

    public DKSMarshal getDKSMarshal() {
        return this.dksMarshal;
    }

    public void end() {
        this.connHandler.end();
        this.listener.end();
        this.listener.interrupt();
        this.dksMarshal.end();
    }

    public CommunicationInfo getComInfo() {
        int bRec = this.connHandler.getBytesRec();
        int mRec = this.connHandler.getMsgsRec();
        int bSent = this.connHandler.getBytesSent();
        int mSend = this.connHandler.getMsgsDelivered();
        int mUnacked = this.commMode == CommMode.BLOCKING ? this.connHandler.getMsgsUnacked() : this.connHandler.getMsgsUnackedNB();
        int mFailed = this.connHandler.getMsgsFailed();
        int cons = this.commMode == CommMode.BLOCKING ? this.connHandler.getNumConnections() : this.connHandler.getOpenConnections();
        int totalCons = this.commMode == CommMode.BLOCKING ? this.connHandler.getNumConnections() : this.connHandler.getTotalConnections();
        return new CommunicationInfo(bRec, mRec, bSent, mSend, mUnacked, mFailed, cons, totalCons);
    }

    public double getNodeRTT(DKSRef node) {
        return this.connHandler.getNodeRTT(node);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    private static class CommMode {
        public static final CommMode BLOCKING = new CommMode("BLOCKING");
        public static final CommMode NONBLOCKING = new CommMode("NONBLOCKING");
        private final String name;

        private CommMode(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

