/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.ConnHandlerIn;
import org.kth.dks.dks_comm.ConnHandlerOut;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_marshal.MsgSrcDestWrapper;
import org.kth.dks.util.Pair;

public class ConnectionHandler {
    private Logger log = Logger.getLogger(ConnectionHandler.class);
    private Map handlerMap = new HashMap();
    private int statMsgsDelivered = 0;
    private int statMsgsFailed = 0;
    private int statBytesReceived = 0;
    private int statMsgsReceived = 0;
    private int statBytesSent = 0;
    private int statOpenConnections = 0;
    private int statTotalConnections = 0;
    private int statUnackedMsgs = 0;
    private DKSMarshal marshal = null;
    private ConnectionManager cm;

    public ConnectionHandler(DKSMarshal m, ConnectionManager c) {
        this.marshal = m;
        this.cm = c;
    }

    public void statAddMsgsDelivered(int i) {
        this.statMsgsDelivered += i;
    }

    public void statAddMsgsFailed(int i) {
        this.statMsgsFailed += i;
    }

    public void statAddBytesReceived(int i) {
        this.statBytesReceived += i;
    }

    public void statAddMsgsReceived(int i) {
        this.statMsgsReceived += i;
    }

    public void statAddMsgsUnacked(int i) {
        this.statUnackedMsgs += i;
    }

    public void statAddBytesSent(int i) {
        this.statBytesSent += i;
    }

    public void statAddOpenConnection(int i) {
        this.statOpenConnections += i;
    }

    public void statAddTotalConnection(int i) {
        this.statTotalConnections += i;
    }

    public int getBytesRec() {
        return this.statBytesReceived;
    }

    public int getMsgsRec() {
        return this.statMsgsReceived;
    }

    public int getBytesSent() {
        return this.statBytesSent;
    }

    public int getMsgsDelivered() {
        return this.statMsgsDelivered;
    }

    public int getMsgsFailed() {
        return this.statMsgsFailed;
    }

    public int getNumConnections() {
        return this.handlerMap.size();
    }

    public int getOpenConnections() {
        return this.statOpenConnections;
    }

    public int getTotalConnections() {
        return this.statTotalConnections;
    }

    public int getMsgsUnackedNB() {
        return this.statUnackedMsgs;
    }

    public int getMsgsUnacked() {
        int acc = 0;
        Iterator it = this.handlerMap.values().iterator();
        while (it.hasNext()) {
            ConnHandlerOut cout = (ConnHandlerOut)((Pair)it.next()).second();
            acc += cout.getUnackedMsgs();
        }
        return acc;
    }

    public final DKSMarshal getDKSMarshal() {
        return this.marshal;
    }

    public double getNodeRTT(DKSRef node) {
        ConnHandlerOut cout;
        Pair p = node == null ? null : (Pair)this.handlerMap.get(node.getDKSNetAddress());
        ConnHandlerOut connHandlerOut = cout = p == null ? null : (ConnHandlerOut)p.second();
        if (cout == null) {
            return ConnHandlerOut.getDefaultRTO();
        }
        return cout.getRTO();
    }

    public synchronized void createConnection(Socket s, DKSNetAddress na) throws DKSRefNoResponse {
        ConnHandlerOut cout;
        if (this.handlerMap.containsKey(na)) {
            this.log.error((Object)("createConnection: A connection already exists to " + na));
            return;
        }
        if (s != null) {
            cout = new ConnHandlerOut(this, na, s);
        } else {
            DKSNetAddress myNA = new DKSNetAddress(this.cm.getHostAddress(), this.cm.getLocalPort());
            cout = new ConnHandlerOut(this, myNA, na);
            s = cout.getSocket();
        }
        ConnHandlerIn cin = new ConnHandlerIn(this, s, na, cout);
        this.handlerMap.put(na, new Pair(cin, cout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(DKSNetAddress n) {
        Map map = this.handlerMap;
        synchronized (map) {
            if (this.handlerMap.containsKey(n)) {
                Pair p = (Pair)this.handlerMap.get(n);
                ConnHandlerIn cin = (ConnHandlerIn)p.first();
                ConnHandlerOut cout = (ConnHandlerOut)p.second();
                cin.end();
                cout.end();
                this.handlerMap.remove(n);
            }
        }
    }

    public synchronized Set getAllPeers() {
        return new HashSet(this.handlerMap.keySet());
    }

    public synchronized boolean send(MsgSrcDestWrapper triple) {
        DKSNetAddress src = triple.getSrc().getDKSNetAddress();
        DKSNetAddress dest = triple.getDest().getDKSNetAddress();
        if (!this.handlerMap.containsKey(dest)) {
            try {
                this.createConnection(null, dest);
            }
            catch (DKSRefNoResponse ex) {
                return false;
            }
        }
        Pair p = (Pair)this.handlerMap.get(dest);
        ConnHandlerOut o = (ConnHandlerOut)p.second();
        o.sendMessage(src, triple);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        Map map = this.handlerMap;
        synchronized (map) {
            for (Pair p : this.handlerMap.values()) {
                ConnHandlerIn cin = (ConnHandlerIn)p.first();
                ConnHandlerOut cout = (ConnHandlerOut)p.second();
                cin.end();
                cout.end();
            }
        }
    }

    static {
        DKSMessage.addMessageTypePrefixed("BOOT", "dks_marshal.BootstrapMsg");
    }
}

