/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.ConnHandlerOutNB;
import org.kth.dks.dks_comm.ConnMessageTypes;
import org.kth.dks.dks_comm.ConnectionHandler;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.ListenerNB;
import org.kth.dks.dks_marshal.BootstrapMsg;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.DKSMessage;

public class ConnHandlerInNB
implements Runnable {
    private Logger log = Logger.getLogger(ConnHandlerInNB.class);
    private static final int BUFFSIZE = 4096;
    Status state = Status.INIT;
    private final DKSMarshal marshal;
    private DKSNetAddress destRef = null;
    private SocketChannel sock;
    private ConnHandlerOutNB connOut;
    private ByteBuffer buff = ByteBuffer.allocateDirect(4096);
    private ListenerNB listener;
    private ConnectionHandler connHandler;
    private SelectionKey key;
    private DKSNetAddress remoteNetAddr = null;
    ConnMessageTypes msgType;
    byte transType;
    int msgID;
    int msgSize;
    private byte[] varBuff = null;
    private int varBuffPos = 0;

    public ConnHandlerInNB(ListenerNB l, SocketChannel s, ConnHandlerOutNB co, DKSMarshal dm, ConnectionHandler ch) {
        this.sock = s;
        this.connOut = co;
        this.marshal = dm;
        this.listener = l;
        this.connHandler = ch;
        this.buff.order(ByteOrder.BIG_ENDIAN);
    }

    public synchronized void setRemoteAddress(DKSNetAddress netAdr) {
        this.remoteNetAddr = netAdr;
    }

    public synchronized void setKey(SelectionKey key) {
        this.key = key;
    }

    private void interestedRead() {
        if (this.key != null) {
            this.key.interestOps(this.key.interestOps() | 1);
            this.key.selector().wakeup();
        }
    }

    private boolean initH() {
        if (this.buff.remaining() < 1) {
            return false;
        }
        byte msgTypeByte = this.buff.get();
        this.msgType = ConnMessageTypes.valueOf(msgTypeByte);
        if (this.msgType == ConnMessageTypes.CONTENTS_MSG) {
            this.state = Status.CONTENT;
        } else if (this.msgType == ConnMessageTypes.ACK_MSG) {
            this.state = Status.ACK;
        } else if (this.msgType == ConnMessageTypes.PRESENT_MSG) {
            this.state = Status.READBLOCK;
        } else {
            this.log.error((Object)("ERROR: could not move out of INIT state:" + msgTypeByte));
        }
        return true;
    }

    private boolean contentH() {
        if (this.buff.remaining() < 1) {
            return false;
        }
        this.transType = this.buff.get();
        this.state = Status.CONTENT_TYPE;
        return true;
    }

    private boolean content_typeH() {
        if (this.buff.remaining() < 4) {
            return false;
        }
        this.msgID = this.buff.getInt();
        this.state = Status.READBLOCK;
        return true;
    }

    private boolean ackH() {
        if (this.buff.remaining() < 4) {
            return false;
        }
        this.msgID = this.buff.getInt();
        this.connOut.ackReceived(this.msgID);
        this.connHandler.statAddMsgsDelivered(1);
        this.state = Status.INIT;
        return true;
    }

    private boolean readblockH() {
        if (this.buff.remaining() < 4) {
            return false;
        }
        this.msgSize = this.buff.getInt();
        this.state = Status.READBLOCK_DATA;
        return true;
    }

    private boolean readblock_dataH() {
        if (this.buff.remaining() == 0) {
            return false;
        }
        int rSz = Math.min(this.buff.remaining(), this.msgSize - this.varBuffPos);
        if (this.varBuffPos == 0) {
            this.varBuff = new byte[this.msgSize];
        }
        this.buff.get(this.varBuff, this.varBuffPos, rSz);
        this.varBuffPos += rSz;
        if (this.varBuffPos == this.msgSize) {
            this.varBuffPos = 0;
            if (this.msgType == ConnMessageTypes.PRESENT_MSG) {
                this.fin_presH();
            } else if (this.msgType == ConnMessageTypes.CONTENTS_MSG) {
                this.fin_contH();
            }
        }
        return true;
    }

    private void fin_contH() {
        this.connOut.sendAck(this.msgID);
        if (!this.marshal.unmarshalDispatch(this.transType, this.varBuff, this.destRef)) {
            this.log.warn((Object)"Msg not accepted, CommunicationBuffer overflow");
        }
        this.varBuff = null;
        this.connHandler.statAddMsgsReceived(1);
        this.state = Status.INIT;
    }

    private void fin_presH() {
        BootstrapMsg m = (BootstrapMsg)DKSMessage.unmarshal(this.varBuff);
        this.varBuff = null;
        this.destRef = m.getNetAddress();
        this.listener.identifiedNode(this, this.destRef);
        this.state = Status.INIT;
    }

    private void stateMachine() {
        boolean cont = true;
        while (cont) {
            if (this.state == Status.INIT) {
                cont = this.initH();
                continue;
            }
            if (this.state == Status.CONTENT) {
                cont = this.contentH();
                continue;
            }
            if (this.state == Status.CONTENT_TYPE) {
                cont = this.content_typeH();
                continue;
            }
            if (this.state == Status.ACK) {
                cont = this.ackH();
                continue;
            }
            if (this.state == Status.READBLOCK) {
                cont = this.readblockH();
                continue;
            }
            if (this.state != Status.READBLOCK_DATA) continue;
            cont = this.readblock_dataH();
        }
    }

    @Override
    public void run() {
        this.read();
    }

    private synchronized void read() {
        int bytesRead = 0;
        try {
            bytesRead = this.sock.read(this.buff);
            this.connHandler.statAddBytesReceived(bytesRead);
            if (bytesRead > 0) {
                this.buff.flip();
                this.stateMachine();
                this.buff.compact();
            }
        }
        catch (IOException ex) {
            this.log.error((Object)("IOException inside ConnHandlerIn, should close this class:" + ex));
        }
        if (bytesRead < 0) {
            this.listener.connectionClosed(this.key, bytesRead, this.remoteNetAddr);
        } else {
            this.interestedRead();
        }
        this.log.debug((Object)("Got out " + bytesRead + " key:" + ((SocketChannel)this.key.channel()).socket().getInetAddress() + ":" + ((SocketChannel)this.key.channel()).socket().getPort()));
    }

    private static class Status {
        public static final Status INIT = new Status("INIT");
        public static final Status CONTENT = new Status("CONTENT");
        public static final Status CONTENT_TYPE = new Status("CONTENT_TYPE");
        public static final Status ACK = new Status("ACK");
        public static final Status READBLOCK = new Status("READBLOCK");
        public static final Status READBLOCK_DATA = new Status("READBLOCK_DATA");
        private final String name;

        private Status(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

