/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks.dks_comm;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.kth.dks.dks_comm.ConnHandlerOut;
import org.kth.dks.dks_comm.ConnMessageMiscs;
import org.kth.dks.dks_comm.ConnMessageTypes;
import org.kth.dks.dks_comm.ConnectionHandler;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_marshal.BootstrapMsg;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.DKSMessage;

public class ConnHandlerIn
extends Thread {
    private Logger log = Logger.getLogger(ConnHandlerIn.class);
    private Socket socket = null;
    private DKSNetAddress destRef = null;
    private ConnHandlerOut connOut = null;
    private final DKSMarshal marshal;
    private ConnectionHandler connHandler = null;

    public ConnHandlerIn(ConnectionHandler ch, Socket newSocket, DKSNetAddress dest, ConnHandlerOut out) {
        this.connHandler = ch;
        this.marshal = this.connHandler.getDKSMarshal();
        this.socket = newSocket;
        this.destRef = dest;
        this.connOut = out;
        if (dest == null) {
            this.log.debug((Object)"Creating a new received - accepting");
        } else {
            this.log.debug((Object)("Creating a new received - connecting:" + dest.toString()));
        }
        this.setName(ConnHandlerIn.class.getName() + "(" + dest + ")");
        this.start();
    }

    public void setConnOut(ConnHandlerOut c) {
        this.connOut = c;
    }

    void end() {
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        DataInputStream in = null;
        try {
            in = new DataInputStream(this.socket.getInputStream());
        }
        catch (IOException ioexp) {
            ioexp.printStackTrace();
        }
        if (this.connOut == null) {
            this.log.fatal((Object)"ConnHandlerIn: Major fault connOut == null");
            System.exit(0);
        }
        int msgID = 0;
        while (this.socket.isConnected()) {
            try {
                byte msgTypeByte = in.readByte();
                ConnMessageTypes msgType = ConnMessageTypes.valueOf(msgTypeByte);
                this.log.debug((Object)("MessageReceived " + msgType));
                if (msgType == ConnMessageTypes.CONTENTS_MSG) {
                    byte transType = in.readByte();
                    msgID = in.readInt();
                    byte[] buffer = ConnMessageMiscs.m_readDataBlock(in);
                    this.connOut.sendAck(msgID);
                    if (!this.marshal.unmarshalDispatch(transType, buffer, this.destRef)) {
                        this.log.warn((Object)"Msg not accepted, CommunicationBuffer overflow");
                    }
                    this.connHandler.statAddMsgsReceived(1);
                    this.connHandler.statAddBytesReceived(buffer.length);
                } else if (msgType == ConnMessageTypes.ACK_MSG) {
                    int msgId = in.readInt();
                    this.connOut.ackReceived(msgId);
                    this.connHandler.statAddMsgsDelivered(1);
                }
                if (msgType != ConnMessageTypes.PRESENT_MSG) continue;
                byte[] buffer = ConnMessageMiscs.m_readDataBlock(in);
                BootstrapMsg m = (BootstrapMsg)DKSMessage.unmarshal(buffer);
                this.destRef = m.getNetAddress();
            }
            catch (IOException ioexp) {
                this.connHandler.removeConnection(this.destRef);
                this.connOut.end();
                this.log.info((Object)("Socket " + this.destRef + " closed inside ConnHandlerIn()\n"));
                break;
            }
            catch (Exception exp) {
                this.connHandler.removeConnection(this.destRef);
                this.log.info((Object)("Socket " + this.destRef + " closed inside ConnHandlerIn()\n"));
                break;
            }
        }
        this.log.debug((Object)("Closing ConnHandlerIn to node " + this.destRef));
    }

    public DKSNetAddress getDKSNetAddress() {
        return this.destRef;
    }
}

