/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.kth.dks.DKSDHTInterface;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_dht.DKSDHTImpl;
import org.kth.dks.dks_exceptions.DKSIdentifierAlreadyTaken;
import org.kth.dks.dks_exceptions.DKSNodeAlreadyRegistered;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_exceptions.DKSTooManyRestartJoins;
import org.kth.dks.dks_node.DKSNode;

public class JDHT
implements Map {
    private int PORT = 4440;
    private DKSDHTInterface dht;
    private ConnectionManager cm;

    public JDHT() throws IOException {
        this.constructCreate();
    }

    public JDHT(int port) throws IOException {
        this.PORT = port;
        this.constructCreate();
    }

    public JDHT(String url) throws IOException, DKSTooManyRestartJoins, DKSIdentifierAlreadyTaken, DKSRefNoResponse {
        this.constructJoin(url);
    }

    public JDHT(int port, String url) throws IOException, DKSTooManyRestartJoins, DKSIdentifierAlreadyTaken, DKSRefNoResponse {
        this.PORT = port;
        this.constructJoin(url);
    }

    private void constructCreate() throws IOException {
        this.cm = ConnectionManager.getInstance(this.PORT);
        long id = Math.abs(new Random().nextLong()) % DKSNode.N;
        try {
            this.dht = new DKSDHTImpl(this.cm, new DKSOverlayAddress("dksoverlay://0/" + id + "/0"));
            this.dht.create();
        }
        catch (DKSNodeAlreadyRegistered ex) {
            this.cm.end();
            ex.printStackTrace();
        }
        catch (IOException ex) {
            this.cm.end();
            throw ex;
        }
    }

    private void constructJoin(String url) throws IOException, DKSTooManyRestartJoins, DKSIdentifierAlreadyTaken, DKSRefNoResponse {
        this.cm = ConnectionManager.getInstance(this.PORT);
        long id = Math.abs(new Random().nextLong()) % DKSNode.N;
        try {
            this.dht = new DKSDHTImpl(this.cm, new DKSOverlayAddress("dksoverlay://0/" + id + "/0"));
            DKSRef urlref = DKSRef.valueOf(url);
            this.dht.join(urlref);
        }
        catch (DKSNodeAlreadyRegistered ex) {
            this.cm.end();
            ex.printStackTrace();
        }
        catch (IOException ex) {
            this.cm.end();
            throw ex;
        }
    }

    public Object put(Object key, Object value) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(value);
            DKSObject val = new DKSObject(bout.toByteArray());
            this.dht.addToBinding(key.hashCode(), val);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Object get(Object key) {
        DKSObject[] ans = this.dht.lookupBinding(key.hashCode());
        if (ans == null) {
            return null;
        }
        DKSObject v = ans[0];
        ByteArrayInputStream bout = new ByteArrayInputStream(v.getData());
        try {
            ObjectInputStream in = new ObjectInputStream(bout);
            return in.readObject();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getReference() {
        return this.dht.getDKSURL();
    }

    public void close() {
        this.dht.leave();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.cm.end();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object remove(Object key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Set keySet() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Collection values() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

