/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.kth.dks.DKSObjectTypes;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class DKSObject {
    private Logger log = Logger.getLogger(DKSObject.class);
    private DKSObjectTypes type;
    private byte[] data;

    public DKSObject(byte[] newData) {
        this.data = newData;
        this.type = DKSObjectTypes.DEFAULT;
    }

    public DKSObject(DKSObjectTypes type, byte[] newData) {
        this.data = newData;
        this.type = type;
    }

    public DKSObject(String base64) {
        try {
            base64 = base64.replace(' ', '\n');
            byte[] decdata = new BASE64Decoder().decodeBuffer(base64);
            this.data = new byte[decdata.length - 1 - decdata[0]];
            System.arraycopy(decdata, 1 + decdata[0], this.data, 0, decdata.length - 1 - decdata[0]);
            char[] decstr = new char[decdata[0]];
            for (int i = 0; i < decstr.length; ++i) {
                decstr[i] = (char)decdata[i + 1];
            }
            this.type = DKSObjectTypes.valueOf(new String(decstr));
        }
        catch (IOException ex) {
            this.data = new byte[]{0};
            this.log.error((Object)"Couldn't unmarshal base64 string (DKSObject)");
            ex.printStackTrace();
        }
    }

    public DKSObjectTypes getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        char[] carr = this.type.getName().toCharArray();
        byte[] encdata = new byte[carr.length + 1 + this.data.length];
        for (int i = 0; i < carr.length; ++i) {
            encdata[i + 1] = (byte)carr[i];
        }
        encdata[0] = (byte)carr.length;
        System.arraycopy(this.data, 0, encdata, carr.length + 1, this.data.length);
        return new BASE64Encoder().encode(encdata);
    }
}

