/*
 * Decompiled with CFR 0.152.
 */
package org.kth.dks;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import org.kth.dks.DKSAppInterface;
import org.kth.dks.DKSCallbackInterface;
import org.kth.dks.DKSInterface;
import org.kth.dks.DKSObject;
import org.kth.dks.dks_comm.ConnectionManager;
import org.kth.dks.dks_comm.DKSNetAddress;
import org.kth.dks.dks_comm.DKSOverlayAddress;
import org.kth.dks.dks_comm.DKSRef;
import org.kth.dks.dks_exceptions.DKSIdentifierAlreadyTaken;
import org.kth.dks.dks_exceptions.DKSNodeAlreadyRegistered;
import org.kth.dks.dks_exceptions.DKSRefNoResponse;
import org.kth.dks.dks_exceptions.DKSTooManyRestartJoins;
import org.kth.dks.dks_marshal.DKSMarshal;
import org.kth.dks.dks_marshal.DKSMessage;
import org.kth.dks.dks_node.DKSNode;
import org.kth.dks.util.AsyncOperation;
import org.kth.dks.util.CommunicationInfo;
import org.kth.dks.util.MessageInfo;
import org.kth.dks.util.NodeInfo;

public class DKSImpl
implements DKSInterface,
DKSCallbackInterface {
    private static Logger log = Logger.getLogger(DKSImpl.class);
    protected DKSNode myDKSNode = null;
    protected ConnectionManager cm = null;
    protected DKSRef myDKSRef = null;

    public DKSImpl(ConnectionManager _cm, long nodeId, URL nodeAddress) throws DKSNodeAlreadyRegistered {
        this.cm = _cm;
        this.myDKSNode = new DKSNode();
        int port = nodeAddress.getPort();
        String ip = null;
        try {
            ip = InetAddress.getByName(nodeAddress.getHost()).getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            return;
        }
        this.myDKSRef = DKSRef.newDKSRefByParts(new DKSOverlayAddress(nodeId, 0L, 0L), new DKSNetAddress(ip, port));
        this.myDKSNode.setConnectionManager(this.cm, this.myDKSRef);
    }

    public DKSImpl(ConnectionManager _cm, DKSOverlayAddress over) throws DKSNodeAlreadyRegistered {
        this.cm = _cm;
        this.myDKSNode = new DKSNode();
        this.myDKSRef = DKSRef.newDKSRefByParts(over, new DKSNetAddress(this.cm.getHostAddress(), this.cm.getLocalPort()));
        this.myDKSNode.setConnectionManager(this.cm, this.myDKSRef);
    }

    public DKSImpl(ConnectionManager _cm, long nodeId, long gId, long GUID) throws DKSNodeAlreadyRegistered {
        this.cm = _cm;
        this.myDKSNode = new DKSNode();
        this.myDKSRef = DKSRef.newDKSRefByParts(new DKSOverlayAddress(nodeId, gId, GUID), new DKSNetAddress(this.cm.getHostAddress(), this.cm.getLocalPort()));
        this.myDKSNode.setConnectionManager(this.cm, this.myDKSRef);
    }

    @Override
    public String getDKSURL() {
        return this.myDKSRef.toString();
    }

    public void join(long existingnodeId, URL existingnodeAddress) throws DKSTooManyRestartJoins, DKSIdentifierAlreadyTaken {
        DKSRef dest = null;
        if (existingnodeAddress != null) {
            int port2 = existingnodeAddress.getPort();
            String ip2 = null;
            try {
                ip2 = InetAddress.getByName(existingnodeAddress.getHost()).getHostAddress();
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
                return;
            }
            dest = DKSRef.newDKSRefByParts(new DKSOverlayAddress(existingnodeId, 0L, 0L), new DKSNetAddress(ip2, port2));
        }
        AsyncOperation joinFuture = null;
        try {
            joinFuture = this.myDKSNode.newNode(this.myDKSRef, dest);
            if (joinFuture != null) {
                joinFuture.waitOn();
            }
        }
        catch (DKSTooManyRestartJoins ex) {
            throw ex;
        }
        catch (DKSIdentifierAlreadyTaken ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error((Object)("NewNode joinFuture interrupted!" + e));
        }
    }

    @Override
    public void create() {
        try {
            this.join(null);
        }
        catch (DKSTooManyRestartJoins ex) {
            log.fatal((Object)"Programming bug: creating a ring, but got TooManyRestartJoins in an empty ring");
        }
        catch (DKSRefNoResponse ex) {
            log.error((Object)"Programming bug: creating a ring, but join(null) responded with a DKSRefNoResponse");
        }
        catch (DKSIdentifierAlreadyTaken ex) {
            log.fatal((Object)("Already Taken identifier in an empty ring! Fatal Error!\n" + ex));
        }
    }

    @Override
    public void join(DKSRef existingnodeAddress) throws DKSTooManyRestartJoins, DKSIdentifierAlreadyTaken, DKSRefNoResponse {
        AsyncOperation joinFuture = null;
        try {
            joinFuture = this.myDKSNode.newNode(this.myDKSRef, existingnodeAddress);
            if (joinFuture != null) {
                log.debug((Object)"about to wait on future from DKSNOde.newNode()");
                joinFuture.waitOn();
            }
        }
        catch (DKSTooManyRestartJoins e) {
            throw e;
        }
        catch (DKSIdentifierAlreadyTaken ex) {
            throw ex;
        }
        catch (DKSRefNoResponse ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error((Object)("NewNode joinFuture interrupted!" + e));
        }
    }

    @Override
    public void logLevel(int level) {
    }

    @Override
    public void leave() {
        try {
            AsyncOperation endSync = null;
            endSync = this.myDKSNode.prepareForLeave();
            endSync.waitOn();
        }
        catch (Exception e) {
            log.error((Object)"Leave() endSync interrupted!");
        }
    }

    @Override
    public DKSRef findResponsible(long identifier) {
        DKSRef responsibleNode = null;
        AsyncOperation res = this.myDKSNode.findResponsible(identifier);
        try {
            responsibleNode = (DKSRef)res.waitOn();
        }
        catch (Exception ex) {
            log.error((Object)"findResponsible: AsyncOperation was interrupted or cancelled");
        }
        return responsibleNode;
    }

    @Override
    public DKSObject route(long identifier, DKSObject payload) {
        DKSObject responsePayload = null;
        AsyncOperation res = this.myDKSNode.route(identifier, payload);
        try {
            responsePayload = (DKSObject)res.waitOn();
        }
        catch (Exception ex) {
            log.error((Object)"route: AsyncOperation was interrupted or cancelled");
        }
        return responsePayload;
    }

    @Override
    public void routeAsync(long identifier, DKSObject payload) {
        this.myDKSNode.routeAsync(identifier, payload);
    }

    @Override
    public void routeAsyncFrom(long identifier, DKSObject payload, DKSRef firstNode) {
        this.myDKSNode.routeAsyncFrom(identifier, payload, false, firstNode);
    }

    @Override
    public void send(DKSRef target, DKSMessage message) {
        this.myDKSNode.send(target, message);
    }

    @Override
    public void broadcast(DKSObject message) {
        this.myDKSNode.broadCast(message);
    }

    @Override
    public void broadcastRestricted(DKSObject message, long startId, long endId) {
        this.myDKSNode.broadCastRestricted(message, startId, endId);
    }

    @Override
    public DKSCallbackInterface setCallbackHandler(DKSAppInterface appHandler) {
        return this.myDKSNode.setCallbackHandler(appHandler);
    }

    public NodeInfo getNodeInfo() {
        return this.myDKSNode.getNodeInfo();
    }

    public Serializable getDebugInfo() {
        return this.myDKSNode.getDebugInfo();
    }

    public CommunicationInfo getComInfo() {
        return this.myDKSNode.getComInfo();
    }

    public MessageInfo[] getMessageInfo() {
        return this.myDKSNode.getMessageInfo();
    }

    public DKSMarshal getDKSMarshal() {
        return this.myDKSNode.getDKSMarshal();
    }

    public long addressSpace() {
        return DKSNode.N;
    }

    public DKSNode getMyDKSNode() {
        return this.myDKSNode;
    }

    @Override
    public void unregisterNode() {
        this.cm.unregisterDKSNode(this.myDKSRef);
    }

    @Override
    public void joinCallbackReturn() {
        this.myDKSNode.joinCallbackReturn();
    }

    @Override
    public void leaveCallbackReturn() {
        this.myDKSNode.leaveCallbackReturn();
    }

    public ConnectionManager getCM() {
        return this.cm;
    }

    @Override
    public boolean addMsgHandler(DKSMessage msg, Object handlerObject, String methodName) {
        return this.myDKSNode.addMsgHandler(msg, handlerObject, methodName);
    }

    @Override
    public DKSRef getDKSRef() {
        return this.myDKSRef;
    }
}

