package org.kth.dks.planetlab.messages;

import java.io.IOException;

import org.kth.dks.dks_marshal.DKSMessage;

public class PongMsg extends DKSMessage {
	public static String NAME = "PONG";

	private long timestamp = 0;

	private String msgId;

	public PongMsg() {
	}

	public PongMsg(long c, String msgId) {
		this.timestamp = c;
		this.msgId = msgId;
	}

	public String getName() {
		return NAME;
	}

	public long getTimestamp() {
		return timestamp;
	}

	public String getMsgId() {
		return msgId;
	}

	public void marshal() throws IOException {
		marshaler.addLong(timestamp, "tstamp");
		marshaler.addString(msgId, "pongid");
	}

	public void unmarshal() throws IOException {
		timestamp = marshaler.remLong("tstamp");
		msgId = marshaler.remString("pongid");
	}
}
