package org.kth.dks.planetlab.messages;

import java.io.IOException;

import org.kth.dks.dks_marshal.DKSMessage;

public class PingMsg extends DKSMessage {
	public static String NAME = "PING";

	private long timestamp = 0;

	private String msgId;

	public PingMsg() {
	}

	public PingMsg(long c, String msgId) {
		this.timestamp = c;
		this.msgId = msgId;
	}

	public String getName() {
		return NAME;
	}

	public long getTimestamp() {
		return timestamp;
	}

	public String getMsgId() {
		return msgId;
	}

	public void marshal() throws IOException {
		marshaler.addLong(timestamp, "tstamp");
		marshaler.addString(msgId, "pingid");
	}

	public void unmarshal() throws IOException {
		timestamp = marshaler.remLong("tstamp");
		msgId = marshaler.remString("pingid");
	}
}
